/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.io.JalviewFileChooser;
import jalview.util.MessageManager;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGHints;
import org.jibble.epsgraphics.EpsGraphics2D;

public class ImageMaker {
    public static final String SVG_DESCRIPTION = "Scalable Vector Graphics";
    public static final String SVG_EXTENSION = "svg";
    public static final String EPS_DESCRIPTION = "Encapsulated Postscript";
    public static final String EPS_EXTENSION = "eps";
    public static final String PNG_EXTENSION = "png";
    public static final String PNG_DESCRIPTION = "Portable  network graphics";
    EpsGraphics2D pg;
    Graphics graphics;
    FileOutputStream out;
    BufferedImage bi;
    TYPE type;

    public ImageMaker(TYPE imageType, int width, int height, File file, String fileTitle, boolean useLineart) throws IOException {
        this.type = imageType;
        this.out = new FileOutputStream(file);
        switch (imageType) {
            case SVG: {
                this.setupSVG(width, height, useLineart);
                break;
            }
            case EPS: {
                this.setupEPS(width, height, fileTitle, useLineart);
                break;
            }
            case PNG: {
                this.setupPNG(width, height);
                break;
            }
        }
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void writeImage() {
        try {
            switch (this.type) {
                case EPS: {
                    this.pg.flush();
                    this.pg.close();
                    break;
                }
                case SVG: {
                    String svgData = ((SVGGraphics2D)this.getGraphics()).getSVGDocument();
                    this.out.write(svgData.getBytes());
                    this.out.flush();
                    this.out.close();
                    break;
                }
                case PNG: {
                    ImageIO.write((RenderedImage)this.bi, PNG_EXTENSION, this.out);
                    this.out.flush();
                    this.out.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setupPNG(int width, int height) {
        this.bi = new BufferedImage(width, height, 1);
        this.graphics = this.bi.getGraphics();
        Graphics2D ig2 = (Graphics2D)this.graphics;
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void setupSVG(int width, int height, boolean useLineart) {
        SVGGraphics2D g2 = new SVGGraphics2D(width, height);
        if (useLineart) {
            g2.setRenderingHint((RenderingHints.Key)SVGHints.KEY_DRAW_STRING_TYPE, SVGHints.VALUE_DRAW_STRING_TYPE_VECTOR);
        }
        this.graphics = g2;
    }

    protected void setupEPS(int width, int height, String title, boolean useLineart) throws IOException {
        EpsGraphics2D ig2 = this.pg = new EpsGraphics2D(title, this.out, 0, 0, width, height);
        ((Graphics2D)ig2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pg.setAccurateTextMode(useLineart);
        this.graphics = this.pg;
    }

    public static enum TYPE {
        EPS("EPS", MessageManager.getString("label.eps_file"), "eps", "Encapsulated Postscript"),
        PNG("PNG", MessageManager.getString("label.png_image"), "png", "Portable  network graphics"),
        SVG("SVG", "SVG", "svg", "Scalable Vector Graphics");

        public final String name;
        public final String label;
        public final String extension;
        public final String description;

        private TYPE(String name, String label, String ext, String desc) {
            this.name = name;
            this.label = label;
            this.extension = ext;
            this.description = desc;
        }

        public String getName() {
            return this.name;
        }

        public JalviewFileChooser getFileChooser() {
            return new JalviewFileChooser(this.extension, this.description);
        }

        public String getLabel() {
            return this.label;
        }
    }
}

