/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DnaUtils {
    public static List<int[]> parseLocation(String location) throws ParseException {
        if (location.startsWith("join(")) {
            return DnaUtils.parseJoin(location);
        }
        if (location.startsWith("complement(")) {
            return DnaUtils.parseComplement(location);
        }
        if (location.startsWith("order(")) {
            throw new ParseException(location, 0);
        }
        String[] range = location.split("\\.\\.");
        if (range.length == 1 || range.length == 2) {
            try {
                int start = Integer.valueOf(range[0]);
                int end = range.length == 1 ? start : Integer.valueOf(range[1]);
                return Collections.singletonList(new int[]{start, end});
            }
            catch (NumberFormatException e) {
                throw new ParseException(location, 0);
            }
        }
        throw new ParseException(location, 0);
    }

    static List<int[]> parseComplement(String location) throws ParseException {
        if (!location.endsWith(")")) {
            throw new ParseException(location, 0);
        }
        String toComplement = location.substring("complement(".length(), location.length() - 1);
        List<int[]> ranges = DnaUtils.parseLocation(toComplement);
        Collections.reverse(ranges);
        for (int[] range : ranges) {
            int temp = range[0];
            range[0] = range[1];
            range[1] = temp;
        }
        return ranges;
    }

    static List<int[]> parseJoin(String location) throws ParseException {
        String[] locations;
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (!location.endsWith(")")) {
            throw new ParseException(location, 0);
        }
        String joinedLocs = location.substring("join(".length(), location.length() - 1);
        for (String loc : locations = joinedLocs.split(",")) {
            List<int[]> range = DnaUtils.parseLocation(loc);
            ranges.addAll(range);
        }
        return ranges;
    }
}

