/*
 * Decompiled with CFR 0.152.
 */
package jalview.urls;

import jalview.util.MessageManager;
import jalview.util.UrlLink;
import java.util.ArrayList;
import java.util.List;

public class UrlLinkDisplay {
    public static final int DATABASE = 0;
    public static final int NAME = 1;
    public static final int URL = 2;
    public static final int SELECTED = 3;
    public static final int PRIMARY = 4;
    public static final int ID = 5;
    private static final List<String> COLNAMES = new ArrayList<String>(){
        {
            this.add(MessageManager.formatMessage("label.database", new Object[0]));
            this.add(MessageManager.formatMessage("label.name", new Object[0]));
            this.add(MessageManager.formatMessage("label.url", new Object[0]));
            this.add(MessageManager.formatMessage("label.inmenu", new Object[0]));
            this.add(MessageManager.formatMessage("label.primary", new Object[0]));
            this.add(MessageManager.formatMessage("label.id", new Object[0]));
        }
    };
    private String id;
    private boolean isPrimary;
    private boolean isSelected;
    private UrlLink link;

    public UrlLinkDisplay(String rowId, UrlLink rowLink, boolean rowSelected, boolean rowDefault) {
        this.id = rowId;
        this.isPrimary = rowDefault;
        this.isSelected = rowSelected;
        this.link = rowLink;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.link.getLabel();
    }

    public String getDBName() {
        return this.link.getTarget();
    }

    public String getUrl() {
        return this.link.getUrlWithToken();
    }

    public boolean getIsPrimary() {
        return this.isPrimary;
    }

    public boolean getIsSelected() {
        return this.isSelected;
    }

    public void setDBName(String name) {
        this.link.setTarget(name);
    }

    public void setUrl(String rowUrl) {
        this.link = new UrlLink(this.getDescription(), rowUrl, this.getDBName());
    }

    public void setDescription(String desc) {
        this.link.setLabel(desc);
    }

    public void setIsDefault(boolean rowDefault) {
        this.isPrimary = rowDefault;
    }

    public void setIsSelected(boolean rowSelected) {
        this.isSelected = rowSelected;
    }

    public Object getValue(int index) {
        switch (index) {
            case 5: {
                return this.id;
            }
            case 2: {
                return this.getUrl();
            }
            case 4: {
                return this.isPrimary;
            }
            case 3: {
                return this.isSelected;
            }
            case 1: {
                return this.getDescription();
            }
            case 0: {
                return this.getDBName();
            }
        }
        return null;
    }

    public void setValue(int index, Object value) {
        switch (index) {
            case 5: {
                this.id = (String)value;
                break;
            }
            case 2: {
                this.setUrl((String)value);
                break;
            }
            case 4: {
                this.isPrimary = (Boolean)value;
                break;
            }
            case 3: {
                this.isSelected = (Boolean)value;
                break;
            }
            case 1: {
                this.setDescription((String)value);
            }
            case 0: {
                this.setDBName((String)value);
                break;
            }
        }
    }

    public boolean isEditable(int index) {
        if (index == 4) {
            return !this.link.usesDBAccession();
        }
        return index == 3;
    }

    public static List<String> getDisplayColumnNames() {
        return COLNAMES.subList(0, 5);
    }
}

