/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.structure.StructureCommandI;
import java.util.ArrayList;
import java.util.List;

public class StructureCommand
implements StructureCommandI {
    private String command;
    private List<String> parameters;

    public StructureCommand(String cmd, String ... params) {
        this.command = cmd;
        if (params != null) {
            for (String p : params) {
                this.addParameter(p);
            }
        }
    }

    @Override
    public void addParameter(String param) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.add(param);
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public String toString() {
        if (!this.hasParameters()) {
            return this.command;
        }
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.command).append("(");
        boolean first = true;
        for (String p : this.parameters) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(p);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        int h = this.command.hashCode();
        if (this.parameters != null) {
            for (String p : this.parameters) {
                h = h * 37 + p.hashCode();
            }
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StructureCommand)) {
            return false;
        }
        StructureCommand sc = (StructureCommand)obj;
        if (!this.command.equals(sc.command)) {
            return false;
        }
        if (this.parameters == null || sc.parameters == null) {
            return this.parameters == null && sc.parameters == null;
        }
        int j = this.parameters.size();
        if (j != sc.parameters.size()) {
            return false;
        }
        for (int i = 0; i < j; ++i) {
            if (this.parameters.get(i).equals(sc.parameters.get(i))) continue;
            return false;
        }
        return true;
    }
}

