/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AtomSpecModel {
    private Map<String, Map<String, BitSet>> atomSpec = new TreeMap<String, Map<String, BitSet>>();

    public void addRange(String model, int startPos, int endPos, String chain) {
        BitSet chainData;
        Map<String, BitSet> modelData = this.atomSpec.get(model);
        if (modelData == null) {
            modelData = new TreeMap<String, BitSet>();
            this.atomSpec.put(model, modelData);
        }
        if ((chainData = modelData.get(chain)) == null) {
            chainData = new BitSet();
            modelData.put(chain, chainData);
        }
        chainData.set(startPos, endPos + 1);
    }

    public Iterable<String> getModels() {
        return this.atomSpec.keySet();
    }

    public int getModelCount() {
        return this.atomSpec.size();
    }

    public Iterable<String> getChains(String model) {
        return this.atomSpec.containsKey(model) ? this.atomSpec.get(model).keySet() : null;
    }

    public List<int[]> getRanges(String model, String chain) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (this.atomSpec.containsKey(model)) {
            BitSet bs = this.atomSpec.get(model).get(chain);
            int start = 0;
            if (bs != null) {
                start = bs.nextSetBit(start);
                int end = 0;
                while (start != -1) {
                    end = bs.nextClearBit(start);
                    ranges.add(new int[]{start, end - 1});
                    start = bs.nextSetBit(end);
                }
            }
        }
        return ranges;
    }
}

