/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.IdColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.PurinePyrimidineColourScheme;
import jalview.schemes.RNAHelicesColour;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TCoffeeColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;

public enum JalviewColourScheme {
    Clustal("Clustal", ClustalxColourScheme.class),
    Blosum62("Blosum62", Blosum62ColourScheme.class),
    PID("% Identity", PIDColourScheme.class),
    Zappo("Zappo", ZappoColourScheme.class),
    Taylor("Taylor", TaylorColourScheme.class),
    Hydrophobic("Hydrophobic", HydrophobicColourScheme.class),
    Helix("Helix Propensity", HelixColourScheme.class),
    Strand("Strand Propensity", StrandColourScheme.class),
    Turn("Turn Propensity", TurnColourScheme.class),
    Buried("Buried Index", BuriedColourScheme.class),
    Nucleotide("Nucleotide", NucleotideColourScheme.class),
    PurinePyrimidine("Purine/Pyrimidine", PurinePyrimidineColourScheme.class),
    RNAHelices("RNA Helices", RNAHelicesColour.class),
    TCoffee("T-Coffee Scores", TCoffeeColourScheme.class),
    IdColour("Sequence ID", IdColourScheme.class);

    private String name;
    private Class<? extends ColourSchemeI> myClass;

    private JalviewColourScheme(String s, Class<? extends ColourSchemeI> cl) {
        this.name = s;
        this.myClass = cl;
    }

    public Class<? extends ColourSchemeI> getSchemeClass() {
        return this.myClass;
    }

    public String toString() {
        return this.name;
    }
}

