/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.FeatureColourI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.features.FeatureMatcher;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.util.MessageManager;
import java.awt.Color;
import java.util.StringTokenizer;

public class FeatureColour
implements FeatureColourI {
    private static final String I18N_LABEL = MessageManager.getString("label.label");
    private static final String I18N_SCORE = MessageManager.getString("label.score");
    private static final String ABSOLUTE = "abso";
    private static final String ABOVE = "above";
    private static final String BELOW = "below";
    private static final String LABEL = "label";
    private static final String SCORE = "score";
    private static final String ATTRIBUTE = "attribute";
    private static final String NO_VALUE_MIN = "noValueMin";
    private static final String NO_VALUE_MAX = "noValueMax";
    private static final String NO_VALUE_NONE = "noValueNone";
    static final Color DEFAULT_NO_COLOUR = null;
    private static final String BAR = "|";
    private final Color colour;
    private final Color minColour;
    private final Color maxColour;
    private final Color noColour;
    private boolean graduatedColour;
    private boolean colourByLabel;
    private String[] attributeName;
    private float threshold;
    private float base;
    private float range;
    private boolean belowThreshold;
    private boolean aboveThreshold;
    private boolean isHighToLow;
    private boolean autoScaled;
    private final float minRed;
    private final float minGreen;
    private final float minBlue;
    private final float deltaRed;
    private final float deltaGreen;
    private final float deltaBlue;

    /*
     * Unable to fully structure code
     */
    public static FeatureColourI parseJalviewFeatureColour(String descriptor) {
        gcol = new StringTokenizer(descriptor, "|", true);
        min = 1.4E-45f;
        max = 3.4028235E38f;
        byLabel = false;
        byAttribute = false;
        attName = null;
        mincol = null;
        maxcol = null;
        nextToken = gcol.nextToken();
        if (nextToken == "|") {
            throw new IllegalArgumentException("Expected either 'label' or a colour specification in the line: " + descriptor);
        }
        if (nextToken.toLowerCase().startsWith("label")) {
            byLabel = true;
            mincol = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
            mincol = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
        } else if (nextToken.toLowerCase().startsWith("score")) {
            mincol = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
            mincol = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
        } else if (nextToken.toLowerCase().startsWith("attribute")) {
            byAttribute = true;
            attName = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
            attName = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
            mincol = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
            mincol = gcol.hasMoreTokens() != false ? gcol.nextToken() : null;
        } else {
            mincol = nextToken;
        }
        if (!gcol.hasMoreTokens()) {
            if (byLabel || byAttribute) {
                fc = new FeatureColour();
                fc.setColourByLabel(true);
                if (byAttribute) {
                    fc.setAttributeName(FeatureMatcher.fromAttributeDisplayName(attName));
                }
                return fc;
            }
            colour = ColorUtils.parseColourString(descriptor);
            if (colour == null) {
                throw new IllegalArgumentException("Invalid colour descriptor: " + descriptor);
            }
            return new FeatureColour(colour);
        }
        autoScaled = true;
        tok = null;
        noValueColour = "noValueMin";
        if (mincol != null) {
            if (mincol.equals("|")) {
                mincol = null;
            } else {
                gcol.nextToken();
            }
            maxcol = gcol.nextToken();
            if (maxcol.equals("|")) {
                maxcol = null;
            } else {
                gcol.nextToken();
            }
            tok = gcol.nextToken();
            if (tok.equalsIgnoreCase("noValueMin")) {
                tok = gcol.nextToken();
                tok = gcol.nextToken();
            } else if (tok.equalsIgnoreCase("noValueMax")) {
                noValueColour = "noValueMax";
                tok = gcol.nextToken();
                tok = gcol.nextToken();
            } else if (tok.equalsIgnoreCase("noValueNone")) {
                noValueColour = "noValueNone";
                tok = gcol.nextToken();
                tok = gcol.nextToken();
            }
            gcol.nextToken();
            if (tok.toLowerCase().startsWith("abso")) {
                minval = gcol.nextToken();
                gcol.nextToken();
                autoScaled = false;
            } else {
                minval = tok;
            }
            maxval = gcol.nextToken();
            if (gcol.hasMoreTokens()) {
                gcol.nextToken();
            }
            try {
                if (minval.length() > 0) {
                    min = Float.valueOf(minval).floatValue();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't parse the minimum value for graduated colour ('" + minval + "')");
            }
            try {
                if (maxval.length() <= 0) ** GOTO lbl97
                max = Float.valueOf(maxval).floatValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't parse the maximum value for graduated colour (" + descriptor + ")");
            }
        } else {
            mincol = "white";
            maxcol = "black";
            byLabel = true;
        }
lbl97:
        // 3 sources

        try {
            minColour = ColorUtils.parseColourString(mincol);
            maxColour = ColorUtils.parseColourString(maxcol);
            noColour = noValueColour.equals("noValueMax") != false ? maxColour : (noValueColour.equals("noValueNone") != false ? null : minColour);
            featureColour = new FeatureColour(maxColour, minColour, maxColour, noColour, min, max);
            featureColour.setColourByLabel(minColour == null);
            featureColour.setAutoScaled(autoScaled);
            if (byAttribute) {
                featureColour.setAttributeName(FeatureMatcher.fromAttributeDisplayName(attName));
            }
            ttype = null;
            tval = null;
            if (gcol.hasMoreTokens()) {
                ttype = gcol.nextToken();
                if (ttype.toLowerCase().startsWith("below")) {
                    featureColour.setBelowThreshold(true);
                } else if (ttype.toLowerCase().startsWith("above")) {
                    featureColour.setAboveThreshold(true);
                } else if (!ttype.toLowerCase().startsWith("no")) {
                    System.err.println("Ignoring unrecognised threshold type : " + ttype);
                }
            }
            if (featureColour.hasThreshold()) {
                try {
                    gcol.nextToken();
                    tval = gcol.nextToken();
                    featureColour.setThreshold(Float.valueOf(tval).floatValue());
                }
                catch (Exception e) {
                    System.err.println("Couldn't parse threshold value as a float: (" + tval + ")");
                }
            }
            if (gcol.hasMoreTokens()) {
                System.err.println("Ignoring additional tokens in parameters in graduated colour specification\n");
                while (gcol.hasMoreTokens()) {
                    System.err.println("|" + gcol.nextToken());
                }
                System.err.println("\n");
            }
            return featureColour;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public FeatureColour() {
        this((Color)null);
    }

    public FeatureColour(Color c) {
        this(c, c == null ? Color.white : ColorUtils.bleachColour(c, 0.9f), c == null ? Color.black : c, DEFAULT_NO_COLOUR, 0.0f, 0.0f);
        this.setGraduatedColour(false);
    }

    public FeatureColour(FeatureColour fc) {
        this.graduatedColour = fc.graduatedColour;
        this.colour = fc.colour;
        this.minColour = fc.minColour;
        this.maxColour = fc.maxColour;
        this.noColour = fc.noColour;
        this.minRed = fc.minRed;
        this.minGreen = fc.minGreen;
        this.minBlue = fc.minBlue;
        this.deltaRed = fc.deltaRed;
        this.deltaGreen = fc.deltaGreen;
        this.deltaBlue = fc.deltaBlue;
        this.base = fc.base;
        this.range = fc.range;
        this.isHighToLow = fc.isHighToLow;
        this.attributeName = fc.attributeName;
        this.setAboveThreshold(fc.isAboveThreshold());
        this.setBelowThreshold(fc.isBelowThreshold());
        this.setThreshold(fc.getThreshold());
        this.setAutoScaled(fc.isAutoScaled());
        this.setColourByLabel(fc.isColourByLabel());
    }

    public FeatureColour(Color myColour, Color low, Color high, Color noValueColour, float min, float max) {
        if (low == null) {
            low = Color.white;
        }
        if (high == null) {
            high = Color.black;
        }
        this.colour = myColour;
        this.minColour = low;
        this.maxColour = high;
        this.setGraduatedColour(true);
        this.noColour = noValueColour;
        this.threshold = Float.NaN;
        this.isHighToLow = min >= max;
        this.minRed = (float)low.getRed() / 255.0f;
        this.minGreen = (float)low.getGreen() / 255.0f;
        this.minBlue = (float)low.getBlue() / 255.0f;
        this.deltaRed = (float)high.getRed() / 255.0f - this.minRed;
        this.deltaGreen = (float)high.getGreen() / 255.0f - this.minGreen;
        this.deltaBlue = (float)high.getBlue() / 255.0f - this.minBlue;
        if (this.isHighToLow) {
            this.base = max;
            this.range = min - max;
        } else {
            this.base = min;
            this.range = max - min;
        }
    }

    @Override
    public boolean isGraduatedColour() {
        return this.graduatedColour;
    }

    public void setGraduatedColour(boolean b) {
        this.graduatedColour = b;
        if (b) {
            this.setColourByLabel(false);
        }
    }

    @Override
    public Color getColour() {
        return this.colour;
    }

    @Override
    public Color getMinColour() {
        return this.minColour;
    }

    @Override
    public Color getMaxColour() {
        return this.maxColour;
    }

    @Override
    public Color getNoColour() {
        return this.noColour;
    }

    @Override
    public boolean isColourByLabel() {
        return this.colourByLabel;
    }

    @Override
    public void setColourByLabel(boolean b) {
        this.colourByLabel = b;
        if (b) {
            this.setGraduatedColour(false);
        }
    }

    @Override
    public boolean isBelowThreshold() {
        return this.belowThreshold;
    }

    @Override
    public void setBelowThreshold(boolean b) {
        this.belowThreshold = b;
        if (b) {
            this.setAboveThreshold(false);
        }
    }

    @Override
    public boolean isAboveThreshold() {
        return this.aboveThreshold;
    }

    @Override
    public void setAboveThreshold(boolean b) {
        this.aboveThreshold = b;
        if (b) {
            this.setBelowThreshold(false);
        }
    }

    @Override
    public float getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(float f) {
        this.threshold = f;
    }

    @Override
    public boolean isAutoScaled() {
        return this.autoScaled;
    }

    @Override
    public void setAutoScaled(boolean b) {
        this.autoScaled = b;
    }

    @Override
    public void updateBounds(float min, float max) {
        if (max < min) {
            this.base = max;
            this.range = min - max;
            this.isHighToLow = true;
        } else {
            this.base = min;
            this.range = max - min;
            this.isHighToLow = false;
        }
    }

    @Override
    public Color getColor(SequenceFeature feature) {
        if (this.isColourByLabel()) {
            String label = this.attributeName == null ? feature.getDescription() : feature.getValueAsString(this.attributeName);
            return label == null ? this.noColour : ColorUtils.createColourFromName(label);
        }
        if (!this.isGraduatedColour()) {
            return this.getColour();
        }
        float scr = feature.getScore();
        if (this.attributeName != null) {
            try {
                String attVal = feature.getValueAsString(this.attributeName);
                scr = Float.valueOf(attVal).floatValue();
            }
            catch (Throwable e) {
                scr = Float.NaN;
            }
        }
        if (Float.isNaN(scr)) {
            return this.noColour;
        }
        if (this.isAboveThreshold() && scr <= this.threshold) {
            return null;
        }
        if (this.isBelowThreshold() && scr >= this.threshold) {
            return null;
        }
        if ((double)this.range == 0.0) {
            return this.getMaxColour();
        }
        float scl = (scr - this.base) / this.range;
        if (this.isHighToLow) {
            scl = -scl;
        }
        if (scl < 0.0f) {
            scl = 0.0f;
        }
        if (scl > 1.0f) {
            scl = 1.0f;
        }
        return new Color(this.minRed + scl * this.deltaRed, this.minGreen + scl * this.deltaGreen, this.minBlue + scl * this.deltaBlue);
    }

    @Override
    public float getMax() {
        return this.isHighToLow ? this.base : this.base + this.range;
    }

    @Override
    public float getMin() {
        return this.isHighToLow ? this.base + this.range : this.base;
    }

    @Override
    public boolean isSimpleColour() {
        return !this.isColourByLabel() && !this.isGraduatedColour();
    }

    @Override
    public boolean hasThreshold() {
        return this.isAboveThreshold() || this.isBelowThreshold();
    }

    @Override
    public String toJalviewFormat(String featureType) {
        String colourString = null;
        if (this.isSimpleColour()) {
            colourString = Format.getHexString(this.getColour());
        } else {
            StringBuilder sb = new StringBuilder(32);
            if (this.isColourByAttribute()) {
                sb.append(ATTRIBUTE).append(BAR);
                sb.append(FeatureMatcher.toAttributeDisplayName(this.getAttributeName()));
            } else if (this.isColourByLabel()) {
                sb.append(LABEL);
            } else {
                sb.append(SCORE);
            }
            if (this.isGraduatedColour()) {
                sb.append(BAR).append(Format.getHexString(this.getMinColour())).append(BAR);
                sb.append(Format.getHexString(this.getMaxColour())).append(BAR);
                String noValue = NO_VALUE_MIN;
                if (this.maxColour.equals(this.noColour)) {
                    noValue = NO_VALUE_MAX;
                }
                if (this.noColour == null) {
                    noValue = NO_VALUE_NONE;
                }
                sb.append(noValue).append(BAR);
                if (!this.isAutoScaled()) {
                    sb.append(ABSOLUTE).append(BAR);
                }
            } else if (this.hasThreshold()) {
                sb.append(BAR).append(BAR).append(BAR);
            }
            if (this.hasThreshold() || this.isGraduatedColour()) {
                sb.append(this.getMin()).append(BAR);
                sb.append(this.getMax()).append(BAR);
                if (this.isBelowThreshold()) {
                    sb.append(BELOW).append(BAR).append(this.getThreshold());
                } else if (this.isAboveThreshold()) {
                    sb.append(ABOVE).append(BAR).append(this.getThreshold());
                } else {
                    sb.append("none");
                }
            }
            colourString = sb.toString();
        }
        return String.format("%s\t%s", featureType, colourString);
    }

    @Override
    public boolean isColourByAttribute() {
        return this.attributeName != null;
    }

    @Override
    public String[] getAttributeName() {
        return this.attributeName;
    }

    @Override
    public void setAttributeName(String ... name) {
        this.attributeName = name;
    }

    @Override
    public boolean isOutwithThreshold(SequenceFeature feature) {
        if (!this.isGraduatedColour()) {
            return false;
        }
        float scr = feature.getScore();
        if (this.attributeName != null) {
            try {
                String attVal = feature.getValueAsString(this.attributeName);
                scr = Float.valueOf(attVal).floatValue();
            }
            catch (Throwable e) {
                scr = Float.NaN;
            }
        }
        if (Float.isNaN(scr)) {
            return false;
        }
        return this.isAboveThreshold() && scr <= this.threshold || this.isBelowThreshold() && scr >= this.threshold;
    }

    @Override
    public String getDescription() {
        if (this.isSimpleColour()) {
            return "r=" + this.colour.getRed() + ",g=" + this.colour.getGreen() + ",b=" + this.colour.getBlue();
        }
        StringBuilder tt = new StringBuilder();
        String by = null;
        by = this.getAttributeName() != null ? FeatureMatcher.toAttributeDisplayName(this.getAttributeName()) : (this.isColourByLabel() ? I18N_LABEL : I18N_SCORE);
        tt.append(MessageManager.formatMessage("action.by_title_param", by));
        if (this.isAboveThreshold() || this.isBelowThreshold()) {
            tt.append(" (");
            if (this.isColourByLabel()) {
                tt.append(I18N_SCORE).append(" ");
            }
            tt.append(this.isAboveThreshold() ? "> " : "< ");
            tt.append(this.getThreshold()).append(")");
        }
        return tt.toString();
    }
}

