/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColourSchemes {
    private static ColourSchemes instance = new ColourSchemes();
    private Map<String, ColourSchemeI> schemes;

    public static ColourSchemes getInstance() {
        return instance;
    }

    private ColourSchemes() {
        this.loadColourSchemes();
    }

    void loadColourSchemes() {
        this.schemes = new LinkedHashMap<String, ColourSchemeI>();
        for (JalviewColourScheme cs : JalviewColourScheme.values()) {
            try {
                this.registerColourScheme(cs.getSchemeClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException e) {
                System.err.println("Error instantiating colour scheme for " + cs.toString() + " " + e.getMessage());
                e.printStackTrace();
            }
            catch (ReflectiveOperationException roe) {
                roe.printStackTrace();
            }
        }
    }

    public void registerColourScheme(ColourSchemeI cs) {
        String name = cs.getSchemeName();
        if (name == null) {
            System.err.println("ColourScheme name may not be null");
            return;
        }
        String lower = name.toLowerCase();
        if (this.schemes.containsKey(lower)) {
            System.err.println("Warning: overwriting colour scheme named " + name);
        }
        this.schemes.put(lower, cs);
    }

    public void removeColourScheme(String name) {
        if (name != null) {
            this.schemes.remove(name.toLowerCase());
        }
    }

    public ColourSchemeI getColourScheme(String name, AlignViewportI viewport, AnnotatedCollectionI forData, Map<SequenceI, SequenceCollectionI> hiddenRepSequences) {
        if (name == null) {
            return null;
        }
        ColourSchemeI cs = this.schemes.get(name.toLowerCase());
        return cs == null ? null : cs.getInstance(viewport, forData);
    }

    public ColourSchemeI getColourScheme(String name, AnnotatedCollectionI forData) {
        return this.getColourScheme(name, null, forData, null);
    }

    public Iterable<ColourSchemeI> getColourSchemes() {
        return this.schemes.values();
    }

    public boolean nameExists(String name) {
        if (name == null) {
            return false;
        }
        return this.schemes.containsKey(name.toLowerCase());
    }
}

