/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.rest.API;
import jalview.rest.AbstractEndpoint;
import jalview.structure.StructureSelectionManager;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HighlightSequenceEndpoint
extends AbstractEndpoint {
    protected static final String path = "highlightsequence";
    private static final String name = "Highlight sequence position";
    private static final String parameters = "<sequence names>/<position>";
    private static final String description = "Highlight the specified sequences at the specified position";

    public HighlightSequenceEndpoint(API api) {
        super(api, path, name, parameters, description);
    }

    @Override
    public void processEndpoint(HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkParameters(request, response, 2)) {
            return;
        }
        String[] parameters = this.getEndpointPathParameters(request);
        String posString = parameters[1];
        int pos = -1;
        try {
            pos = Integer.parseInt(posString);
        }
        catch (NumberFormatException e) {
            this.returnError(request, response, "Could not parse postition integer " + posString);
        }
        String sequenceNames = parameters[0];
        HashMap<SequenceI, StructureSelectionManager> ssmMap = new HashMap<SequenceI, StructureSelectionManager>();
        AlignFrame[] alignFrames = this.getAlignFrames(request, true);
        if (alignFrames == null) {
            this.returnError(request, response, "could not find results");
            return;
        }
        for (int i = 0; i < alignFrames.length; ++i) {
            AlignFrame af = alignFrames[i];
            List<? extends AlignmentViewPanel> aps = af.getAlignPanels();
            for (AlignmentViewPanel alignmentViewPanel : aps) {
                StructureSelectionManager ssm = alignmentViewPanel.getStructureSelectionManager();
                AlignmentI al = alignmentViewPanel.getAlignment();
                List<SequenceI> seqs = al.getSequences();
                for (SequenceI seq : seqs) {
                    if (!sequenceNames.equals(seq.getName())) continue;
                    ssmMap.put(seq, ssm);
                }
            }
        }
        for (SequenceI seq : ssmMap.keySet()) {
            StructureSelectionManager ssm = (StructureSelectionManager)ssmMap.get(seq);
            if (ssm == null) continue;
            ssm.mouseOverSequence(seq, pos, -1, null);
        }
    }
}

