/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.bin.Cache;
import jalview.rest.API;
import jalview.rest.AbstractEndpoint;
import jalview.rest.RestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractEndpointAsync
extends AbstractEndpoint {
    protected String idExtension = null;
    protected String id = null;
    protected CompletableFuture<Void> cf = null;
    protected Map<String, CompletableFuture<Void>> cfMap = new HashMap<String, CompletableFuture<Void>>();
    protected Map<String, Object> objectsPassedToProcessAsync = new HashMap<String, Object>();
    private RestHandler.Status tempStatus = null;

    public AbstractEndpointAsync(API api, String path, String name, String parameters, String description) {
        super(api, path, name, parameters, description);
    }

    protected void setCompletableFuture(CompletableFuture<Void> cf) {
        this.cf = cf;
        if (this.getId() != null) {
            this.cfMap.put(this.getId(), cf);
        }
    }

    protected CompletableFuture<Void> getCompletableFuture() {
        if (this.cf == null && this.getId() != null && this.cfMap.get(this.getId()) != null) {
            this.cf = this.cfMap.get(this.getId());
        }
        return this.cf;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setIdExtension(String idExtension) {
        this.setId(this.getPath() + "::" + idExtension);
    }

    protected String getId() {
        return this.id;
    }

    protected void initialise(HttpServletRequest request, HttpServletResponse response) {
        this.setId(request, null);
    }

    protected abstract void processAsync(HttpServletRequest var1, HttpServletResponse var2, Map<String, Object> var3);

    protected void finalise(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public void processEndpoint(HttpServletRequest request, HttpServletResponse response) {
        this.tempStatus = null;
        this.initialise(request, response);
        if (this.checkStatus(request, response, RestHandler.Status.STARTED)) {
            String alreadyFinishedString = null;
            if (this.getStatus() == RestHandler.Status.FINISHED) {
                alreadyFinishedString = this.finishedResponseString(request, response);
            }
            this.returnStatus(request, response, alreadyFinishedString);
            return;
        }
        if (this.getCompletableFuture() == null) {
            Map<String, Object> finalObjectMap = this.objectsPassedToProcessAsync;
            this.setCompletableFuture(CompletableFuture.runAsync(() -> {
                try {
                    this.processAsync(request, response, finalObjectMap);
                }
                catch (ClassCastException e) {
                    Cache.info("Something went wrong with async endpoint execution" + this.getName());
                    Cache.error(e);
                }
            }));
        }
        this.addWhenCompleteCompletableFuture();
        this.finalise(request, response);
        this.returnStatus(response);
        this.changeStatus(RestHandler.Status.IN_PROGRESS);
    }

    protected void atEnd() {
    }

    protected String finishedResponseString(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    protected String setId(HttpServletRequest request, String extension) {
        String idString = request.getParameter("id");
        if (idString == null) {
            this.setIdExtension(extension);
        } else {
            this.setId(idString);
        }
        return this.getId();
    }

    protected void changeStatus(RestHandler.Status status) {
        String id = this.getId();
        if (this.getStatus() == RestHandler.Status.FINISHED || this.getStatus() == RestHandler.Status.ERROR) {
            return;
        }
        this.tempStatus = status;
        if (status != RestHandler.Status.NOT_RUN) {
            API.getStatusMap().put(id, status);
        }
    }

    protected RestHandler.Status getStatus() {
        RestHandler.Status status = API.getStatusMap().get(this.getId());
        return status == null ? this.tempStatus : status;
    }

    protected void returnStatus(HttpServletResponse response) {
        this.returnStatus(null, response, null);
    }

    protected void returnStatus(HttpServletRequest request, HttpServletResponse response, String message) {
        String id = this.getId();
        try {
            PrintWriter writer = response.getWriter();
            if (id != null) {
                writer.write("id=" + id + "\n");
            }
            if (API.getRequestMap().get(id) != null) {
                writer.write("request=" + API.getRequestMap().get(id).toString() + "\n");
            }
            if (this.getStatus() != null) {
                switch (this.getStatus()) {
                    case STARTED: {
                        response.setStatus(202);
                        break;
                    }
                    case IN_PROGRESS: {
                        response.setStatus(202);
                        break;
                    }
                    case FINISHED: {
                        response.setStatus(201);
                        break;
                    }
                    case ERROR: {
                        response.sendError(500, message);
                    }
                }
                writer.write("status=" + this.getStatus().toString() + "\n");
            }
            if (message != null) {
                writer.write(message);
            }
        }
        catch (IOException e) {
            Cache.debug(e);
        }
    }

    protected boolean checkStatus(HttpServletRequest request, HttpServletResponse response) {
        return this.checkStatus(request, response, null);
    }

    protected boolean checkStatus(HttpServletRequest request, HttpServletResponse response, RestHandler.Status set) {
        String id = this.getId();
        RestHandler.Status status = this.getStatus();
        if (status == null) {
            if (set != null) {
                this.changeStatus(set);
            }
            API.getRequestMap().put(id, request.getRequestURI());
            return false;
        }
        return true;
    }

    protected void addWhenCompleteCompletableFuture() {
        String id = this.getId();
        this.cf.whenComplete((Void2, e) -> {
            if (e != null) {
                Cache.error("Endpoint job " + id + " did not complete");
                Cache.debug(e);
                this.changeStatus(RestHandler.Status.ERROR);
            } else {
                Cache.info("Endpoint job " + id + " completed successfully");
                this.changeStatus(RestHandler.Status.FINISHED);
                this.atEnd();
            }
        });
    }

    @Override
    protected void returnError(HttpServletRequest request, HttpServletResponse response, String message) {
        this.changeStatus(RestHandler.Status.NOT_RUN);
        super.returnError(request, response, message);
    }

    @Override
    protected boolean deleteFromCache() {
        return false;
    }
}

