/*
 * Decompiled with CFR 0.152.
 */
package jalview.rest;

import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.rest.API;
import jalview.rest.RestHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractEndpoint
implements RestHandler.EndpointI {
    private final String path;
    private API api;
    private final String name;
    private final String parameters;
    private final String description;

    public AbstractEndpoint(API api, String path, String name, String parameters, String description) {
        this.api = api;
        this.path = path;
        this.name = name;
        this.parameters = parameters;
        this.description = description;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected API getAPI() {
        return this.api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParameters() {
        return this.parameters;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public abstract void processEndpoint(HttpServletRequest var1, HttpServletResponse var2);

    protected String[] getEndpointPathParameters(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        int slashpos = pathInfo.indexOf(47, 1);
        return slashpos < 1 ? null : pathInfo.substring(slashpos + 1).split("/");
    }

    protected void returnError(HttpServletRequest request, HttpServletResponse response, String message) {
        String okString = request.getParameter("ok");
        boolean ok = okString != null && okString.equalsIgnoreCase("true");
        response.setStatus(ok ? 200 : 206);
        String endpointName = this.getPath();
        Cache.error(this.getAPI().getName() + " error: endpoint " + endpointName + " failed: '" + message + "'");
        try {
            PrintWriter writer = response.getWriter();
            writer.write("message=Endpoint " + endpointName + ": " + message);
        }
        catch (IOException e) {
            Cache.info(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRequestBody(HttpServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    protected boolean checkParameters(HttpServletRequest request, HttpServletResponse response, int i) {
        String[] parameters = this.getEndpointPathParameters(request);
        if (parameters.length < i) {
            this.returnError(request, response, "requires parameters:" + this.getParameters() + "\n" + this.getName() + ": " + this.getDescription());
            return false;
        }
        return true;
    }

    public int[][] parseIntRanges(String rangesString) {
        if (rangesString.equals("*")) {
            return new int[][]{{-1}, {-1}};
        }
        String[] rangeStrings = rangesString.split(",");
        int[][] ranges = new int[2][rangeStrings.length];
        for (int i = 0; i < rangeStrings.length; ++i) {
            String range = rangeStrings[i];
            try {
                int hyphenpos = range.indexOf(45);
                if (hyphenpos < 0) {
                    ranges[0][i] = Integer.parseInt(range);
                    ranges[1][i] = ranges[0][i];
                    continue;
                }
                ranges[0][i] = Integer.parseInt(range.substring(0, hyphenpos));
                ranges[1][i] = Integer.parseInt(range.substring(hyphenpos + 1));
                continue;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return ranges;
    }

    protected AlignFrame[] getAlignFrames(HttpServletRequest request, boolean all) {
        return this.getAlignFrames(request, "fromId", all);
    }

    protected AlignFrame[] getAlignFrames(HttpServletRequest request, String idParam, boolean all) {
        String fromIdString = request.getParameter(idParam);
        if (fromIdString != null) {
            AlignFrame[] alignFrameArray;
            AlignFrame af = AlignFrame.getAlignFrameFromRestId(fromIdString);
            if (af == null) {
                alignFrameArray = null;
            } else {
                AlignFrame[] alignFrameArray2 = new AlignFrame[1];
                alignFrameArray = alignFrameArray2;
                alignFrameArray2[0] = af;
            }
            return alignFrameArray;
        }
        if (all) {
            return Desktop.getAlignFrames();
        }
        return null;
    }

    protected AlignFrame getAlignFrameFromId(HttpServletRequest request) {
        return this.getAlignFrameFromId(request, "fromId");
    }

    protected AlignFrame getAlignFrameFromId(HttpServletRequest request, String idParam) {
        AlignFrame[] afs = this.getAlignFrames(request, idParam, false);
        return afs == null || afs.length < 1 || afs[0] == null ? null : afs[0];
    }

    protected boolean deleteFromCache() {
        return false;
    }
}

