/*
 * Decompiled with CFR 0.152.
 */
package jalview.math;

import jalview.math.MatrixI;
import jalview.util.Format;
import jalview.util.MessageManager;
import java.io.PrintStream;
import java.util.Arrays;

public class Matrix
implements MatrixI {
    private static final int MAX_ITER = 45;
    protected final int rows;
    protected final int cols;
    private double[][] value;
    protected double[] d;
    protected double[] e;

    protected Matrix(int rowCount, int colCount) {
        this.rows = rowCount;
        this.cols = colCount;
    }

    public Matrix(double[][] values) {
        this.rows = values.length;
        this.cols = this.rows == 0 ? 0 : values[0].length;
        this.value = new double[this.rows][];
        int i = 0;
        for (double[] row : values) {
            if (row != null) {
                this.value[i] = new double[row.length];
                System.arraycopy(row, 0, this.value[i], 0, row.length);
            }
            ++i;
        }
    }

    @Override
    public MatrixI transpose() {
        double[][] out = new double[this.cols][this.rows];
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                out[i][j] = this.value[j][i];
            }
        }
        return new Matrix(out);
    }

    @Override
    public void print(PrintStream ps, String format) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                Format.print(ps, format, this.getValue(i, j));
            }
            ps.println();
        }
    }

    @Override
    public MatrixI preMultiply(MatrixI in) {
        if (in.width() != this.rows) {
            throw new IllegalArgumentException("Can't pre-multiply " + this.rows + " rows by " + in.width() + " columns");
        }
        double[][] tmp = new double[in.height()][this.cols];
        for (int i = 0; i < in.height(); ++i) {
            for (int j = 0; j < this.cols; ++j) {
                for (int k = 0; k < in.width(); ++k) {
                    double[] dArray = tmp[i];
                    int n = j;
                    dArray[n] = dArray[n] + in.getValue(i, k) * this.value[k][j];
                }
            }
        }
        return new Matrix(tmp);
    }

    public double[] vectorPostMultiply(double[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = 0.0;
            for (int k = 0; k < in.length; ++k) {
                int n = i;
                out[n] = out[n] + this.value[i][k] * in[k];
            }
        }
        return out;
    }

    @Override
    public MatrixI postMultiply(MatrixI in) {
        if (in.height() != this.cols) {
            throw new IllegalArgumentException("Can't post-multiply " + this.cols + " columns by " + in.height() + " rows");
        }
        return in.preMultiply(this);
    }

    @Override
    public MatrixI copy() {
        double[][] newmat = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.value[i], 0, newmat[i], 0, this.value[i].length);
        }
        Matrix m = new Matrix(newmat);
        if (this.d != null) {
            m.d = Arrays.copyOf(this.d, this.d.length);
        }
        if (this.e != null) {
            m.e = Arrays.copyOf(this.e, this.e.length);
        }
        return m;
    }

    @Override
    public void tred() {
        int j;
        double g;
        int k;
        int l;
        int i;
        int n = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        for (i = n; i >= 2; --i) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 1) {
                double v;
                for (k = 1; k <= l; ++k) {
                    v = Math.abs(this.getValue(i - 1, k - 1));
                    scale += v;
                }
                if (scale == 0.0) {
                    this.e[i - 1] = this.getValue(i - 1, l - 1);
                } else {
                    double val;
                    for (k = 1; k <= l; ++k) {
                        v = this.divideValue(i - 1, k - 1, scale);
                        h += v * v;
                    }
                    double f = this.getValue(i - 1, l - 1);
                    g = f > 0.0 ? -1.0 * Math.sqrt(h) : Math.sqrt(h);
                    this.e[i - 1] = scale * g;
                    h -= f * g;
                    this.setValue(i - 1, l - 1, f - g);
                    f = 0.0;
                    for (j = 1; j <= l; ++j) {
                        val = this.getValue(i - 1, j - 1) / h;
                        this.setValue(j - 1, i - 1, val);
                        g = 0.0;
                        for (k = 1; k <= j; ++k) {
                            g += this.getValue(j - 1, k - 1) * this.getValue(i - 1, k - 1);
                        }
                        for (k = j + 1; k <= l; ++k) {
                            g += this.getValue(k - 1, j - 1) * this.getValue(i - 1, k - 1);
                        }
                        this.e[j - 1] = g / h;
                        f += this.e[j - 1] * this.getValue(i - 1, j - 1);
                    }
                    double hh = f / (h + h);
                    for (j = 1; j <= l; ++j) {
                        f = this.getValue(i - 1, j - 1);
                        this.e[j - 1] = g = this.e[j - 1] - hh * f;
                        for (k = 1; k <= j; ++k) {
                            val = f * this.e[k - 1] + g * this.getValue(i - 1, k - 1);
                            this.addValue(j - 1, k - 1, -val);
                        }
                    }
                }
            } else {
                this.e[i - 1] = this.getValue(i - 1, l - 1);
            }
            this.d[i - 1] = h;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        for (i = 1; i <= n; ++i) {
            l = i - 1;
            if (this.d[i - 1] != 0.0) {
                for (j = 1; j <= l; ++j) {
                    g = 0.0;
                    for (k = 1; k <= l; ++k) {
                        g += this.getValue(i - 1, k - 1) * this.getValue(k - 1, j - 1);
                    }
                    for (k = 1; k <= l; ++k) {
                        this.addValue(k - 1, j - 1, -(g * this.getValue(k - 1, i - 1)));
                    }
                }
            }
            this.d[i - 1] = this.getValue(i - 1, i - 1);
            this.setValue(i - 1, i - 1, 1.0);
            for (j = 1; j <= l; ++j) {
                this.setValue(j - 1, i - 1, 0.0);
                this.setValue(i - 1, j - 1, 0.0);
            }
        }
    }

    protected double addValue(int i, int j, double f) {
        double v;
        this.value[i][j] = v = this.value[i][j] + f;
        return v;
    }

    protected double divideValue(int i, int j, double divisor) {
        if (divisor == 0.0) {
            return this.getValue(i, j);
        }
        double v = this.value[i][j];
        this.value[i][j] = v /= divisor;
        return v;
    }

    @Override
    public void tqli() throws Exception {
        int i;
        int n = this.rows;
        for (i = 2; i <= n; ++i) {
            this.e[i - 2] = this.e[i - 1];
        }
        this.e[n - 1] = 0.0;
        for (int l = 1; l <= n; ++l) {
            int m;
            int iter = 0;
            do {
                double c;
                for (m = l; m <= n - 1; ++m) {
                    double dd = Math.abs(this.d[m - 1]) + Math.abs(this.d[m]);
                    if (Math.abs(this.e[m - 1]) + dd == dd) break;
                }
                if (m == l) continue;
                if (++iter == 45) {
                    throw new Exception(MessageManager.formatMessage("exception.matrix_too_many_iteration", new String[]{"tqli", Integer.valueOf(45).toString()}));
                }
                double g = (this.d[l] - this.d[l - 1]) / (2.0 * this.e[l - 1]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m - 1] - this.d[l - 1] + this.e[l - 1] / (g + Matrix.sign(r, g));
                double s = c = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    double f = s * this.e[i - 1];
                    double b = c * this.e[i - 1];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i] - p;
                    r = (this.d[i - 1] - g) * s + 2.0 * c * b;
                    p = s * r;
                    this.d[i] = g + p;
                    g = c * r - b;
                    for (int k = 1; k <= n; ++k) {
                        f = this.getValue(k - 1, i);
                        this.setValue(k - 1, i, s * this.getValue(k - 1, i - 1) + c * f);
                        this.setValue(k - 1, i - 1, c * this.getValue(k - 1, i - 1) - s * f);
                    }
                }
                this.d[l - 1] = this.d[l - 1] - p;
                this.e[l - 1] = g;
                this.e[m - 1] = 0.0;
            } while (m != l);
        }
    }

    @Override
    public double getValue(int i, int j) {
        return this.value[i][j];
    }

    @Override
    public void setValue(int i, int j, double val) {
        this.value[i][j] = val;
    }

    public void tred2() {
        int j;
        double g;
        int k;
        int l;
        int i;
        int n = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        for (i = n - 1; i >= 1; --i) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 0) {
                for (k = 0; k < l; ++k) {
                    scale += Math.abs(this.value[i][k]);
                }
                if (scale == 0.0) {
                    this.e[i] = this.value[i][l];
                } else {
                    for (k = 0; k < l; ++k) {
                        double[] dArray = this.value[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += this.value[i][k] * this.value[i][k];
                    }
                    double f = this.value[i][l];
                    g = f > 0.0 ? -1.0 * Math.sqrt(h) : Math.sqrt(h);
                    this.e[i] = scale * g;
                    h -= f * g;
                    this.value[i][l] = f - g;
                    f = 0.0;
                    for (j = 0; j < l; ++j) {
                        this.value[j][i] = this.value[i][j] / h;
                        g = 0.0;
                        for (k = 0; k < j; ++k) {
                            g += this.value[j][k] * this.value[i][k];
                        }
                        for (k = j; k < l; ++k) {
                            g += this.value[k][j] * this.value[i][k];
                        }
                        this.e[j] = g / h;
                        f += this.e[j] * this.value[i][j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j < l; ++j) {
                        f = this.value[i][j];
                        this.e[j] = g = this.e[j] - hh * f;
                        for (k = 0; k < j; ++k) {
                            double[] dArray = this.value[j];
                            int n3 = k;
                            dArray[n3] = dArray[n3] - (f * this.e[k] + g * this.value[i][k]);
                        }
                    }
                }
            } else {
                this.e[i] = this.value[i][l];
            }
            this.d[i] = h;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        for (i = 0; i < n; ++i) {
            l = i - 1;
            if (this.d[i] != 0.0) {
                for (j = 0; j < l; ++j) {
                    g = 0.0;
                    for (k = 0; k < l; ++k) {
                        g += this.value[i][k] * this.value[k][j];
                    }
                    for (k = 0; k < l; ++k) {
                        double[] dArray = this.value[k];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - g * this.value[k][i];
                    }
                }
            }
            this.d[i] = this.value[i][i];
            this.value[i][i] = 1.0;
            for (j = 0; j < l; ++j) {
                this.value[j][i] = 0.0;
                this.value[i][j] = 0.0;
            }
        }
    }

    public void tqli2() throws Exception {
        int i;
        int n = this.rows;
        for (i = 2; i <= n; ++i) {
            this.e[i - 2] = this.e[i - 1];
        }
        this.e[n - 1] = 0.0;
        for (int l = 1; l <= n; ++l) {
            int m;
            int iter = 0;
            do {
                double c;
                for (m = l; m <= n - 1; ++m) {
                    double dd = Math.abs(this.d[m - 1]) + Math.abs(this.d[m]);
                    if (Math.abs(this.e[m - 1]) + dd == dd) break;
                }
                if (m == l) continue;
                if (++iter == 45) {
                    throw new Exception(MessageManager.formatMessage("exception.matrix_too_many_iteration", new String[]{"tqli2", Integer.valueOf(45).toString()}));
                }
                double g = (this.d[l] - this.d[l - 1]) / (2.0 * this.e[l - 1]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m - 1] - this.d[l - 1] + this.e[l - 1] / (g + Matrix.sign(r, g));
                double s = c = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    double f = s * this.e[i - 1];
                    double b = c * this.e[i - 1];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i] - p;
                    r = (this.d[i - 1] - g) * s + 2.0 * c * b;
                    p = s * r;
                    this.d[i] = g + p;
                    g = c * r - b;
                    for (int k = 1; k <= n; ++k) {
                        f = this.value[k - 1][i];
                        this.value[k - 1][i] = s * this.value[k - 1][i - 1] + c * f;
                        this.value[k - 1][i - 1] = c * this.value[k - 1][i - 1] - s * f;
                    }
                }
                this.d[l - 1] = this.d[l - 1] - p;
                this.e[l - 1] = g;
                this.e[m - 1] = 0.0;
            } while (m != l);
        }
    }

    static double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }

    public double[] getColumn(int col) {
        double[] out = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            out[i] = this.value[i][col];
        }
        return out;
    }

    @Override
    public void printD(PrintStream ps, String format) {
        for (int j = 0; j < this.rows; ++j) {
            Format.print(ps, format, this.d[j]);
        }
    }

    @Override
    public void printE(PrintStream ps, String format) {
        for (int j = 0; j < this.rows; ++j) {
            Format.print(ps, format, this.e[j]);
        }
    }

    @Override
    public double[] getD() {
        return this.d;
    }

    @Override
    public double[] getE() {
        return this.e;
    }

    @Override
    public int height() {
        return this.rows;
    }

    @Override
    public int width() {
        return this.cols;
    }

    @Override
    public double[] getRow(int i) {
        double[] row = new double[this.cols];
        System.arraycopy(this.value[i], 0, row, 0, this.cols);
        return row;
    }

    double[] findMinMax() {
        double[] dArray;
        if (this.value == null) {
            return null;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        boolean empty = true;
        for (double[] row : this.value) {
            if (row == null) continue;
            for (double x : row) {
                empty = false;
                if (x > max) {
                    max = x;
                }
                if (!(x < min)) continue;
                min = x;
            }
        }
        if (empty) {
            dArray = null;
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = min;
            dArray = dArray2;
            dArray2[1] = max;
        }
        return dArray;
    }

    @Override
    public void reverseRange(boolean maxToZero) {
        if (this.value == null) {
            return;
        }
        double[] minMax = this.findMinMax();
        if (minMax == null) {
            return;
        }
        double subtractFrom = maxToZero ? minMax[1] : minMax[0] + minMax[1];
        for (double[] row : this.value) {
            if (row == null) continue;
            int j = 0;
            for (double x : row) {
                row[j] = subtractFrom - x;
                ++j;
            }
        }
    }

    @Override
    public void multiply(double by) {
        for (double[] row : this.value) {
            if (row == null) continue;
            int i = 0;
            while (i < row.length) {
                int n = i++;
                row[n] = row[n] * by;
            }
        }
    }

    @Override
    public void setD(double[] v) {
        this.d = v;
    }

    @Override
    public void setE(double[] v) {
        this.e = v;
    }

    public double getTotal() {
        double d = 0.0;
        for (int i = 0; i < this.height(); ++i) {
            for (int j = 0; j < this.width(); ++j) {
                d += this.value[i][j];
            }
        }
        return d;
    }

    @Override
    public boolean equals(MatrixI m2, double delta) {
        if (m2 == null || this.height() != m2.height() || this.width() != m2.width()) {
            return false;
        }
        for (int i = 0; i < this.height(); ++i) {
            for (int j = 0; j < this.width(); ++j) {
                double diff = this.getValue(i, j) - m2.getValue(i, j);
                if (!(Math.abs(diff) > delta)) continue;
                return false;
            }
        }
        return true;
    }
}

