/*
 * Decompiled with CFR 0.152.
 */
package jalview.json.binding.biojson.v1;

import jalview.datamodel.AnnotatedCollectionI;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.PurinePyrimidineColourScheme;
import jalview.schemes.RNAHelicesColour;
import jalview.schemes.RNAInteractionColourScheme;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TCoffeeColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;

public class ColourSchemeMapper {
    private static ColourSchemeI csZappo;
    private static ColourSchemeI csTaylor;
    private static ColourSchemeI csNucleotide;
    private static ColourSchemeI csPurine;
    private static ColourSchemeI csHelix;
    private static ColourSchemeI csTurn;
    private static ColourSchemeI csStrand;
    private static ColourSchemeI csBuried;
    private static ColourSchemeI csHydro;
    private static ColourSchemeI csRNAInteractionType;
    private static ColourSchemeI csPID;
    private static ColourSchemeI csBlosum62;

    public static ColourSchemeI getJalviewColourScheme(String colourSchemeName, AnnotatedCollectionI annotCol) {
        switch (colourSchemeName.toUpperCase()) {
            case "ZAPPO": {
                return csZappo;
            }
            case "TAYLOR": {
                return csTaylor;
            }
            case "NUCLEOTIDE": {
                return csNucleotide;
            }
            case "PURINE": 
            case "PURINE/PYRIMIDINE": {
                return csPurine;
            }
            case "HELIX": 
            case "HELIX PROPENSITY": {
                return csHelix;
            }
            case "TURN": 
            case "TURN PROPENSITY": {
                return csTurn;
            }
            case "STRAND": 
            case "STRAND PROPENSITY": {
                return csStrand;
            }
            case "BURIED": 
            case "BURIED INDEX": {
                return csBuried;
            }
            case "HYDRO": 
            case "HYDROPHOBIC": {
                return csHydro;
            }
            case "RNA INTERACTION TYPE": {
                return csRNAInteractionType;
            }
            case "PID": 
            case "% IDENTITY": {
                return csPID;
            }
            case "BLOSUM62": {
                return csBlosum62;
            }
            case "T-COFFEE SCORES": {
                return annotCol != null ? new TCoffeeColourScheme(annotCol) : null;
            }
            case "RNA HELICES": {
                return annotCol != null ? new RNAHelicesColour(annotCol) : null;
            }
            case "CLUSTAL": {
                return annotCol != null ? new ClustalxColourScheme(annotCol, null) : null;
            }
            case "USER DEFINED": {
                return null;
            }
        }
        return null;
    }

    static {
        csBlosum62 = null;
        csZappo = new ZappoColourScheme();
        csTaylor = new TaylorColourScheme();
        csNucleotide = new NucleotideColourScheme();
        csPurine = new PurinePyrimidineColourScheme();
        csHelix = new HelixColourScheme();
        csTurn = new TurnColourScheme();
        csStrand = new StrandColourScheme();
        csBuried = new BuriedColourScheme();
        csHydro = new HydrophobicColourScheme();
        csRNAInteractionType = new RNAInteractionColourScheme();
        csPID = new PIDColourScheme();
        csBlosum62 = new Blosum62ColourScheme();
    }
}

