/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Cache;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.DatastoreItem;
import jalview.util.MapList;
import jalview.util.MessageManager;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.Local;
import uk.ac.vamsas.objects.core.MapType;
import uk.ac.vamsas.objects.core.Mapped;
import uk.ac.vamsas.objects.core.RangeType;
import uk.ac.vamsas.objects.core.Seg;

public abstract class Rangetype
extends DatastoreItem {
    public Rangetype() {
    }

    public Rangetype(VamsasAppDatastore datastore) {
        super(datastore);
    }

    public Rangetype(VamsasAppDatastore datastore, Vobject vobj, Class jvClass) {
        super(datastore, vobj, jvClass);
    }

    public Rangetype(VamsasAppDatastore datastore, Object jvobj, Class vClass) {
        super(datastore, jvobj, vClass);
    }

    protected int[] getBounds(RangeType dseta) {
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error(MessageManager.getString("error.invalid_vamsas_rangetype_cannot_resolve_lists"));
            }
            if (dseta.getSegCount() > 0) {
                se = this.getSegRange(dseta.getSeg(0), true);
                int sSize = dseta.getSegCount();
                for (int s = 1; s < sSize; ++s) {
                    int[] nse = this.getSegRange(dseta.getSeg(s), true);
                    if (se[0] > nse[0]) {
                        se[0] = nse[0];
                    }
                    if (se[1] >= nse[1]) continue;
                    se[1] = nse[1];
                }
            }
            if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                se = new int[]{pos, pos};
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    if (se[0] > pos) {
                        se[0] = pos;
                    }
                    if (se[1] >= pos) continue;
                    se[1] = pos;
                }
            }
            return se;
        }
        return null;
    }

    protected int[] getMapping(RangeType dseta) {
        Vector<Integer> posList = new Vector<Integer>();
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error(MessageManager.getString("error.invalid_vamsas_rangetype_cannot_resolve_lists"));
            }
            if (dseta.getSegCount() > 0) {
                int sSize = dseta.getSegCount();
                for (int s = 0; s < sSize; ++s) {
                    se = this.getSegRange(dseta.getSeg(s), false);
                    int se_end = se[1 - se[2]] + (se[2] == 0 ? 1 : -1);
                    for (int p = se[se[2]]; p != se_end; p += se[2] == 0 ? 1 : -1) {
                        posList.add(p);
                    }
                }
            } else if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    posList.add(pos);
                }
            }
        }
        if (posList != null && posList.size() > 0) {
            int[] range = new int[posList.size()];
            for (int i = 0; i < range.length; ++i) {
                range[i] = (Integer)posList.elementAt(i);
            }
            posList.clear();
            return range;
        }
        return null;
    }

    protected int[] getIntervals(RangeType range) {
        int[] intervals = null;
        Vector<Integer> posList = new Vector<Integer>();
        if (range != null) {
            int[] se = null;
            if (range.getSegCount() > 0 && range.getPosCount() > 0) {
                throw new Error(MessageManager.getString("error.invalid_vamsas_rangetype_cannot_resolve_lists"));
            }
            if (range.getSegCount() > 0) {
                int sSize = range.getSegCount();
                for (int s = 0; s < sSize; ++s) {
                    se = this.getSegRange(range.getSeg(s), false);
                    posList.addElement(se[0]);
                    posList.addElement(se[1]);
                }
            } else if (range.getPosCount() > 0) {
                int pos = range.getPos(0).getI();
                int pSize = range.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = range.getPos(p).getI();
                    posList.add(pos);
                    posList.add(pos);
                }
            }
        }
        if (posList != null && posList.size() > 0) {
            intervals = new int[posList.size()];
            Enumeration e = posList.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                intervals[i++] = (Integer)e.nextElement();
            }
        }
        return intervals;
    }

    protected void initRangeType(RangeType mrt, List<int[]> ranges) {
        for (int[] range : ranges) {
            Seg vSeg = new Seg();
            vSeg.setStart(range[0]);
            vSeg.setEnd(range[1]);
            vSeg.setInclusive(true);
            mrt.addSeg(vSeg);
        }
    }

    protected MapList parsemapType(MapType maprange, int localu, int mappedu) {
        MapList ml = null;
        int[] localRange = this.getIntervals((RangeType)maprange.getLocal());
        int[] mappedRange = this.getIntervals((RangeType)maprange.getMapped());
        long lu = maprange.getLocal().hasUnit() ? maprange.getLocal().getUnit() : (long)localu;
        long mu = maprange.getMapped().hasUnit() ? maprange.getMapped().getUnit() : (long)mappedu;
        ml = new MapList(localRange, mappedRange, (int)lu, (int)mu);
        return ml;
    }

    protected MapList parsemapType(MapType map) {
        if (!map.getLocal().hasUnit() || map.getMapped().hasUnit()) {
            Cache.log.warn((Object)("using default mapping length of 1:1 for map " + (String)(map.isRegistered() ? map.getVorbaId().toString() : "<no Id registered> " + map.toString())));
        }
        return this.parsemapType(map, 1, 1);
    }

    protected void initMapType(MapType maprange, MapList ml, boolean setUnits) {
        this.initMapType(maprange, ml, setUnits, false);
    }

    protected void initMapType(MapType maprange, MapList ml, boolean setUnits, boolean reverse) {
        if (ml == null) {
            throw new Error("Implementation error. MapList is null for initMapType.");
        }
        maprange.setLocal(new Local());
        maprange.setMapped(new Mapped());
        if (!reverse) {
            this.initRangeType((RangeType)maprange.getLocal(), ml.getFromRanges());
            this.initRangeType((RangeType)maprange.getMapped(), ml.getToRanges());
        } else {
            this.initRangeType((RangeType)maprange.getLocal(), ml.getToRanges());
            this.initRangeType((RangeType)maprange.getMapped(), ml.getFromRanges());
        }
        if (setUnits) {
            if (!reverse) {
                maprange.getLocal().setUnit((long)ml.getFromRatio());
                maprange.getMapped().setUnit((long)ml.getToRatio());
            } else {
                maprange.getLocal().setUnit((long)ml.getToRatio());
                maprange.getMapped().setUnit((long)ml.getFromRatio());
            }
        }
    }
}

