/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.gff;

import jalview.analysis.SequenceIdMatcher;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.MappingType;
import jalview.datamodel.SequenceDummy;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.gff.GffHelperI;
import jalview.util.MapList;
import jalview.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GffHelperBase
implements GffHelperI {
    private static final String INVALID_GFF_ATTRIBUTE_FORMAT = "Invalid GFF attribute format: ";
    protected static final String COMMA = ",";
    protected static final String EQUALS = "=";
    protected static final String NOTE = "Note";
    protected static final int SEQID_COL = 0;
    protected static final int SOURCE_COL = 1;
    protected static final int TYPE_COL = 2;
    protected static final int START_COL = 3;
    protected static final int END_COL = 4;
    protected static final int SCORE_COL = 5;
    protected static final int STRAND_COL = 6;
    protected static final int PHASE_COL = 7;
    protected static final int ATTRIBUTES_COL = 8;
    private AlignmentI lastmatchedAl = null;
    private SequenceIdMatcher matcher = null;

    protected MapList constructMappingFromAlign(int fromStart, int fromEnd, int toStart, int toEnd, MappingType mappingType) {
        int toRatio;
        int fromRatio;
        int[] from = new int[]{fromStart, fromEnd};
        int[] to = new int[]{toStart, toEnd};
        if (mappingType == MappingType.PeptideToNucleotide) {
            int[] temp = from;
            from = to;
            to = temp;
            mappingType = mappingType.getInverse();
        }
        if (!GffHelperBase.trimMapping(from, to, fromRatio = mappingType.getFromRatio(), toRatio = mappingType.getToRatio())) {
            System.err.println("Ignoring mapping from " + Arrays.toString(from) + " to " + Arrays.toString(to) + " as counts don't match!");
            return null;
        }
        return new MapList(from, to, fromRatio, toRatio);
    }

    protected static boolean trimMapping(int[] from, int[] to, int fromRatio, int toRatio) {
        int toLength;
        int fromLength = Math.abs(from[1] - from[0]) + 1;
        int fromOverlap = fromLength * toRatio - (toLength = Math.abs(to[1] - to[0]) + 1) * fromRatio;
        if (fromOverlap == 0) {
            return true;
        }
        if (fromOverlap > 0 && fromOverlap % toRatio == 0) {
            System.err.print("Truncating mapping from " + Arrays.toString(from) + " to ");
            from[1] = from[1] > from[0] ? from[1] - fromOverlap / toRatio : from[1] + fromOverlap / toRatio;
            System.err.println(Arrays.toString(from));
            return true;
        }
        if (fromOverlap < 0 && fromOverlap % fromRatio == 0) {
            fromOverlap = -fromOverlap;
            System.err.print("Truncating mapping to " + Arrays.toString(to) + " to ");
            to[1] = to[1] > to[0] ? to[1] - fromOverlap / fromRatio : to[1] + fromOverlap / fromRatio;
            System.err.println(Arrays.toString(to));
            return true;
        }
        return false;
    }

    protected SequenceI findSequence(String seqId, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) {
        if (seqId == null) {
            return null;
        }
        SequenceI match = null;
        if (relaxedIdMatching) {
            if (this.lastmatchedAl != align) {
                this.lastmatchedAl = align;
                this.matcher = new SequenceIdMatcher(align.getSequencesArray());
                if (newseqs != null) {
                    this.matcher.addAll(newseqs);
                }
            }
            match = this.matcher.findIdMatch(seqId);
        } else {
            match = align.findName(seqId, true);
            if (match == null && newseqs != null) {
                for (SequenceI m : newseqs) {
                    if (!seqId.equals(m.getName())) continue;
                    return m;
                }
            }
        }
        if (match == null && newseqs != null) {
            match = new SequenceDummy(seqId);
            if (relaxedIdMatching) {
                this.matcher.addAll(Arrays.asList(match));
            }
            newseqs.add(match);
        }
        return match;
    }

    public static Map<String, List<String>> parseNameValuePairs(String text, String namesDelimiter, char nameValueSeparator, String valuesDelimiter) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (text == null || text.trim().length() == 0) {
            return map;
        }
        for (String nameValuePair : text.trim().split(namesDelimiter)) {
            int sepPos;
            if ((nameValuePair = nameValuePair.trim()).length() == 0 || (sepPos = nameValuePair.indexOf(nameValueSeparator)) == -1) continue;
            String name = nameValuePair.substring(0, sepPos).trim();
            String values = nameValuePair.substring(sepPos + 1).trim();
            if (values.isEmpty()) continue;
            ArrayList<String> vals = (ArrayList<String>)map.get(name);
            if (vals == null) {
                vals = new ArrayList<String>();
                map.put(name, vals);
            }
            if (values.indexOf(nameValueSeparator) != -1) {
                vals.add(values);
                continue;
            }
            for (String val : values.split(valuesDelimiter)) {
                vals.add(val);
            }
        }
        return map;
    }

    protected SequenceFeature buildSequenceFeature(String[] gff, Map<String, List<String>> attributes) {
        return this.buildSequenceFeature(gff, 2, gff[1], attributes);
    }

    protected SequenceFeature buildSequenceFeature(String[] gff, int typeColumn, String group, Map<String, List<String>> attributes) {
        try {
            int start = Integer.parseInt(gff[3]);
            int end = Integer.parseInt(gff[4]);
            float score = 0.0f;
            try {
                score = Float.parseFloat(gff[5]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SequenceFeature sf = new SequenceFeature(gff[typeColumn], gff[1], start, end, score, group);
            sf.setStrand(gff[6]);
            sf.setPhase(gff[7]);
            if (attributes != null) {
                for (Map.Entry<String, List<String>> attr : attributes.entrySet()) {
                    String key = attr.getKey();
                    List<String> values = attr.getValue();
                    if (values.size() == 1 && values.get(0).contains(EQUALS)) {
                        Map<String, String> valueMap = GffHelperBase.parseAttributeMap(values.get(0));
                        sf.setValue(key, valueMap);
                        continue;
                    }
                    String csvValues = StringUtils.listToDelimitedString(values, COMMA);
                    csvValues = StringUtils.urlDecode(csvValues, ",=;\t%");
                    sf.setValue(key, csvValues);
                    if (!NOTE.equals(key)) continue;
                    sf.setDescription(csvValues);
                }
            }
            return sf;
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid number in gff: " + nfe.getMessage());
            return null;
        }
    }

    protected static Map<String, String> parseAttributeMap(String s) {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] fields = s.split(EQUALS);
        boolean valid = true;
        if (fields.length < 2) {
            valid = false;
        } else if (fields[0].isEmpty() || fields[0].contains(COMMA)) {
            valid = false;
        } else {
            for (i = 1; i < fields.length - 1; ++i) {
                if (!fields[i].isEmpty() && fields[i].contains(COMMA)) continue;
                valid = false;
            }
        }
        if (!valid) {
            System.err.println(INVALID_GFF_ATTRIBUTE_FORMAT + s);
            return map;
        }
        for (i = 0; i < fields.length - 1; ++i) {
            boolean lastPair = i == fields.length - 2;
            String before = fields[i];
            String after = fields[i + 1];
            String theKey = before.contains(COMMA) ? before.substring(before.lastIndexOf(COMMA) + 1) : before;
            if ((theKey = theKey.trim()).isEmpty()) {
                System.err.println(INVALID_GFF_ATTRIBUTE_FORMAT + s);
                map.clear();
                return map;
            }
            String theValue = after.contains(COMMA) && !lastPair ? after.substring(0, after.lastIndexOf(COMMA)) : after;
            map.put(StringUtils.urlDecode(theKey, ",=;\t%"), StringUtils.urlDecode(theValue, ",=;\t%"));
        }
        return map;
    }

    protected AlignedCodonFrame getMapping(AlignmentI align, SequenceI fromSeq, SequenceI toSeq) {
        AlignedCodonFrame acf = align.getMapping(fromSeq, toSeq);
        if (acf == null) {
            acf = new AlignedCodonFrame();
        }
        return acf;
    }
}

