/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.MSFfile;
import jalview.util.Format;
import java.io.IOException;

public class PileUpfile
extends MSFfile {
    public PileUpfile() {
    }

    public PileUpfile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public PileUpfile(FileParse source) throws IOException {
        super(source);
    }

    @Override
    public String print(SequenceI[] s, boolean jvsuffix) {
        int i;
        StringBuffer out = new StringBuffer("PileUp");
        out.append(this.newline);
        out.append(this.newline);
        int max = 0;
        int maxid = 0;
        int bigChecksum = 0;
        int[] checksums = new int[s.length];
        for (i = 0; i < s.length; ++i) {
            checksums[i] = this.checkSum(s[i].getSequenceAsString());
            bigChecksum += checksums[i];
        }
        out.append("   MSF: " + s[0].getLength() + "   Type: P    Check:  " + bigChecksum % 10000 + "   ..");
        out.append(this.newline);
        out.append(this.newline);
        out.append(this.newline);
        for (i = 0; i < s.length && s[i] != null; ++i) {
            String seq = s[i].getSequenceAsString();
            out.append(" Name: " + this.printId(s[i], jvsuffix) + " oo  Len:  " + seq.length() + "  Check:  " + checksums[i] + "  Weight:  1.00");
            out.append(this.newline);
            if (seq.length() > max) {
                max = seq.length();
            }
            if (s[i].getName().length() <= maxid) continue;
            maxid = s[i].getName().length();
        }
        if (maxid < 10) {
            maxid = 10;
        }
        ++maxid;
        out.append(this.newline);
        out.append(this.newline);
        out.append("//");
        out.append(this.newline);
        out.append(this.newline);
        int len = 50;
        int nochunks = max / len + (max % len > 0 ? 1 : 0);
        for (i = 0; i < nochunks; ++i) {
            for (int j = 0; j < s.length && s[j] != null; ++j) {
                String name = this.printId(s[j], jvsuffix);
                out.append(new Format("%-" + maxid + "s").form(name + " "));
                for (int k = 0; k < 5; ++k) {
                    int start = i * 50 + k * 10;
                    int end = start + 10;
                    int length = s[j].getLength();
                    if (end < length && start < length) {
                        out.append(s[j].getSequence(start, end));
                        if (k < 4) {
                            out.append(" ");
                            continue;
                        }
                        out.append(this.newline);
                        continue;
                    }
                    if (start < length) {
                        out.append(s[j].getSequenceAsString().substring(start));
                        out.append(this.newline);
                        continue;
                    }
                    if (k != 0) continue;
                    out.append(this.newline);
                }
            }
            out.append(this.newline);
        }
        return out.toString();
    }
}

