/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.Format;
import jalview.util.MessageManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PfamFile
extends AlignFile {
    public PfamFile() {
    }

    public PfamFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public PfamFile(FileParse source) throws IOException {
        super(source);
    }

    @Override
    public void initData() {
        super.initData();
    }

    @Override
    public void parse() throws IOException {
        String line;
        int i = 0;
        HashMap<String, StringBuffer> seqhash = new HashMap<String, StringBuffer>();
        ArrayList<String> headers = new ArrayList<String>();
        boolean useTabs = false;
        while ((line = this.nextLine()) != null) {
            StringBuffer tempseq;
            int spces;
            if (line.indexOf("#") == 0) continue;
            if (useTabs) {
                spces = line.indexOf("\t");
            } else {
                spces = line.indexOf(" ");
                if (!useTabs && spces == -1) {
                    useTabs = true;
                    spces = line.indexOf("\t");
                }
            }
            if (spces <= 0) continue;
            String id = line.substring(0, spces);
            if (seqhash.containsKey(id)) {
                tempseq = (StringBuffer)seqhash.get(id);
            } else {
                tempseq = new StringBuffer();
                seqhash.put(id, tempseq);
            }
            if (!headers.contains(id)) {
                headers.add(id);
            }
            if (spces + 1 >= line.length()) continue;
            tempseq.append(line.substring(spces + 1).trim());
        }
        this.noSeqs = headers.size();
        if (this.noSeqs < 1) {
            throw new IOException(MessageManager.getString("exception.pfam_no_sequences_found"));
        }
        for (i = 0; i < headers.size(); ++i) {
            if (seqhash.get(headers.get(i)) != null) {
                if (this.maxLength < ((StringBuffer)seqhash.get(headers.get(i))).toString().length()) {
                    this.maxLength = ((StringBuffer)seqhash.get(headers.get(i))).toString().length();
                }
                Sequence newSeq = this.parseId(((String)headers.get(i)).toString());
                newSeq.setSequence(((StringBuffer)seqhash.get(((String)headers.get(i)).toString())).toString());
                this.seqs.addElement(newSeq);
                continue;
            }
            System.err.println("PFAM File reader: Can't find sequence for " + (String)headers.get(i));
        }
    }

    @Override
    public String print(SequenceI[] s, boolean jvsuffix) {
        StringBuffer out = new StringBuffer("");
        int max = 0;
        int maxid = 0;
        for (int i = 0; i < s.length && s[i] != null; ++i) {
            String tmp = this.printId(s[i], jvsuffix);
            max = Math.max(max, s[i].getLength());
            if (tmp.length() <= maxid) continue;
            maxid = tmp.length();
        }
        if (maxid < 15) {
            maxid = 15;
        }
        for (int j = 0; j < s.length && s[j] != null; ++j) {
            out.append(new Format("%-" + maxid + "s").form(this.printId(s[j], jvsuffix) + " "));
            out.append(s[j].getSequenceAsString());
            out.append(this.newline);
        }
        out.append(this.newline);
        return out.toString();
    }
}

