/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.BackupFilenameParts;
import jalview.io.JalviewFileChooser;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class JalviewFileFilter
extends FileFilter {
    public static Hashtable suffixHash = new Hashtable();
    private Map<String, JalviewFileFilter> filters = null;
    private String description = "no description";
    private String fullDescription = "full description";
    private boolean useExtensionsInDescription = true;
    private JalviewFileChooser parentJFC = null;

    public JalviewFileFilter(String extension, String description) {
        StringTokenizer st = new StringTokenizer(extension, ",");
        while (st.hasMoreElements()) {
            this.addExtension(st.nextToken().trim());
        }
        this.setDescription(description);
    }

    public JalviewFileFilter(String[] filts) {
        this(filts, null);
    }

    public JalviewFileFilter(String[] filts, String description) {
        for (int i = 0; i < filts.length; ++i) {
            this.addExtension(filts[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public String getAcceptableExtension() {
        return this.filters.keySet().iterator().next().toString();
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            String extension = this.getExtension(f);
            if (f.isDirectory()) {
                return true;
            }
            if (extension != null && this.filters.get(extension) != null) {
                return true;
            }
        }
        if (this.parentJFC != null && this.parentJFC.includeBackupFiles) {
            for (String ext : this.filters.keySet()) {
                BackupFilenameParts bfp;
                if (!f.getName().contains(ext) || !(bfp = BackupFilenameParts.currentBackupFilenameParts(f.getName(), ext, true)).isBackupFile()) continue;
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new LinkedHashMap<String, JalviewFileFilter>(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Iterator<String> extensions = this.filters.keySet().iterator();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + extensions.next();
                    while (extensions.hasNext()) {
                        this.fullDescription = this.fullDescription + ", " + extensions.next();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    protected void setParentJFC(JalviewFileChooser p) {
        this.parentJFC = p;
    }
}

