/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.AlignmentFileReaderI;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileParse;
import java.io.File;
import java.io.IOException;

public class IdentifyFile {
    public FileFormatI identify(Object file, DataSourceType protocol) throws FileFormatException {
        return file instanceof File ? this.identify((File)file, protocol) : this.identify((String)file, protocol);
    }

    public FileFormatI identify(File file, DataSourceType sourceType) throws FileFormatException {
        String emessage = "UNIDENTIFIED FILE PARSING ERROR";
        FileParse parser = null;
        try {
            parser = new FileParse(file, sourceType);
            if (parser.isValid()) {
                return this.identify(parser);
            }
        }
        catch (Exception e) {
            System.err.println("Error whilst identifying " + file);
            e.printStackTrace(System.err);
            emessage = e.getMessage();
        }
        if (parser != null) {
            throw new FileFormatException(parser.errormessage);
        }
        throw new FileFormatException(emessage);
    }

    public FileFormatI identify(String file, DataSourceType sourceType) throws FileFormatException {
        String emessage = "UNIDENTIFIED FILE PARSING ERROR";
        FileParse parser = null;
        try {
            parser = new FileParse(file, sourceType);
            if (parser.isValid()) {
                return this.identify(parser);
            }
        }
        catch (Exception e) {
            System.err.println("Error whilst identifying " + file);
            e.printStackTrace(System.err);
            emessage = e.getMessage();
        }
        if (parser != null) {
            throw new FileFormatException(parser.errormessage);
        }
        throw new FileFormatException(emessage);
    }

    public FileFormatI identify(FileParse source) throws FileFormatException {
        return this.identify(source, true);
    }

    public FileFormatI identify(AlignmentFileReaderI file, boolean closeSource) throws IOException {
        FileParse fp = new FileParse(file.getInFile(), file.getDataSourceType());
        return this.identify(fp, closeSource);
    }

    public FileFormatI identify(FileParse source, boolean closeSource) throws FileFormatException {
        FileFormat reply = FileFormat.Pfam;
        int bytesRead = 0;
        int trimmedLength = 0;
        boolean lineswereskipped = false;
        boolean isBinary = false;
        try {
            String data;
            if (!closeSource) {
                source.mark();
            }
            boolean aaIndexHeaderRead = false;
            while ((data = source.nextLine()) != null) {
                bytesRead += data.length();
                trimmedLength += data.trim().length();
                if (!lineswereskipped) {
                    for (int i = 0; !isBinary && i < data.length(); ++i) {
                        char c = data.charAt(i);
                        isBinary = c < ' ' && c != '\t' && c != '\n' && c != '\r' && c != '\u0005' && c != '\u001b';
                    }
                }
                if (isBinary) {
                    String fileStr;
                    if (source.inFile != null && ((fileStr = source.inFile.getName()).contains(".jar") || fileStr.contains(".zip") || fileStr.contains(".jvp"))) {
                        reply = FileFormat.Jalview;
                    }
                    if (!lineswereskipped && data.startsWith("PK")) {
                        reply = FileFormat.Jalview;
                        break;
                    }
                }
                if ((data = data.toUpperCase()).startsWith("SCOREMATRIX")) {
                    reply = FileFormat.ScoreMatrix;
                    break;
                }
                if (data.startsWith("H ") && !aaIndexHeaderRead) {
                    aaIndexHeaderRead = true;
                }
                if (data.startsWith("D ") && aaIndexHeaderRead) {
                    reply = FileFormat.ScoreMatrix;
                    break;
                }
                if (data.startsWith("##GFF-VERSION")) {
                    reply = FileFormat.Features;
                    break;
                }
                if (this.looksLikeFeatureData(data)) {
                    reply = FileFormat.Features;
                    break;
                }
                if (data.indexOf("# STOCKHOLM") > -1) {
                    reply = FileFormat.Stockholm;
                    break;
                }
                if (data.indexOf("_ENTRY.ID") > -1 || data.indexOf("_AUDIT_AUTHOR.NAME") > -1 || data.indexOf("_ATOM_SITE.") > -1) {
                    reply = FileFormat.MMCif;
                    break;
                }
                if (data.startsWith(">")) {
                    boolean checkPIR = false;
                    boolean starterm = false;
                    if (data.indexOf(">P1;") > -1 || data.indexOf(">DL;") > -1) {
                        checkPIR = true;
                        reply = FileFormat.PIR;
                    }
                    if ((data = source.nextLine()).indexOf(">") > -1) {
                        reply = FileFormat.BLC;
                    } else {
                        int c1;
                        String data1 = source.nextLine();
                        String data2 = source.nextLine();
                        if (checkPIR) {
                            boolean bl = starterm = data1 != null && data1.indexOf("*") > -1 || data2 != null && data2.indexOf("*") > -1;
                        }
                        if (data2 != null && (c1 = data.indexOf("*")) > -1) {
                            reply = c1 == 0 && c1 == data2.indexOf("*") ? FileFormat.BLC : FileFormat.Fasta;
                        } else {
                            reply = FileFormat.Fasta;
                            if (!checkPIR) break;
                        }
                    }
                    if (!checkPIR) break;
                    String dta = null;
                    if (!starterm) {
                        do {
                            try {
                                dta = source.nextLine();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (dta == null || dta.indexOf("*") <= -1) continue;
                            starterm = true;
                        } while (dta != null && !starterm);
                    }
                    if (starterm) {
                        reply = FileFormat.PIR;
                        break;
                    }
                    reply = FileFormat.Fasta;
                    break;
                }
                if (data.indexOf("{\"") > -1) {
                    reply = FileFormat.Json;
                    break;
                }
                int lessThan = data.indexOf("<");
                if (lessThan > -1) {
                    String upper = data.toUpperCase();
                    if (upper.substring(lessThan).startsWith("<HTML")) {
                        reply = FileFormat.Html;
                        break;
                    }
                    if (upper.substring(lessThan).startsWith("<RNAML")) {
                        reply = FileFormat.Rnaml;
                        break;
                    }
                }
                if (data.length() < 1 || data.indexOf("#") == 0) {
                    lineswereskipped = true;
                    continue;
                }
                if (data.indexOf("PILEUP") > -1) {
                    reply = FileFormat.Pileup;
                    break;
                }
                if (data.indexOf("//") == 0 || data.indexOf("!!") > -1 && data.indexOf("!!") < data.indexOf("_MULTIPLE_ALIGNMENT ")) {
                    reply = FileFormat.MSF;
                    break;
                }
                if (data.indexOf("CLUSTAL") > -1) {
                    reply = FileFormat.Clustal;
                    break;
                }
                if (data.indexOf("HEADER") == 0 || data.indexOf("ATOM") == 0) {
                    reply = FileFormat.PDB;
                    break;
                }
                if (data.matches("\\s*\\d+\\s+\\d+\\s*")) {
                    reply = FileFormat.Phylip;
                    break;
                }
                if (!lineswereskipped && this.looksLikeJnetData(data)) {
                    reply = FileFormat.Jnet;
                    break;
                }
                lineswereskipped = true;
            }
            if (closeSource) {
                source.close();
            } else {
                source.reset(bytesRead);
            }
        }
        catch (Exception ex) {
            System.err.println("File Identification failed!\n" + ex);
            throw new FileFormatException(source.errormessage);
        }
        if (trimmedLength == 0) {
            System.err.println("File Identification failed! - Empty file was read.");
            throw new FileFormatException("EMPTY DATA FILE");
        }
        System.out.println("File format identified as " + reply.toString());
        return reply;
    }

    protected boolean looksLikeJnetData(String data) {
        char firstChar = data.charAt(0);
        int colonPos = data.indexOf(":");
        int commaPos = data.indexOf(",");
        boolean isJnet = firstChar != '*' && firstChar != ' ' && colonPos > -1 && commaPos > -1 && colonPos < commaPos;
        return isJnet;
    }

    protected boolean looksLikeFeatureData(String data) {
        if (data == null) {
            return false;
        }
        String[] columns = data.split("\t");
        if (columns.length < 6) {
            return false;
        }
        for (int col = 3; col < 5; ++col) {
            try {
                Integer.parseInt(columns[col]);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            IdentifyFile ider = new IdentifyFile();
            FileFormatI type = null;
            try {
                type = ider.identify(args[i], DataSourceType.FILE);
            }
            catch (FileFormatException e) {
                System.err.println(String.format("Error '%s' identifying file type for %s", args[i], e.getMessage()));
            }
            System.out.println("Type of " + args[i] + " is " + type);
        }
        if (args == null || args.length == 0) {
            System.err.println("Usage: <Filename> [<Filename> ...]");
        }
    }
}

