/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.ComplexAlignFile;
import jalview.api.FeatureSettingsModelI;
import jalview.api.FeaturesDisplayedI;
import jalview.api.FeaturesSourceI;
import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.json.binding.biojson.v1.ColourSchemeMapper;
import jalview.project.Jalview2XML;
import jalview.schemes.ColourSchemeI;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import jalview.ws.utils.UrlDownloadClient;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class FileLoader
implements Runnable {
    String file;
    DataSourceType protocol;
    FileFormatI format;
    AlignmentFileReaderI source = null;
    AlignViewport viewport;
    AlignFrame alignFrame;
    long loadtime;
    long memused;
    boolean raiseGUI = true;
    private File selectedFile;

    public FileLoader() {
        this(true);
    }

    public FileLoader(boolean raiseGUI) {
        this.raiseGUI = raiseGUI;
    }

    public void LoadFile(AlignViewport viewport, Object file, DataSourceType protocol, FileFormatI format) {
        this.viewport = viewport;
        if (file instanceof File) {
            this.selectedFile = (File)file;
            file = this.selectedFile.getPath();
        }
        this.LoadFile(file.toString(), protocol, format);
    }

    public void LoadFile(String file, DataSourceType protocol, FileFormatI format) {
        this.file = file;
        this.protocol = protocol;
        this.format = format;
        final Thread loader = new Thread(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                loader.start();
            }
        });
    }

    public void LoadFile(String file, DataSourceType protocol) {
        this.LoadFile(file, protocol, null);
    }

    public AlignFrame LoadFileWaitTillLoaded(String file, DataSourceType sourceType) {
        return this.LoadFileWaitTillLoaded(file, sourceType, null);
    }

    public AlignFrame LoadFileWaitTillLoaded(String file, DataSourceType sourceType, FileFormatI format) {
        this.file = file;
        this.protocol = sourceType;
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    public AlignFrame LoadFileWaitTillLoaded(File file, DataSourceType sourceType, FileFormatI format) {
        this.selectedFile = file;
        this.file = file.getPath();
        this.protocol = sourceType;
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    public AlignFrame LoadFileWaitTillLoaded(AlignmentFileReaderI source, FileFormatI format) {
        this.source = source;
        this.file = source.getInFile();
        this.protocol = source.getDataSourceType();
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    protected AlignFrame _LoadFileWaitTillLoaded() {
        this.run();
        return this.alignFrame;
    }

    public void updateRecentlyOpened() {
        Vector<String> recent = new Vector<String>();
        if (this.protocol == DataSourceType.PASTE) {
            return;
        }
        if (this.file != null && this.file.indexOf(System.getProperty("java.io.tmpdir")) > -1) {
            return;
        }
        String type = this.protocol == DataSourceType.FILE ? "RECENT_FILE" : "RECENT_URL";
        String historyItems = Cache.getProperty(type);
        if (historyItems != null) {
            StringTokenizer st = new StringTokenizer(historyItems, "\t");
            while (st.hasMoreTokens()) {
                recent.addElement(st.nextToken().trim());
            }
        }
        if (recent.contains(this.file)) {
            recent.remove(this.file);
        }
        StringBuffer newHistory = new StringBuffer(this.file);
        for (int i = 0; i < recent.size() && i < 10; ++i) {
            newHistory.append("\t");
            newHistory.append((String)recent.elementAt(i));
        }
        Cache.setProperty(type, newHistory.toString());
        if (this.protocol == DataSourceType.FILE) {
            Cache.setProperty("DEFAULT_FILE_FORMAT", this.format.getName());
        }
    }

    @Override
    public void run() {
        AlignmentI al;
        String title = this.protocol == DataSourceType.PASTE ? "Copied From Clipboard" : this.file;
        Runtime rt = Runtime.getRuntime();
        try {
            if (Desktop.instance != null) {
                Desktop.instance.startLoading(this.file);
            }
            if (this.format == null) {
                this.format = this.source != null ? new IdentifyFile().identify(this.source, false) : (this.selectedFile != null ? new IdentifyFile().identify(this.selectedFile, this.protocol) : new IdentifyFile().identify(this.file, this.protocol));
            }
            if (this.format == null) {
                Desktop.instance.stopLoading();
                System.err.println("The input file \"" + this.file + "\" has null or unidentifiable data content!");
                if (!Jalview.isHeadlessMode()) {
                    JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.couldnt_read_data") + " in " + this.file + "\n" + AppletFormatAdapter.getSupportedFormats(), MessageManager.getString("label.couldnt_read_data"), 2);
                }
                return;
            }
            if (Desktop.desktop != null && Desktop.desktop.isShowMemoryUsage()) {
                System.gc();
                this.memused = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
            }
            this.loadtime = -System.currentTimeMillis();
            al = null;
            if (FileFormat.Jalview.equals(this.format)) {
                if (this.source != null) {
                    System.err.println("IMPLEMENTATION ERROR: Cannot read consecutive Jalview XML projects from a stream.");
                }
                this.alignFrame = new Jalview2XML(this.raiseGUI).loadJalviewAlign(this.selectedFile == null ? this.file : this.selectedFile);
            } else {
                String error = AppletFormatAdapter.getSupportedFormats();
                try {
                    if (this.source != null) {
                        al = new FormatAdapter().readFromFile(this.source, this.format);
                    } else {
                        boolean downloadStructureFile;
                        FormatAdapter fa = new FormatAdapter();
                        boolean bl = downloadStructureFile = this.format.isStructureFile() && this.protocol.equals((Object)DataSourceType.URL);
                        if (downloadStructureFile) {
                            String structExt = this.format.getExtensions().split(",")[0];
                            String urlLeafName = this.file.substring(this.file.lastIndexOf(System.getProperty("file.separator")), this.file.lastIndexOf("."));
                            String tempStructureFileStr = FileLoader.createNamedJvTempFile(urlLeafName, structExt);
                            File tempFile = new File(tempStructureFileStr);
                            UrlDownloadClient.download(this.file, tempFile);
                            al = fa.readFile(tempFile, DataSourceType.FILE, this.format);
                            this.source = fa.getAlignFile();
                        } else {
                            al = this.selectedFile == null ? fa.readFile(this.file, this.protocol, this.format) : fa.readFile(this.selectedFile, this.protocol, this.format);
                            this.source = fa.getAlignFile();
                        }
                    }
                }
                catch (IOException ex) {
                    error = ex.getMessage();
                }
                if (al != null && al.getHeight() > 0 && al.hasValidSequence()) {
                    for (SequenceI sq : al.getSequences()) {
                        while (sq.getDatasetSequence() != null) {
                            sq = sq.getDatasetSequence();
                        }
                        if (sq.getAllPDBEntries() == null) continue;
                        for (PDBEntry pdbe : sq.getAllPDBEntries()) {
                            StructureSelectionManager.getStructureSelectionManager(Desktop.instance).registerPDBEntry(pdbe);
                        }
                    }
                    FeatureSettingsModelI proxyColourScheme = this.source.getFeatureColourScheme();
                    if (this.viewport != null) {
                        if (proxyColourScheme != null) {
                            this.viewport.applyFeaturesStyle(proxyColourScheme);
                        }
                        this.viewport.addAlignment(al, title);
                    } else {
                        if (this.source instanceof ComplexAlignFile) {
                            HiddenColumns colSel = ((ComplexAlignFile)((Object)this.source)).getHiddenColumns();
                            SequenceI[] hiddenSeqs = ((ComplexAlignFile)((Object)this.source)).getHiddenSequences();
                            String colourSchemeName = ((ComplexAlignFile)((Object)this.source)).getGlobalColourScheme();
                            FeaturesDisplayedI fd = ((ComplexAlignFile)((Object)this.source)).getDisplayedFeatures();
                            this.alignFrame = new AlignFrame(al, hiddenSeqs, colSel, 700, 500);
                            this.alignFrame.getViewport().setFeaturesDisplayed(fd);
                            this.alignFrame.getViewport().setShowSequenceFeatures(((ComplexAlignFile)((Object)this.source)).isShowSeqFeatures());
                            ColourSchemeI cs = ColourSchemeMapper.getJalviewColourScheme(colourSchemeName, al);
                            if (cs != null) {
                                this.alignFrame.changeColour(cs);
                            }
                        } else {
                            this.alignFrame = new AlignFrame(al, 700, 500);
                            if (this.source instanceof FeaturesSourceI) {
                                this.alignFrame.getViewport().setShowSequenceFeatures(true);
                            }
                        }
                        if (this.protocol != DataSourceType.PASTE) {
                            this.alignFrame.setFileName(this.file, this.format);
                            this.alignFrame.setFileObject(this.selectedFile);
                        }
                        if (proxyColourScheme != null) {
                            this.alignFrame.getViewport().applyFeaturesStyle(proxyColourScheme);
                        }
                        this.alignFrame.setStatus(MessageManager.formatMessage("label.successfully_loaded_file", new String[]{title}));
                        if (this.raiseGUI) {
                            Desktop.addInternalFrame(this.alignFrame, title, 700, 500);
                        }
                        try {
                            this.alignFrame.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                } else {
                    if (Desktop.instance != null) {
                        Desktop.instance.stopLoading();
                    }
                    final String errorMessage = MessageManager.getString("label.couldnt_load_file") + " " + title + "\n" + error;
                    if (this.raiseGUI && Desktop.desktop != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, errorMessage, MessageManager.getString("label.error_loading_file"), 2);
                            }
                        });
                    } else {
                        System.err.println(errorMessage);
                    }
                }
            }
            this.updateRecentlyOpened();
        }
        catch (Exception er) {
            System.err.println("Exception whilst opening file '" + this.file);
            er.printStackTrace();
            if (this.raiseGUI) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.problems_opening_file", new String[]{FileLoader.this.file}), MessageManager.getString("label.file_open_error"), 2);
                    }
                });
            }
            this.alignFrame = null;
        }
        catch (OutOfMemoryError er) {
            er.printStackTrace();
            this.alignFrame = null;
            if (this.raiseGUI) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("warn.out_of_memory_loading_file", new String[]{FileLoader.this.file}), MessageManager.getString("label.out_of_memory"), 2);
                    }
                });
            }
            System.err.println("Out of memory loading file " + this.file + "!!");
        }
        this.loadtime += System.currentTimeMillis();
        this.memused -= rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        if (Desktop.desktop != null && Desktop.desktop.isShowMemoryUsage()) {
            if (this.alignFrame != null) {
                al = this.alignFrame.getViewport().getAlignment();
                System.out.println("Loaded '" + title + "' in " + (double)this.loadtime / 1000.0 + "s, took an additional " + 1.0 * (double)this.memused / 1048576.0 + " MB (" + al.getHeight() + " seqs by " + al.getWidth() + " cols)");
            } else {
                System.out.println("Failed to load '" + title + "' in " + (double)this.loadtime / 1000.0 + "s, took an additional " + 1.0 * (double)this.memused / 1048576.0 + " MB (alignment is null)");
            }
        }
        if (Desktop.instance != null) {
            Desktop.instance.stopLoading();
        }
    }

    private static String createNamedJvTempFile(String fileName, String extension) throws IOException {
        String seprator = System.getProperty("file.separator");
        String jvTempDir = System.getProperty("java.io.tmpdir") + "jalview" + seprator + System.currentTimeMillis();
        File tempStructFile = new File(jvTempDir + seprator + fileName + "." + extension);
        tempStructFile.mkdirs();
        return tempStructFile.toString();
    }
}

