/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileFormats {
    private static FileFormats instance = new FileFormats();
    private static Map<String, FileFormatI> formats;
    private static Set<FileFormatI> identifiable;

    public static FileFormats getInstance() {
        return instance;
    }

    private FileFormats() {
        this.reset();
    }

    public synchronized void reset() {
        formats = new LinkedHashMap<String, FileFormatI>();
        identifiable = new HashSet<FileFormatI>();
        for (FileFormat format : FileFormat.values()) {
            this.registerFileFormat(format, format.isIdentifiable());
        }
    }

    public boolean isIdentifiable(FileFormatI f) {
        return identifiable.contains(f);
    }

    public void registerFileFormat(FileFormatI format) {
        boolean isIdentifiable = format instanceof FileFormat && ((FileFormat)format).isIdentifiable();
        this.registerFileFormat(format, isIdentifiable);
    }

    protected void registerFileFormat(FileFormatI format, boolean isIdentifiable) {
        String name = format.getName().toUpperCase();
        if (formats.containsKey(name)) {
            System.err.println("Overwriting file format: " + format.getName());
        }
        formats.put(name, format);
        if (isIdentifiable) {
            identifiable.add(format);
        }
    }

    public void deregisterFileFormat(String name) {
        FileFormatI ff = formats.remove(name.toUpperCase());
        identifiable.remove(ff);
    }

    public List<String> getWritableFormats(boolean textOnly) {
        ArrayList<String> l = new ArrayList<String>();
        for (FileFormatI ff : formats.values()) {
            if (!ff.isWritable() || textOnly && !ff.isTextFormat()) continue;
            l.add(ff.getName());
        }
        return l;
    }

    public List<String> getReadableFormats() {
        ArrayList<String> l = new ArrayList<String>();
        for (FileFormatI ff : formats.values()) {
            if (!ff.isReadable()) continue;
            l.add(ff.getName());
        }
        return l;
    }

    public FileFormatI forName(String format) {
        return format == null ? null : formats.get(format.toUpperCase());
    }

    public Iterable<FileFormatI> getFormats() {
        return formats.values();
    }
}

