/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.SequenceIdMatcher;
import jalview.api.AlignViewportI;
import jalview.api.FeatureColourI;
import jalview.api.FeatureRenderer;
import jalview.api.FeaturesSourceI;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.SequenceDummy;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSet;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.gui.Desktop;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FastaFile;
import jalview.io.FileParse;
import jalview.io.gff.GffHelperFactory;
import jalview.io.gff.GffHelperI;
import jalview.schemes.FeatureColour;
import jalview.util.ColorUtils;
import jalview.util.MapList;
import jalview.util.ParseHtmlBodyAndLinks;
import jalview.util.StringUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class FeaturesFile
extends AlignFile
implements FeaturesSourceI {
    private static final String EQUALS = "=";
    private static final String TAB_REGEX = "\\t";
    private static final String STARTGROUP = "STARTGROUP";
    private static final String ENDGROUP = "ENDGROUP";
    private static final String STARTFILTERS = "STARTFILTERS";
    private static final String ENDFILTERS = "ENDFILTERS";
    private static final String ID_NOT_SPECIFIED = "ID_NOT_SPECIFIED";
    protected static final String GFF_VERSION = "##gff-version";
    private AlignmentI lastmatchedAl = null;
    private SequenceIdMatcher matcher = null;
    protected AlignmentI dataset;
    protected int gffVersion;

    public FeaturesFile() {
    }

    public FeaturesFile(Object file, DataSourceType paste) throws IOException {
        super(false, file, paste);
    }

    public FeaturesFile(FileParse source) throws IOException {
        super(source);
    }

    public FeaturesFile(boolean parseImmediately, Object file, DataSourceType type) throws IOException {
        super(parseImmediately, file, type);
    }

    public boolean parse(AlignmentI align, Map<String, FeatureColourI> colours, boolean removeHTML) {
        return this.parse(align, colours, removeHTML, false);
    }

    @Override
    public void addProperties(AlignmentI al) {
        super.addProperties(al);
        if (this.dataset != null && this.dataset.getCodonFrames() != null) {
            AlignmentI ds = al.getDataset() == null ? al : al.getDataset();
            for (AlignedCodonFrame codons : this.dataset.getCodonFrames()) {
                ds.addCodonFrame(codons);
            }
        }
    }

    public boolean parse(AlignmentI align, Map<String, FeatureColourI> colours, boolean removeHTML, boolean relaxedIdmatching) {
        return this.parse(align, colours, null, removeHTML, relaxedIdmatching);
    }

    public boolean parse(AlignmentI align, Map<String, FeatureColourI> colours, Map<String, FeatureMatcherSetI> filters, boolean removeHTML, boolean relaxedIdmatching) {
        HashMap<String, String> gffProps = new HashMap<String, String>();
        ArrayList<SequenceI> newseqs = new ArrayList<SequenceI>();
        String line = null;
        try {
            String featureGroup = null;
            while ((line = this.nextLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) {
                    if (!line.toLowerCase().startsWith("##")) continue;
                    this.processGffPragma(line, gffProps, align, newseqs);
                    continue;
                }
                String[] gffColumns = line.split(TAB_REGEX);
                if (gffColumns.length == 1 && line.trim().equalsIgnoreCase("GFF")) {
                    this.gffVersion = 2;
                    continue;
                }
                if (gffColumns.length > 0 && gffColumns.length < 4) {
                    String ft = gffColumns[0];
                    if (ft.equalsIgnoreCase(STARTFILTERS)) {
                        this.parseFilters(filters);
                        continue;
                    }
                    if (ft.equalsIgnoreCase(STARTGROUP)) {
                        featureGroup = gffColumns[1];
                        continue;
                    }
                    if (ft.equalsIgnoreCase(ENDGROUP)) {
                        featureGroup = null;
                        continue;
                    }
                    String colscheme = gffColumns[1];
                    FeatureColourI colour = FeatureColour.parseJalviewFeatureColour(colscheme);
                    if (colour == null) continue;
                    colours.put(ft, colour);
                    continue;
                }
                if (this.gffVersion == 0) {
                    this.parseJalviewFeature(line, gffColumns, align, colours, removeHTML, relaxedIdmatching, featureGroup);
                    continue;
                }
                this.parseGff(gffColumns, align, relaxedIdmatching, newseqs);
            }
            this.resetMatcher();
        }
        catch (Exception ex) {
            this.warningMessage = (this.warningMessage == null ? "" : this.warningMessage) + "Parsing error at\n" + line;
            System.out.println("Error parsing feature file: " + ex + "\n" + line);
            ex.printStackTrace(System.err);
            this.resetMatcher();
            return false;
        }
        for (SequenceI newseq : newseqs) {
            if (!newseq.getFeatures().hasFeatures()) continue;
            align.addSequence(newseq);
        }
        return true;
    }

    protected void parseFilters(Map<String, FeatureMatcherSetI> filters) throws IOException {
        String line;
        while ((line = this.nextLine()) != null) {
            if (line.toUpperCase().startsWith(ENDFILTERS)) {
                return;
            }
            String[] tokens = line.split(TAB_REGEX);
            if (tokens.length != 2) {
                System.err.println(String.format("Invalid token count %d for %d", tokens.length, line));
                continue;
            }
            String featureType = tokens[0];
            FeatureMatcherSet fm = FeatureMatcherSet.fromString(tokens[1]);
            if (fm == null || filters == null) continue;
            filters.put(featureType, fm);
        }
    }

    protected boolean parseJalviewFeature(String line, String[] gffColumns, AlignmentI alignment, Map<String, FeatureColourI> featureColours, boolean removeHTML, boolean relaxedIdMatching, String featureGroup) {
        if (gffColumns.length < 6) {
            System.err.println("Ignoring feature line '" + line + "' with too few columns (" + gffColumns.length + ")");
            return false;
        }
        String desc = gffColumns[0];
        String seqId = gffColumns[1];
        SequenceI seq = this.findSequence(seqId, alignment, null, relaxedIdMatching);
        if (!ID_NOT_SPECIFIED.equals(seqId)) {
            seq = this.findSequence(seqId, alignment, null, relaxedIdMatching);
        } else {
            seqId = null;
            seq = null;
            String seqIndex = gffColumns[2];
            try {
                int idx = Integer.parseInt(seqIndex);
                seq = alignment.getSequenceAt(idx);
            }
            catch (NumberFormatException ex) {
                System.err.println("Invalid sequence index: " + seqIndex);
            }
        }
        if (seq == null) {
            System.out.println("Sequence not found: " + line);
            return false;
        }
        int startPos = Integer.parseInt(gffColumns[3]);
        int endPos = Integer.parseInt(gffColumns[4]);
        String ft = gffColumns[5];
        if (!featureColours.containsKey(ft)) {
            Color colour = ColorUtils.createColourFromName(ft);
            featureColours.put(ft, new FeatureColour(colour));
        }
        SequenceFeature sf = null;
        if (gffColumns.length > 6) {
            float score = Float.NaN;
            try {
                score = Float.valueOf(gffColumns[6]).floatValue();
            }
            catch (NumberFormatException ex) {
                sf = new SequenceFeature(ft, desc, startPos, endPos, featureGroup);
            }
            sf = new SequenceFeature(ft, desc, startPos, endPos, score, featureGroup);
        } else {
            sf = new SequenceFeature(ft, desc, startPos, endPos, featureGroup);
        }
        this.parseDescriptionHTML(sf, removeHTML);
        seq.addSequenceFeature(sf);
        while (seqId != null && (seq = alignment.findName(seq, seqId, false)) != null) {
            seq.addSequenceFeature(new SequenceFeature(sf));
        }
        return true;
    }

    protected void resetMatcher() {
        this.lastmatchedAl = null;
        this.matcher = null;
    }

    protected SequenceI findSequence(String seqId, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) {
        SequenceI match = null;
        if (relaxedIdMatching) {
            if (this.lastmatchedAl != align) {
                this.lastmatchedAl = align;
                this.matcher = new SequenceIdMatcher(align.getSequencesArray());
                if (newseqs != null) {
                    this.matcher.addAll(newseqs);
                }
            }
            match = this.matcher.findIdMatch(seqId);
        } else {
            match = align.findName(seqId, true);
            if (match == null && newseqs != null) {
                for (SequenceI m : newseqs) {
                    if (!seqId.equals(m.getName())) continue;
                    return m;
                }
            }
        }
        if (match == null && newseqs != null) {
            match = new SequenceDummy(seqId);
            if (relaxedIdMatching) {
                this.matcher.addAll(Arrays.asList(match));
            }
            newseqs.add(match);
        }
        return match;
    }

    public void parseDescriptionHTML(SequenceFeature sf, boolean removeHTML) {
        if (sf.getDescription() == null) {
            return;
        }
        ParseHtmlBodyAndLinks parsed = new ParseHtmlBodyAndLinks(sf.getDescription(), removeHTML, this.newline);
        if (removeHTML) {
            sf.setDescription(parsed.getNonHtmlContent());
        }
        for (String link : parsed.getLinks()) {
            sf.addLink(link);
        }
    }

    public String printJalviewFormat(SequenceI[] sequences, FeatureRenderer fr, boolean includeNonPositional, boolean includeComplement) {
        Map<String, FeatureColourI> visibleColours = fr.getDisplayedFeatureCols();
        Map<String, FeatureMatcherSetI> featureFilters = fr.getFeatureFilters();
        StringBuilder out = new StringBuilder(256);
        if (visibleColours != null) {
            for (Map.Entry<String, FeatureColourI> featureColour : visibleColours.entrySet()) {
                FeatureColourI colour = featureColour.getValue();
                out.append(colour.toJalviewFormat(featureColour.getKey())).append(this.newline);
            }
        }
        String[] types = visibleColours == null ? new String[]{} : visibleColours.keySet().toArray(new String[visibleColours.keySet().size()]);
        this.outputFeatureFilters(out, visibleColours, featureFilters);
        int count = this.outputFeaturesByGroup(out, fr, types, sequences, includeNonPositional);
        if (includeComplement) {
            count += this.outputComplementFeatures(out, fr, sequences);
        }
        return count > 0 ? out.toString() : "No Features Visible";
    }

    private int outputComplementFeatures(StringBuilder out, FeatureRenderer fr, SequenceI[] sequences) {
        AlignViewportI comp = fr.getViewport().getCodingComplement();
        jalview.gui.FeatureRenderer fr2 = Desktop.getAlignFrameFor(comp).getFeatureRenderer();
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        int count = 0;
        for (SequenceI seq : sequences) {
            List<SequenceFeature> complementary = this.findComplementaryFeatures(seq, fr2);
            String seqName = seq.getName();
            for (SequenceFeature sf : complementary) {
                Map groupFeatures;
                String group = sf.getFeatureGroup();
                if (!map.containsKey(group)) {
                    map.put(group, new LinkedHashMap());
                }
                if (!(groupFeatures = (Map)map.get(group)).containsKey(seqName)) {
                    groupFeatures.put(seqName, new ArrayList());
                }
                List foundFeatures = (List)groupFeatures.get(seqName);
                foundFeatures.add(sf);
                ++count;
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            out.append(this.newline);
            String group = (String)entry.getKey();
            if (!"".equals(group)) {
                out.append(STARTGROUP).append("\t").append(group).append(this.newline);
            }
            Map seqFeaturesMap = (Map)entry.getValue();
            for (Map.Entry seqFeatures : seqFeaturesMap.entrySet()) {
                String sequenceName = (String)seqFeatures.getKey();
                for (SequenceFeature sf : (List)seqFeatures.getValue()) {
                    this.formatJalviewFeature(out, sequenceName, sf);
                }
            }
            if ("".equals(group)) continue;
            out.append(ENDGROUP).append("\t").append(group).append(this.newline);
        }
        return count;
    }

    protected List<SequenceFeature> findComplementaryFeatures(SequenceI seq, FeatureRenderer fr2) {
        ArrayList<SequenceFeature> found = new ArrayList<SequenceFeature>();
        ArrayList<SequenceFeature> complementary = new ArrayList<SequenceFeature>();
        for (int pos = seq.getStart(); pos <= seq.getEnd(); ++pos) {
            MappedFeatures mf = fr2.findComplementFeaturesAtResidue(seq, pos);
            if (mf == null) continue;
            for (SequenceFeature sf : mf.features) {
                if (found.contains(sf)) continue;
                String group = sf.getFeatureGroup();
                if (group == null) {
                    group = "";
                }
                found.add(sf);
                int begin = sf.getBegin();
                int end = sf.getEnd();
                int[] range = mf.getMappedPositions(begin, end);
                SequenceFeature sf2 = new SequenceFeature(sf, range[0], range[1], group, sf.getScore());
                complementary.add(sf2);
            }
        }
        return complementary;
    }

    void outputFeatureFilters(StringBuilder out, Map<String, FeatureColourI> visible, Map<String, FeatureMatcherSetI> featureFilters) {
        if (visible == null || featureFilters == null || featureFilters.isEmpty()) {
            return;
        }
        boolean first = true;
        for (String featureType : visible.keySet()) {
            FeatureMatcherSetI filter = featureFilters.get(featureType);
            if (filter == null) continue;
            if (first) {
                first = false;
                out.append(this.newline).append(STARTFILTERS).append(this.newline);
            }
            out.append(featureType).append("\t").append(filter.toStableString()).append(this.newline);
        }
        if (!first) {
            out.append(ENDFILTERS).append(this.newline);
        }
    }

    private int outputFeaturesByGroup(StringBuilder out, FeatureRenderer fr, String[] featureTypes, SequenceI[] sequences, boolean includeNonPositional) {
        List<String> featureGroups = fr.getFeatureGroups();
        ArrayList<String> sortedGroups = new ArrayList<String>(featureGroups);
        sortedGroups.remove(null);
        sortedGroups.remove("");
        Collections.sort(sortedGroups);
        sortedGroups.add(null);
        sortedGroups.add("");
        int count = 0;
        List<String> visibleGroups = fr.getDisplayedFeatureGroups();
        for (String group : sortedGroups) {
            boolean firstInGroup = true;
            boolean isNullGroup = group == null || "".equals(group);
            for (int i = 0; i < sequences.length; ++i) {
                String sequenceName = sequences[i].getName();
                ArrayList<SequenceFeature> features = new ArrayList<SequenceFeature>();
                if (includeNonPositional) {
                    features.addAll(sequences[i].getFeatures().getFeaturesForGroup(false, group, new String[0]));
                }
                if (featureTypes.length > 0 && (isNullGroup || visibleGroups.contains(group))) {
                    features.addAll(sequences[i].getFeatures().getFeaturesForGroup(true, group, featureTypes));
                }
                for (SequenceFeature sf : features) {
                    if (!sf.isNonPositional() && !fr.isVisible(sf)) continue;
                    ++count;
                    if (firstInGroup) {
                        out.append(this.newline);
                        if (!isNullGroup) {
                            out.append(STARTGROUP).append("\t").append(group).append(this.newline);
                        }
                    }
                    firstInGroup = false;
                    this.formatJalviewFeature(out, sequenceName, sf);
                }
            }
            if (isNullGroup || firstInGroup) continue;
            out.append(ENDGROUP).append("\t").append(group).append(this.newline);
        }
        return count;
    }

    protected void formatJalviewFeature(StringBuilder out, String sequenceName, SequenceFeature sequenceFeature) {
        if (sequenceFeature.description == null || sequenceFeature.description.equals("")) {
            out.append(sequenceFeature.type).append("\t");
        } else {
            if (sequenceFeature.links != null && sequenceFeature.getDescription().indexOf("<html>") == -1) {
                out.append("<html>");
            }
            out.append(sequenceFeature.description);
            if (sequenceFeature.links != null) {
                for (int l = 0; l < sequenceFeature.links.size(); ++l) {
                    String label = sequenceFeature.links.elementAt(l);
                    String href = label.substring(label.indexOf("|") + 1);
                    label = label.substring(0, label.indexOf("|"));
                    if (sequenceFeature.description.indexOf(href) != -1) continue;
                    out.append(" <a href=\"").append(href).append("\">").append(label).append("</a>");
                }
                if (sequenceFeature.getDescription().indexOf("</html>") == -1) {
                    out.append("</html>");
                }
            }
            out.append("\t");
        }
        out.append(sequenceName);
        out.append("\t-1\t");
        out.append(sequenceFeature.begin);
        out.append("\t");
        out.append(sequenceFeature.end);
        out.append("\t");
        out.append(sequenceFeature.type);
        if (!Float.isNaN(sequenceFeature.score)) {
            out.append("\t");
            out.append(sequenceFeature.score);
        }
        out.append(this.newline);
    }

    @Override
    public void parse() {
        HashMap<String, FeatureColourI> featureColours;
        boolean parseResult;
        AlignViewportI av = this.getViewport();
        if (av != null) {
            if (av.getAlignment() != null) {
                this.dataset = av.getAlignment().getDataset();
            }
            if (this.dataset == null) {
                this.dataset = av.getAlignment();
            }
        } else {
            this.dataset = new Alignment(new SequenceI[0]);
        }
        if (!(parseResult = this.parse(this.dataset, featureColours = new HashMap<String, FeatureColourI>(), false, true))) {
            // empty if block
        }
        if (av == null) {
            this.setSeqs(this.dataset.getSequencesArray());
        }
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        System.out.println("Use printGffFormat() or printJalviewFormat()");
        return null;
    }

    public String printGffFormat(SequenceI[] sequences, FeatureRenderer fr, boolean includeNonPositionalFeatures, boolean includeComplement) {
        jalview.gui.FeatureRenderer fr2 = null;
        if (includeComplement) {
            AlignViewportI comp = fr.getViewport().getCodingComplement();
            fr2 = Desktop.getAlignFrameFor(comp).getFeatureRenderer();
        }
        Map<String, FeatureColourI> visibleColours = fr.getDisplayedFeatureCols();
        StringBuilder out = new StringBuilder(256);
        out.append(String.format("%s %d\n", GFF_VERSION, this.gffVersion == 0 ? 2 : this.gffVersion));
        String[] types = visibleColours == null ? new String[]{} : visibleColours.keySet().toArray(new String[visibleColours.keySet().size()]);
        for (SequenceI seq : sequences) {
            ArrayList<SequenceFeature> seqFeatures = new ArrayList<SequenceFeature>();
            ArrayList<SequenceFeature> features = new ArrayList<SequenceFeature>();
            if (includeNonPositionalFeatures) {
                features.addAll(seq.getFeatures().getNonPositionalFeatures(new String[0]));
            }
            if (visibleColours != null && !visibleColours.isEmpty()) {
                features.addAll(seq.getFeatures().getPositionalFeatures(types));
            }
            for (SequenceFeature sf : features) {
                if (!sf.isNonPositional() && !fr.isVisible(sf)) continue;
                seqFeatures.add(sf);
            }
            if (includeComplement) {
                seqFeatures.addAll(this.findComplementaryFeatures(seq, fr2));
            }
            for (SequenceFeature sf : seqFeatures) {
                this.formatGffFeature(out, seq, sf);
                out.append(this.newline);
            }
        }
        return out.toString();
    }

    private void formatGffFeature(StringBuilder out, SequenceI seq, SequenceFeature sf) {
        String source = sf.featureGroup;
        if (source == null) {
            source = sf.getDescription();
        }
        out.append(seq.getName());
        out.append("\t");
        out.append(source);
        out.append("\t");
        out.append(sf.type);
        out.append("\t");
        out.append(sf.begin);
        out.append("\t");
        out.append(sf.end);
        out.append("\t");
        out.append(sf.score);
        out.append("\t");
        int strand = sf.getStrand();
        out.append(strand == 1 ? "+" : (strand == -1 ? "-" : "."));
        out.append("\t");
        String phase = sf.getPhase();
        out.append(phase == null ? "." : phase);
        if (sf.otherDetails != null && !sf.otherDetails.isEmpty()) {
            Map<String, Object> map = sf.otherDetails;
            this.formatAttributes(out, map);
        }
    }

    void formatAttributes(StringBuilder sb, Map<String, Object> map) {
        sb.append("\t");
        boolean first = true;
        for (String key : map.keySet()) {
            if ("STRAND".equals(key) || "!Phase".equals(key)) continue;
            if (!first) {
                sb.append(";");
            }
            first = false;
            Object value = map.get(key);
            if (value instanceof Map) {
                this.formatMapAttribute(sb, key, (Map)value);
                continue;
            }
            String formatted = StringUtils.urlEncode(value.toString(), ",=;\t%");
            sb.append(key).append(EQUALS).append(formatted);
        }
    }

    private void formatMapAttribute(StringBuilder sb, String key, Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        sb.append(key).append(EQUALS);
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(entry.getKey().toString()).append(EQUALS);
            String formatted = StringUtils.urlEncode(entry.getValue().toString(), ",=;\t%");
            sb.append(formatted);
        }
    }

    protected MapList constructCodonMappingFromAlign(List<String> alignedRegions, boolean mapIsFromCdna, int strand) throws IOException {
        if (strand == 0) {
            throw new IOException("Invalid strand for a codon mapping (cannot be 0)");
        }
        int regions = alignedRegions.size();
        int[] fromRanges = new int[regions * 2];
        int[] toRanges = new int[regions * 2];
        int fromRangesIndex = 0;
        int toRangesIndex = 0;
        for (String range : alignedRegions) {
            String[] tokens = range.split(" ");
            if (tokens.length != 3) {
                throw new IOException("Wrong number of fields for Align");
            }
            int fromStart = 0;
            int toStart = 0;
            int fromCount = 0;
            try {
                fromStart = Integer.parseInt(tokens[0]);
                toStart = Integer.parseInt(tokens[1]);
                fromCount = Integer.parseInt(tokens[2]);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Invalid number in Align field: " + nfe.getMessage());
            }
            if (!mapIsFromCdna) {
                fromCount *= 3;
                int temp = fromStart;
                fromStart = toStart;
                toStart = temp;
            }
            fromRanges[fromRangesIndex++] = fromStart;
            fromRanges[fromRangesIndex++] = fromStart + strand * (fromCount - 1);
            toRanges[toRangesIndex++] = toStart;
            toRanges[toRangesIndex++] = toStart + (fromCount - 1) / 3;
        }
        return new MapList(fromRanges, toRanges, 3, 1);
    }

    protected SequenceI parseGff(String[] gffColumns, AlignmentI alignment, boolean relaxedIdMatching, List<SequenceI> newseqs) {
        if (gffColumns.length < 5) {
            System.err.println("Ignoring GFF feature line with too few columns (" + gffColumns.length + ")");
            return null;
        }
        String seqId = gffColumns[0];
        SequenceI seq = this.findSequence(seqId, alignment, newseqs, relaxedIdMatching);
        SequenceFeature sf = null;
        GffHelperI helper = GffHelperFactory.getHelper(gffColumns);
        if (helper != null) {
            try {
                sf = helper.processGff(seq, gffColumns, alignment, newseqs, relaxedIdMatching);
                if (sf != null) {
                    seq.addSequenceFeature(sf);
                    while ((seq = alignment.findName(seq, seqId, true)) != null) {
                        seq.addSequenceFeature(new SequenceFeature(sf));
                    }
                }
            }
            catch (IOException e) {
                System.err.println("GFF parsing failed with: " + e.getMessage());
                return null;
            }
        }
        return seq;
    }

    protected void processAsFasta(AlignmentI align, List<SequenceI> newseqs) throws IOException {
        try {
            this.mark();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FastaFile parser = new FastaFile(this);
        Vector<SequenceI> includedseqs = parser.getSeqs();
        SequenceIdMatcher smatcher = new SequenceIdMatcher(newseqs);
        int pSize = includedseqs.size();
        for (int p = 0; p < pSize; ++p) {
            SequenceI includedSeq = (SequenceI)includedseqs.get(p);
            SequenceI dummyseq = smatcher.findIdMatch(includedSeq);
            if (dummyseq == null || !(dummyseq instanceof SequenceDummy)) continue;
            ((SequenceDummy)dummyseq).become(includedSeq);
            dummyseq.createDatasetSequence();
            for (AlignedCodonFrame mapping : align.getCodonFrames()) {
                mapping.updateToDataset(dummyseq);
            }
            includedseqs.set(p, dummyseq);
            newseqs.remove(dummyseq);
        }
        for (SequenceI seq : includedseqs) {
            String newName;
            AlignmentUtils.alignSequenceAs(seq, align, String.valueOf(align.getGapCharacter()), false, true);
            List<SequenceFeature> sfs = seq.getFeatures().getPositionalFeatures(new String[0]);
            if (!sfs.isEmpty() && (newName = (String)sfs.get(0).getValue("$RENAME_TO$")) != null) {
                seq.setName(newName);
            }
            align.addSequence(seq);
        }
    }

    protected void processGffPragma(String line, Map<String, String> gffProps, AlignmentI align, List<SequenceI> newseqs) throws IOException {
        String value;
        if ("###".equals(line = line.trim())) {
            return;
        }
        String[] tokens = line.substring(2).split(" ");
        String pragma = tokens[0];
        String string = value = tokens.length == 1 ? null : tokens[1];
        if ("gff-version".equalsIgnoreCase(pragma)) {
            if (value != null) {
                try {
                    this.gffVersion = Integer.parseInt(value.split("\\.")[0]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (!("sequence-region".equalsIgnoreCase(pragma) || "feature-ontology".equalsIgnoreCase(pragma) || "attribute-ontology".equalsIgnoreCase(pragma) || "source-ontology".equalsIgnoreCase(pragma))) {
            if ("species-build".equalsIgnoreCase(pragma)) {
                gffProps.put("species-build", value);
            } else if ("fasta".equalsIgnoreCase(pragma)) {
                this.processAsFasta(align, newseqs);
            } else {
                System.err.println("Ignoring unknown pragma: " + line);
            }
        }
    }
}

