/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.BackupFilenameParts;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class BackupFilenameFilter
implements FilenameFilter {
    public String base;
    public String template;
    public int digits;

    public BackupFilenameFilter(String base, String template, int digits) {
        this.base = base;
        this.template = template;
        this.digits = digits;
    }

    @Override
    public boolean accept(File dir, String filename) {
        try {
            File file = new File(dir.getCanonicalPath() + File.separatorChar + filename);
            if (file.isDirectory()) {
                return false;
            }
        }
        catch (IOException e) {
            System.out.println("IOException when checking file '" + filename + "' is a backupfile");
        }
        BackupFilenameParts bffp = new BackupFilenameParts(filename, this.base, this.template, this.digits);
        return bffp.isBackupFile();
    }
}

