/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.gui.AlignmentPanel;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ViewSelectionMenu
extends JMenu {
    private ViewSetProvider _allviews;
    private List<AlignmentViewPanel> _selectedviews;
    private ItemListener _handler;
    private boolean append = false;
    private boolean enabled = true;
    private JMenuItem selectAll;
    private JMenuItem invertSel;
    private JCheckBoxMenuItem toggleview = null;

    public ViewSelectionMenu(String title, ViewSetProvider allviews, List<AlignmentViewPanel> selectedviews, ItemListener handler) {
        super(title);
        this._allviews = allviews;
        this._selectedviews = selectedviews;
        this._handler = handler;
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ViewSelectionMenu.this.rebuild();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void rebuild() {
        this.removeAll();
        AlignmentPanel[] allviews = this._allviews.getAllAlignmentPanels();
        if (allviews == null) {
            this.setVisible(false);
            return;
        }
        if (allviews.length >= 2) {
            this.append = this.append || this._selectedviews.size() > 1;
            this.toggleview = new JCheckBoxMenuItem(MessageManager.getString("label.select_many_views"), this.append);
            this.toggleview.setToolTipText(MessageManager.getString("label.toggle_enabled_views"));
            this.toggleview.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (ViewSelectionMenu.this.enabled) {
                        ViewSelectionMenu.this.append = !ViewSelectionMenu.this.append;
                        ViewSelectionMenu.this.selectAll.setEnabled(ViewSelectionMenu.this.append);
                        ViewSelectionMenu.this.invertSel.setEnabled(ViewSelectionMenu.this.append);
                    }
                }
            });
            this.add(this.toggleview);
            this.selectAll = new JMenuItem(MessageManager.getString("label.select_all_views"));
            this.add(this.selectAll);
            this.selectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Component c : ViewSelectionMenu.this.getMenuComponents()) {
                        boolean t = ViewSelectionMenu.this.append;
                        ViewSelectionMenu.this.append = true;
                        if (c instanceof JCheckBoxMenuItem && ViewSelectionMenu.this.toggleview != c && !((JCheckBoxMenuItem)c).isSelected()) {
                            ((JCheckBoxMenuItem)c).doClick();
                        }
                        ViewSelectionMenu.this.append = t;
                    }
                }
            });
            this.invertSel = new JMenuItem(MessageManager.getString("label.invert_selection"));
            this.add(this.invertSel);
            this.invertSel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean t = ViewSelectionMenu.this.append;
                    ViewSelectionMenu.this.append = true;
                    for (Component c : ViewSelectionMenu.this.getMenuComponents()) {
                        if (ViewSelectionMenu.this.toggleview == c || !(c instanceof JCheckBoxMenuItem)) continue;
                        ((JCheckBoxMenuItem)c).doClick();
                    }
                    ViewSelectionMenu.this.append = t;
                }
            });
            this.invertSel.setEnabled(this.append);
            this.selectAll.setEnabled(this.append);
        }
        for (final AlignmentPanel ap : allviews) {
            String nm = (String)(ap.getViewName() == null || ap.getViewName().length() == 0 ? "" : ap.getViewName() + " for ") + ap.alignFrame.getTitle();
            final JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem(nm, this._selectedviews.contains(ap));
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ViewSelectionMenu.this.enabled) {
                        if (ViewSelectionMenu.this.append) {
                            ViewSelectionMenu.this.enabled = false;
                            if (ViewSelectionMenu.this._selectedviews.indexOf(ap) == -1) {
                                ViewSelectionMenu.this._selectedviews.add(ap);
                                checkBox.setSelected(true);
                            } else {
                                ViewSelectionMenu.this._selectedviews.remove(ap);
                                checkBox.setSelected(false);
                            }
                            ViewSelectionMenu.this.enabled = true;
                            ViewSelectionMenu.this._handler.itemStateChanged(e);
                        } else {
                            ViewSelectionMenu.this._selectedviews.clear();
                            ViewSelectionMenu.this._selectedviews.add(ap);
                            ViewSelectionMenu.this.enabled = false;
                            for (Component c : ViewSelectionMenu.this.getMenuComponents()) {
                                if (!(c instanceof JCheckBoxMenuItem)) continue;
                                ((JCheckBoxMenuItem)c).setSelected(checkBox == c);
                            }
                            ViewSelectionMenu.this.enabled = true;
                            ViewSelectionMenu.this._handler.itemStateChanged(e);
                        }
                    }
                }
            });
            checkBox.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    try {
                        ap.setSelected(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    try {
                        ap.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.add(checkBox);
        }
    }

    public static interface ViewSetProvider {
        public AlignmentPanel[] getAllAlignmentPanels();
    }
}

