/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.util.BrowserLauncher;
import jalview.util.MessageManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class UserQuestionnaireCheck
implements Runnable {
    String url = null;
    String qid = null;
    String rid = null;

    UserQuestionnaireCheck(String url) {
        if (url.indexOf("questionnaire.pl") == -1) {
            Cache.log.error((Object)("'" + url + "' is an Invalid URL for the checkForQuestionnaire() method.\nThis argument is only for questionnaires derived from jalview's questionnaire.pl cgi interface."));
        } else {
            this.url = url;
        }
    }

    private boolean checkresponse(URL qurl) throws Exception {
        String qresp;
        Cache.log.debug((Object)("Checking Response for : " + qurl));
        boolean prompt = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(qurl.openStream()));
        while ((qresp = br.readLine()) != null) {
            int p;
            if (qresp.indexOf("NOTYET:") == 0) {
                prompt = true;
                continue;
            }
            if (qresp.indexOf("QUESTIONNAIRE:") != 0 || (p = qresp.indexOf(58, 14)) <= -1) continue;
            this.rid = null;
            this.qid = qresp.substring(14, p);
            if (p >= qresp.length() - 1) continue;
            this.rid = qresp.substring(p + 1);
            prompt = true;
        }
        return prompt;
    }

    @Override
    public void run() {
        if (this.url == null) {
            return;
        }
        boolean prompt = false;
        try {
            String qurl;
            String lastq = Cache.getProperty("QUESTIONNAIRE");
            if (lastq == null) {
                prompt = this.checkresponse(new URL(this.url + (this.url.indexOf(63) > -1 ? "&" : "?") + "checkresponse=1"));
            } else {
                String qqid;
                qurl = this.url + (this.url.indexOf(63) > -1 ? "&" : "?") + "checkresponse=1";
                String string = qqid = lastq.indexOf(58) > -1 ? lastq.substring(0, lastq.indexOf(58)) : null;
                if (qqid != null && qqid != "null" && qqid.length() > 0) {
                    qurl = qurl + "&qid=" + qqid;
                    this.qid = qqid;
                    String qrid = lastq.substring(lastq.indexOf(58) + 1);
                    if (qrid != null && !qrid.equals("null")) {
                        this.rid = qrid;
                        qurl = qurl + "&rid=" + qrid;
                    }
                }
                prompt = this.checkresponse(new URL(qurl));
            }
            if (this.qid != null && this.rid != null) {
                Cache.setProperty("QUESTIONNAIRE", this.qid + ":" + this.rid);
            }
            if (prompt) {
                qurl = this.url + (this.url.indexOf(63) > -1 ? "&" : "?") + "qid=" + this.qid + "&rid=" + this.rid;
                Cache.log.info((Object)("Prompting user for questionnaire at " + qurl));
                int reply = JvOptionPane.showInternalConfirmDialog(Desktop.desktop, MessageManager.getString("label.jalview_new_questionnaire"), MessageManager.getString("label.jalview_user_survey"), 0, 3);
                if (reply == 0) {
                    Cache.log.debug((Object)("Opening " + qurl));
                    BrowserLauncher.openURL(qurl);
                }
            }
        }
        catch (Exception e) {
            Cache.log.warn((Object)("When trying to access questionnaire URL " + this.url), (Throwable)e);
        }
    }
}

