/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.datamodel.StructureViewerModel;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.ChimeraViewFrame;
import jalview.gui.ChimeraXViewFrame;
import jalview.gui.PymolViewer;
import jalview.gui.StructureViewerBase;
import jalview.structure.StructureSelectionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StructureViewer {
    private static final String UNKNOWN_VIEWER_TYPE = "Unknown structure viewer type ";
    StructureSelectionManager ssm;
    private boolean superposeAdded = true;
    JalviewStructureDisplayI sview = null;

    public StructureViewer(StructureSelectionManager structureSelectionManager) {
        this.ssm = structureSelectionManager;
    }

    public static StructureViewer reconfigure(JalviewStructureDisplayI display) {
        StructureViewer sv = new StructureViewer(display.getBinding().getSsm());
        sv.sview = display;
        return sv;
    }

    public String toString() {
        if (this.sview != null) {
            return this.sview.toString();
        }
        return "New View";
    }

    public ViewerType getViewerType() {
        String viewType = Cache.getDefault("STRUCTURE_DISPLAY", ViewerType.JMOL.name());
        return ViewerType.valueOf(viewType);
    }

    public void setViewerType(ViewerType type) {
        Cache.setProperty("STRUCTURE_DISPLAY", type.name());
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry[] pdbs, SequenceI[] seqs, final AlignmentPanel ap) {
        JalviewStructureDisplayI viewer = this.onlyOnePdb(pdbs, seqs, ap);
        if (viewer != null) {
            return viewer;
        }
        ViewerType viewerType = this.getViewerType();
        Map<PDBEntry, SequenceI[]> seqsForPdbs = this.getSequencesForPdbs(pdbs, seqs);
        final PDBEntry[] pdbsForFile = seqsForPdbs.keySet().toArray(new PDBEntry[seqsForPdbs.size()]);
        final SequenceI[][] theSeqs = (SequenceI[][])seqsForPdbs.values().toArray((T[])new SequenceI[seqsForPdbs.size()][]);
        if (this.sview != null) {
            this.sview.setAlignAddedStructures(this.superposeAdded);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int pdbep = 0; pdbep < pdbsForFile.length; ++pdbep) {
                        PDBEntry pdb = pdbsForFile[pdbep];
                        if (StructureViewer.this.sview.addAlreadyLoadedFile(theSeqs[pdbep], null, ap, pdb.getId())) continue;
                        StructureViewer.this.sview.addToExistingViewer(pdb, theSeqs[pdbep], null, ap, pdb.getId());
                    }
                    StructureViewer.this.sview.updateTitleAndMenus();
                }
            }).start();
            return this.sview;
        }
        if (viewerType.equals((Object)ViewerType.JMOL)) {
            this.sview = new AppJmol(ap, this.superposeAdded, pdbsForFile, theSeqs);
        } else if (viewerType.equals((Object)ViewerType.CHIMERA)) {
            this.sview = new ChimeraViewFrame(pdbsForFile, this.superposeAdded, theSeqs, ap);
        } else if (viewerType.equals((Object)ViewerType.CHIMERAX)) {
            this.sview = new ChimeraXViewFrame(pdbsForFile, this.superposeAdded, theSeqs, ap);
        } else if (viewerType.equals((Object)ViewerType.PYMOL)) {
            this.sview = new PymolViewer(pdbsForFile, this.superposeAdded, theSeqs, ap);
        } else {
            Cache.log.error((Object)(UNKNOWN_VIEWER_TYPE + this.getViewerType().toString()));
        }
        return this.sview;
    }

    Map<PDBEntry, SequenceI[]> getSequencesForPdbs(PDBEntry[] pdbs, SequenceI[] seqs) {
        if (pdbs == null || seqs == null || pdbs.length != seqs.length) {
            return null;
        }
        HashMap<String, PDBEntry> pdbsSeen = new HashMap<String, PDBEntry>();
        LinkedHashMap pdbSeqs = new LinkedHashMap();
        for (int i = 0; i < pdbs.length; ++i) {
            PDBEntry pdb = pdbs[i];
            SequenceI seq = seqs[i];
            String pdbFile = pdb.getFile();
            if (pdbFile == null || pdbFile.length() == 0) {
                pdbFile = pdb.getId();
            }
            if (!pdbsSeen.containsKey(pdbFile)) {
                pdbsSeen.put(pdbFile, pdb);
                pdbSeqs.put(pdb, new ArrayList());
            } else {
                pdb = (PDBEntry)pdbsSeen.get(pdbFile);
            }
            List seqsForPdb = (List)pdbSeqs.get(pdb);
            if (seqsForPdb.contains(seq)) continue;
            seqsForPdb.add(seq);
        }
        LinkedHashMap<PDBEntry, SequenceI[]> result = new LinkedHashMap<PDBEntry, SequenceI[]>();
        for (Map.Entry entry : pdbSeqs.entrySet()) {
            List theSeqs = (List)entry.getValue();
            result.put((PDBEntry)entry.getKey(), theSeqs.toArray(new SequenceI[theSeqs.size()]));
        }
        return result;
    }

    private JalviewStructureDisplayI onlyOnePdb(PDBEntry[] pdbs, SequenceI[] seqsForPdbs, AlignmentPanel ap) {
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        if (pdbs == null || pdbs.length == 0) {
            return null;
        }
        int i = 0;
        String firstFile = pdbs[0].getFile();
        for (PDBEntry pdb : pdbs) {
            SequenceI pdbseq;
            String pdbFile = pdb.getFile();
            if (pdbFile == null || !pdbFile.equals(firstFile)) {
                return null;
            }
            if ((pdbseq = seqsForPdbs[i++]) == null) continue;
            seqs.add(pdbseq);
        }
        return this.viewStructures(pdbs[0], seqs.toArray(new SequenceI[seqs.size()]), ap);
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry pdb, SequenceI[] seqsForPdb, AlignmentPanel ap) {
        if (this.sview != null) {
            this.sview.setAlignAddedStructures(this.superposeAdded);
            String pdbId = pdb.getId();
            if (!this.sview.addAlreadyLoadedFile(seqsForPdb, null, ap, pdbId)) {
                this.sview.addToExistingViewer(pdb, seqsForPdb, null, ap, pdbId);
            }
            this.sview.updateTitleAndMenus();
            this.sview.raiseViewer();
            return this.sview;
        }
        ViewerType viewerType = this.getViewerType();
        if (viewerType.equals((Object)ViewerType.JMOL)) {
            this.sview = new AppJmol(pdb, seqsForPdb, null, ap);
        } else if (viewerType.equals((Object)ViewerType.CHIMERA)) {
            this.sview = new ChimeraViewFrame(pdb, seqsForPdb, null, ap);
        } else if (viewerType.equals((Object)ViewerType.CHIMERAX)) {
            this.sview = new ChimeraXViewFrame(pdb, seqsForPdb, null, ap);
        } else if (viewerType.equals((Object)ViewerType.PYMOL)) {
            this.sview = new PymolViewer(pdb, seqsForPdb, null, ap);
        } else {
            Cache.log.error((Object)(UNKNOWN_VIEWER_TYPE + this.getViewerType().toString()));
        }
        return this.sview;
    }

    public static JalviewStructureDisplayI createView(ViewerType type, AlignmentPanel alignPanel, StructureViewerModel viewerData, String sessionFile, String vid) {
        StructureViewerBase viewer = null;
        switch (type) {
            case JMOL: {
                viewer = new AppJmol(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            case CHIMERA: {
                viewer = new ChimeraViewFrame(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            case CHIMERAX: {
                viewer = new ChimeraXViewFrame(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            case PYMOL: {
                viewer = new PymolViewer(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            default: {
                Cache.log.error((Object)(UNKNOWN_VIEWER_TYPE + type.toString()));
            }
        }
        return viewer;
    }

    public boolean isBusy() {
        return this.sview != null && !this.sview.hasMapping();
    }

    public boolean hasPdbId(String pDBid) {
        if (this.sview == null) {
            return false;
        }
        return this.sview.getBinding().hasPdbId(pDBid);
    }

    public boolean isVisible() {
        return this.sview != null && this.sview.isVisible();
    }

    public void setSuperpose(boolean alignAddedStructures) {
        this.superposeAdded = alignAddedStructures;
    }

    public static enum ViewerType {
        JMOL,
        CHIMERA,
        CHIMERAX,
        PYMOL;

    }
}

