/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.util.ChannelProperties;
import jalview.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SplashScreen
extends JPanel
implements Runnable,
HyperlinkListener {
    private static final int SHOW_FOR_SECS = 5;
    private static final int FONT_SIZE = 11;
    private boolean visible = true;
    private JPanel iconimg = new JPanel(new BorderLayout());
    private static Color bg = Color.WHITE;
    private static Color fg = Color.BLACK;
    private static Font font = new Font("SansSerif", 0, 11);
    private Component splashText;
    private JInternalFrame iframe;
    private Image image;
    private boolean transientDialog = false;
    private long oldTextLength = -1L;
    public static int logoSize = 32;
    private MouseAdapter closer = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent evt) {
            if (SplashScreen.this.transientDialog) {
                try {
                    SplashScreen.this.visible = false;
                    SplashScreen.this.closeSplash();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public SplashScreen(boolean isTransient) {
        this.transientDialog = isTransient;
        if (Platform.isJS()) {
            this.splashText = new JLabel("");
            this.run();
        } else {
            this.splashText = new JTextPane();
            this.splashText.setBackground(bg);
            this.splashText.setForeground(fg);
            this.splashText.setFont(font);
            Thread t = new Thread(this);
            t.start();
        }
    }

    void initSplashScreenWindow() {
        block8: {
            this.addMouseListener(this.closer);
            try {
                if (Platform.isJS()) break block8;
                this.image = ChannelProperties.getImage("banner");
                Image logo = ChannelProperties.getImage("logo.48");
                MediaTracker mt = new MediaTracker(this);
                if (this.image != null) {
                    mt.addImage(this.image, 0);
                }
                if (logo != null) {
                    mt.addImage(logo, 1);
                }
                do {
                    try {
                        mt.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!mt.isErrorAny()) continue;
                    System.err.println("Error when loading images!");
                } while (!mt.checkAll());
                Desktop.instance.setIconImages(ChannelProperties.getIconList());
            }
            catch (Exception logo) {
                // empty catch block
            }
        }
        this.setBackground(bg);
        this.setForeground(fg);
        this.setFont(font);
        this.iframe = new JInternalFrame();
        this.iframe.setFrameIcon(null);
        this.iframe.setClosable(true);
        this.setLayout(new BorderLayout());
        this.iframe.setContentPane(this);
        this.iframe.setLayer(JLayeredPane.PALETTE_LAYER);
        this.iframe.setBackground(bg);
        this.iframe.setForeground(fg);
        this.iframe.setFont(font);
        if (!Platform.isJS()) {
            ((JTextPane)this.splashText).setEditable(false);
            this.splashText.setBackground(bg);
            this.splashText.setForeground(fg);
            this.splashText.setFont(font);
            SplashImage splashimg = new SplashImage(this.image);
            this.iconimg.add((Component)splashimg, "Before");
            this.iconimg.setBackground(bg);
            this.add((Component)this.iconimg, "North");
        }
        this.add(this.splashText, "Center");
        this.splashText.addMouseListener(this.closer);
        Desktop.desktop.add(this.iframe);
        this.refreshText();
    }

    protected boolean refreshText() {
        String newtext = Desktop.instance.getAboutMessage();
        if (this.oldTextLength != (long)newtext.length()) {
            this.iframe.setVisible(false);
            this.oldTextLength = newtext.length();
            if (Platform.isJS()) {
                String text = "<html><br><img src=\"" + ChannelProperties.getImageURL("banner") + "\"/>" + newtext + "<br></html>";
                JLabel ta = new JLabel(text);
                ta.setOpaque(true);
                ta.setBackground(Color.white);
                this.splashText = ta;
            } else {
                JTextPane jtp = new JTextPane();
                jtp.setEditable(false);
                jtp.setBackground(bg);
                jtp.setForeground(fg);
                jtp.setFont(font);
                jtp.setContentType("text/html");
                jtp.setText("<html>" + newtext + "</html>");
                jtp.addHyperlinkListener(this);
                this.splashText = jtp;
            }
            this.splashText.addMouseListener(this.closer);
            this.splashText.setVisible(true);
            this.splashText.setSize(new Dimension(750, 375 + logoSize + (Platform.isJS() ? 40 : 0)));
            this.splashText.setBackground(bg);
            this.splashText.setForeground(fg);
            this.splashText.setFont(font);
            this.add(this.splashText, "Center");
            this.revalidate();
            int width = Math.max(this.splashText.getWidth(), this.iconimg.getWidth());
            int height = this.splashText.getHeight() + this.iconimg.getHeight();
            this.iframe.setBounds(Math.max(0, (Desktop.instance.getWidth() - width) / 2), Math.max(0, (Desktop.instance.getHeight() - height) / 2), width, height);
            this.iframe.validate();
            this.iframe.setVisible(true);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.initSplashScreenWindow();
        long startTime = System.currentTimeMillis() / 1000L;
        while (this.visible) {
            this.iframe.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.transientDialog && System.currentTimeMillis() / 1000L - startTime > 5L) {
                this.visible = false;
            }
            if (this.visible && this.refreshText()) {
                this.iframe.repaint();
            }
            if (this.transientDialog) continue;
            return;
        }
        this.closeSplash();
        Desktop.instance.startDialogQueue();
    }

    public void closeSplash() {
        try {
            this.iframe.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Desktop.hyperlinkUpdate(e);
    }

    public class SplashImage
    extends JPanel {
        Image image;

        public SplashImage(Image todisplay) {
            this.image = todisplay;
            if (this.image != null) {
                this.setPreferredSize(new Dimension(this.image.getWidth(this) + 8, this.image.getHeight(this)));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(this) + 8, this.image.getHeight(this));
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(fg);
            g.setFont(new Font(font.getFontName(), 1, 17));
            if (this.image != null) {
                g.drawImage(this.image, (this.getWidth() - this.image.getWidth(this)) / 2, (this.getHeight() - this.image.getHeight(this)) / 2, this);
            }
        }
    }
}

