/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueColourFinder;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.util.Comparison;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jibble.epsgraphics.EpsGraphics2D;

public class SequenceRenderer
implements jalview.api.SequenceRenderer {
    static final int CHAR_TO_UPPER = -32;
    AlignViewportI av;
    FontMetrics fm;
    boolean renderGaps = true;
    SequenceGroup[] allGroups = null;
    Graphics graphics;
    boolean monospacedFont;
    ResidueColourFinder resColourFinder;

    public SequenceRenderer(AlignViewportI viewport) {
        this.av = viewport;
        this.resColourFinder = new ResidueColourFinder();
    }

    public void prepare(Graphics g, boolean renderGaps) {
        this.graphics = g;
        this.fm = g.getFontMetrics();
        double dwidth = this.fm.getStringBounds("M", g).getWidth();
        this.monospacedFont = dwidth == this.fm.getStringBounds("|", g).getWidth() && (double)this.av.getCharWidth() == dwidth;
        this.renderGaps = renderGaps;
    }

    @Override
    public Color getResidueColour(SequenceI seq, int position, FeatureColourFinder finder) {
        this.allGroups = this.av.getAlignment().findAllGroups(seq);
        return this.resColourFinder.getResidueColour(this.av.getShowBoxes(), this.av.getResidueShading(), this.allGroups, seq, position, finder);
    }

    public void drawSequence(SequenceI seq, SequenceGroup[] sg, int start, int end, int y1) {
        this.allGroups = sg;
        this.drawBoxes(seq, start, end, y1);
        if (this.av.isValidCharWidth()) {
            this.drawText(seq, start, end, y1);
        }
    }

    public synchronized void drawBoxes(SequenceI seq, int start, int end, int y1) {
        Color resBoxColour = Color.white;
        if (seq == null) {
            return;
        }
        int length = seq.getLength();
        int curStart = -1;
        int curWidth = this.av.getCharWidth();
        int avWidth = this.av.getCharWidth();
        int avHeight = this.av.getCharHeight();
        Color tempColour = null;
        for (int i = start; i <= end; ++i) {
            resBoxColour = Color.white;
            if (i < length) {
                SequenceGroup currentSequenceGroup = this.resColourFinder.getCurrentSequenceGroup(this.allGroups, i);
                if (currentSequenceGroup != null) {
                    if (currentSequenceGroup.getDisplayBoxes()) {
                        resBoxColour = this.resColourFinder.getBoxColour(currentSequenceGroup.getGroupColourScheme(), seq, i);
                    }
                } else if (this.av.getShowBoxes()) {
                    resBoxColour = this.resColourFinder.getBoxColour(this.av.getResidueShading(), seq, i);
                }
            }
            if (resBoxColour != tempColour) {
                if (tempColour != null) {
                    this.graphics.fillRect(avWidth * (curStart - start), y1, curWidth, avHeight);
                }
                this.graphics.setColor(resBoxColour);
                curStart = i;
                curWidth = avWidth;
                tempColour = resBoxColour;
                continue;
            }
            curWidth += avWidth;
        }
        this.graphics.fillRect(avWidth * (curStart - start), y1, curWidth, avHeight);
    }

    public void drawText(SequenceI seq, int start, int end, int y1) {
        boolean drawAllText;
        y1 += this.av.getCharHeight() - this.av.getCharHeight() / 5;
        int charOffset = 0;
        if (end + 1 >= seq.getLength()) {
            end = seq.getLength() - 1;
        }
        this.graphics.setColor(this.av.getTextColour());
        boolean bl = drawAllText = this.monospacedFont && this.av.getShowText() && this.allGroups.length == 0 && !this.av.getColourText() && this.av.getThresholdTextColour() == 0;
        if (this.graphics instanceof EpsGraphics2D || this.graphics instanceof SVGGraphics2D) {
            drawAllText = false;
        }
        if (drawAllText) {
            if (this.av.isRenderGaps()) {
                this.graphics.drawString(seq.getSequenceAsString(start, end + 1), 0, y1);
            } else {
                char gap = this.av.getGapCharacter();
                this.graphics.drawString(seq.getSequenceAsString(start, end + 1).replace(gap, ' '), 0, y1);
            }
        } else {
            boolean srep = this.av.isDisplayReferenceSeq();
            boolean getboxColour = false;
            boolean isarep = this.av.getAlignment().getSeqrep() == seq;
            Color resBoxColour = Color.white;
            for (int i = start; i <= end; ++i) {
                this.graphics.setColor(this.av.getTextColour());
                getboxColour = false;
                char s = seq.getCharAt(i);
                if (!this.renderGaps && Comparison.isGap(s)) continue;
                SequenceGroup currentSequenceGroup = this.resColourFinder.getCurrentSequenceGroup(this.allGroups, i);
                if (currentSequenceGroup != null) {
                    boolean isgrep;
                    if (!currentSequenceGroup.getDisplayText()) continue;
                    if (currentSequenceGroup.thresholdTextColour > 0 || currentSequenceGroup.getColourText()) {
                        getboxColour = true;
                        resBoxColour = this.resColourFinder.getBoxColour(currentSequenceGroup.getGroupColourScheme(), seq, i);
                        if (currentSequenceGroup.getColourText()) {
                            this.graphics.setColor(resBoxColour.darker());
                        }
                        if (currentSequenceGroup.thresholdTextColour > 0 && resBoxColour.getRed() + resBoxColour.getBlue() + resBoxColour.getGreen() < currentSequenceGroup.thresholdTextColour) {
                            this.graphics.setColor(currentSequenceGroup.textColour2);
                        }
                    } else {
                        this.graphics.setColor(currentSequenceGroup.textColour);
                    }
                    boolean bl2 = currentSequenceGroup != null ? currentSequenceGroup.getSeqrep() == seq : (isgrep = false);
                    if (!isarep && !isgrep && currentSequenceGroup.getShowNonconserved()) {
                        s = this.getDisplayChar(srep, i, s, '.', currentSequenceGroup);
                    }
                } else {
                    if (!this.av.getShowText()) continue;
                    if (this.av.getColourText()) {
                        getboxColour = true;
                        resBoxColour = this.resColourFinder.getBoxColour(this.av.getResidueShading(), seq, i);
                        if (this.av.getShowBoxes()) {
                            this.graphics.setColor(resBoxColour.darker());
                        } else {
                            this.graphics.setColor(resBoxColour);
                        }
                    }
                    if (this.av.getThresholdTextColour() > 0) {
                        if (!getboxColour) {
                            resBoxColour = this.resColourFinder.getBoxColour(this.av.getResidueShading(), seq, i);
                        }
                        if (resBoxColour.getRed() + resBoxColour.getBlue() + resBoxColour.getGreen() < this.av.getThresholdTextColour()) {
                            this.graphics.setColor(this.av.getTextColour2());
                        }
                    }
                    if (!isarep && this.av.getShowUnconserved()) {
                        s = this.getDisplayChar(srep, i, s, '.', null);
                    }
                }
                charOffset = (this.av.getCharWidth() - this.fm.charWidth(s)) / 2;
                this.graphics.drawString(String.valueOf(s), charOffset + this.av.getCharWidth() * (i - start), y1);
            }
        }
    }

    private char getDisplayChar(boolean usesrep, int position, char sequenceChar, char conservedChar, SequenceGroup currentGroup) {
        char conschar;
        char c = usesrep ? (currentGroup == null || position < currentGroup.getStartRes() || position > currentGroup.getEndRes() ? this.av.getAlignment().getSeqrep().getCharAt(position) : (currentGroup.getSeqrep() != null ? currentGroup.getSeqrep().getCharAt(position) : this.av.getAlignment().getSeqrep().getCharAt(position))) : (conschar = currentGroup != null && currentGroup.getConsensus() != null && position >= currentGroup.getStartRes() && position <= currentGroup.getEndRes() && currentGroup.getConsensus().annotations.length > position ? currentGroup.getConsensus().annotations[position].displayCharacter.charAt(0) : this.av.getAlignmentConsensusAnnotation().annotations[position].displayCharacter.charAt(0));
        if (!(Comparison.isGap(conschar) || sequenceChar != conschar && sequenceChar + -32 != conschar)) {
            sequenceChar = conservedChar;
        }
        return sequenceChar;
    }

    public void drawHighlightedText(SequenceI seq, int start, int end, int x1, int y1) {
        int pady = this.av.getCharHeight() / 5;
        int charOffset = 0;
        this.graphics.setColor(Color.BLACK);
        this.graphics.fillRect(x1, y1, this.av.getCharWidth() * (end - start + 1), this.av.getCharHeight());
        this.graphics.setColor(Color.white);
        char s = '~';
        if (this.av.isValidCharWidth()) {
            for (int i = start; i <= end; ++i) {
                if (i < seq.getLength()) {
                    s = seq.getCharAt(i);
                }
                charOffset = (this.av.getCharWidth() - this.fm.charWidth(s)) / 2;
                this.graphics.drawString(String.valueOf(s), charOffset + x1 + this.av.getCharWidth() * (i - start), y1 + this.av.getCharHeight() - pady);
            }
        }
    }

    public void drawCursor(Graphics g, char s, int x1, int y1) {
        int pady = this.av.getCharHeight() / 5;
        int charOffset = 0;
        g.setColor(Color.black);
        g.fillRect(x1, y1, this.av.getCharWidth(), this.av.getCharHeight());
        if (this.av.isValidCharWidth()) {
            g.setColor(Color.white);
            charOffset = (this.av.getCharWidth() - this.fm.charWidth(s)) / 2;
            g.drawString(String.valueOf(s), charOffset + x1, y1 + this.av.getCharHeight() - pady);
        }
    }
}

