/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.JalviewDialog;
import jalview.gui.OptsAndParamsPage;
import jalview.gui.OptsParametersContainerI;
import jalview.gui.RestServiceEditorPane;
import jalview.jbgui.GRestInputParamEditDialog;
import jalview.ws.params.InvalidArgumentException;
import jalview.ws.params.OptionI;
import jalview.ws.params.ParameterI;
import jalview.ws.rest.InputType;
import jalview.ws.rest.RestServiceDescription;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import net.miginfocom.swing.MigLayout;

public class RestInputParamEditDialog
extends GRestInputParamEditDialog
implements OptsParametersContainerI {
    Hashtable<String, Class> typeclass = new Hashtable();
    Hashtable<String, ArrayList<JPanel>> typeopts = new Hashtable();
    Hashtable<String, OptsAndParamsPage> opanps = new Hashtable();
    int reply;
    JalviewDialog frame = new JalviewDialog(){

        @Override
        protected void raiseClosed() {
        }

        @Override
        protected void okPressed() {
            RestInputParamEditDialog.this.reply = 0;
        }

        @Override
        protected void cancelPressed() {
            RestInputParamEditDialog.this.reply = 2;
        }
    };
    InputType old;
    InputType current;
    boolean updated = false;

    private InputType getTypeFor(String name) {
        try {
            return (InputType)this.typeclass.get(name).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable x) {
            System.err.println("Unexpected exception when instantiating rest input type.");
            x.printStackTrace();
            return null;
        }
    }

    public RestInputParamEditDialog(RestServiceEditorPane restServiceEditorPane, RestServiceDescription currentservice, InputType toedit) {
        this.initFor(restServiceEditorPane, currentservice, toedit);
        this.frame.waitForInput();
    }

    private void initFor(RestServiceEditorPane restServiceEditorPane, RestServiceDescription currentservice, InputType toedit) {
        this.okcancel.add(this.frame.cancel);
        this.okcancel.add(this.frame.ok);
        this.frame.initDialogFrame(this.dpane, true, true, "Edit parameter for service " + currentservice.getName(), 600, 800);
        this.initTypeLists();
        this.reply = 2;
        this.old = toedit;
        this.current = null;
        if (this.old != null) {
            this.setStateFor(this.old);
        }
        this.updated = this.updated && this.reply == 0;
        this.frame.validate();
    }

    public RestInputParamEditDialog(RestServiceEditorPane restServiceEditorPane, RestServiceDescription currentservice, String string) {
        this.initFor(restServiceEditorPane, currentservice, null);
        this.tok.setText(string);
        this.frame.waitForInput();
    }

    private void setStateFor(InputType current) {
        this.tok.setText(current.token);
        OptsAndParamsPage opanp = this.opanps.get(current.getURLtokenPrefix());
        for (OptionI ops : current.getOptions()) {
            if (ops instanceof ParameterI) {
                opanp.setParameter((ParameterI)ops);
                continue;
            }
            if (ops.getValue() == null || ops.getValue().length() <= 0) continue;
            opanp.selectOption(ops, ops.getValue());
        }
        this.typeList.setSelectedValue(current.getURLtokenPrefix(), true);
        this.type_SelectionChangedActionPerformed(null);
    }

    private void updateCurrentType() {
        InputType newType;
        if (this.typeList.getSelectedValue() != null && (newType = this.getTypeFor((String)this.typeList.getSelectedValue())) != null) {
            newType.token = this.tok.getText().trim();
            try {
                newType.configureFromArgumentI(this.opanps.get(newType.getURLtokenPrefix()).getCurrentSettings());
                this.current = newType;
                this.updated = true;
            }
            catch (InvalidArgumentException ex) {
                System.err.println("IMPLEMENTATION ERROR: Invalid argument for type : " + this.typeList.getSelectedValue() + "\n");
                ex.printStackTrace();
            }
        }
    }

    private void initTypeLists() {
        ArrayList<String> types = new ArrayList<String>();
        for (Class type : RestServiceDescription.getInputTypes()) {
            InputType jtype = null;
            try {
                JPanel inopts = new JPanel((LayoutManager)new MigLayout());
                ArrayList<JPanel> opts = new ArrayList<JPanel>();
                ArrayList<OptsAndParamsPage.ParamBox> prms = new ArrayList<OptsAndParamsPage.ParamBox>();
                jtype = (InputType)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.typeclass.put(jtype.getURLtokenPrefix(), type);
                OptsAndParamsPage opanp = new OptsAndParamsPage(this, true);
                this.opanps.put(jtype.getURLtokenPrefix(), opanp);
                for (OptionI optionI : jtype.getOptions()) {
                    if (optionI instanceof ParameterI) {
                        prms.add(opanp.addParameter((ParameterI)optionI));
                        continue;
                    }
                    opts.add(opanp.addOption(optionI));
                }
                for (JPanel jPanel : prms) {
                    opts.add(jPanel);
                }
                this.typeopts.put(jtype.getURLtokenPrefix(), opts);
                types.add(jtype.getURLtokenPrefix());
            }
            catch (Throwable x) {
                System.err.println("Unexpected exception when instantiating rest input type.");
                x.printStackTrace();
            }
        }
        this.typeList.setListData(types.toArray());
    }

    @Override
    protected void type_SelectionChangedActionPerformed(ListSelectionEvent e) {
        this.options.removeAll();
        String typen = (String)this.typeList.getSelectedValue();
        if (this.typeopts.get(typen) != null) {
            for (JPanel opt : this.typeopts.get(typen)) {
                opt.setOpaque(true);
                this.options.add((Component)opt, "wrap");
            }
            this.options.invalidate();
            this.optionsPanel.setVisible(true);
        } else {
            this.optionsPanel.setVisible(false);
        }
        this.dpane.revalidate();
        this.updateCurrentType();
    }

    public boolean wasUpdated() {
        return this.updated;
    }

    @Override
    public void refreshParamLayout() {
        this.options.invalidate();
        this.dpane.revalidate();
    }

    @Override
    protected void tokChanged_actionPerformed() {
        if (this.tok.getText().trim().length() > 0 && this.current != null) {
            this.current.token = this.tok.getText().trim();
            this.updated = true;
        }
    }

    @Override
    public void argSetModified(Object modifiedElement, boolean b) {
        this.updated |= b;
        if (this.updated) {
            this.updateCurrentType();
        }
    }
}

