/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.RendererListenerI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class ProgressPanel
extends JPanel
implements RendererListenerI {
    private final int MAXVALUE = 100;
    private final String VISIBLE = "VISIBLE";
    private final String INVISIBLE = "INVISIBLE";
    private String eventName;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JPanel labelPanel = new JPanel();
    private CardLayout labelLayout = new CardLayout();
    private JPanel barPanel = new JPanel();
    private CardLayout barLayout = new CardLayout();

    public ProgressPanel(String eventPropertyName, String label, int maxwidth) {
        super(new BorderLayout(10, 0));
        this.setBorder(new EmptyBorder(0, 3, 0, 0));
        this.eventName = eventPropertyName;
        String labelText = label;
        final int w = maxwidth;
        this.progressBar = new JProgressBar(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(w, 1);
            }
        };
        this.progressBar.setMinimum(0);
        this.progressBar.setPreferredSize(this.progressBar.getMaximumSize());
        this.progressLabel = new JLabel(labelText);
        this.progressLabel.setFont(new Font("Verdana", 0, 11));
        this.labelPanel.setLayout(this.labelLayout);
        this.barPanel.setLayout(this.barLayout);
        this.labelPanel.add((Component)this.progressLabel, "VISIBLE");
        this.labelPanel.add((Component)new JPanel(), "INVISIBLE");
        this.barPanel.add((Component)this.progressBar, "VISIBLE");
        this.barPanel.add((Component)new JPanel(), "INVISIBLE");
        this.labelLayout.show(this.labelPanel, "VISIBLE");
        this.barLayout.show(this.barPanel, "VISIBLE");
        this.add((Component)this.labelPanel, "West");
        this.add((Component)this.barPanel, "Center");
        this.add((Component)new JLabel(" "), "East");
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(this.eventName)) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
            if (progress < 100 && !this.progressBar.isVisible()) {
                this.labelLayout.show(this.labelPanel, "VISIBLE");
                this.barLayout.show(this.barPanel, "VISIBLE");
            }
            if (progress >= 100) {
                this.labelLayout.show(this.labelPanel, "INVISIBLE");
                this.barLayout.show(this.barPanel, "INVISIBLE");
            }
        }
    }
}

