/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressBar
implements IProgressIndicator {
    Map<Long, JPanel> progressBars;
    Map<Long, IProgressIndicatorHandler> progressBarHandlers;
    private JPanel statusPanel;
    private JLabel statusBar;

    public ProgressBar(JPanel container, JLabel statusBar) {
        if (container == null) {
            throw new NullPointerException();
        }
        if (!GridLayout.class.isAssignableFrom(container.getLayout().getClass())) {
            throw new IllegalArgumentException("Container must have GridLayout");
        }
        this.statusPanel = container;
        this.statusBar = statusBar;
        this.progressBars = new Hashtable<Long, JPanel>();
        this.progressBarHandlers = new Hashtable<Long, IProgressIndicatorHandler>();
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBars != null && this.progressBars.size() > 0;
    }

    @Override
    public void setProgressBar(final String message, final long id) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel progressPanel = ProgressBar.this.progressBars.get(id);
                if (progressPanel != null) {
                    ProgressBar.this.progressBars.remove(id);
                    if (message != null && ProgressBar.this.statusBar != null) {
                        ProgressBar.this.statusBar.setText(message);
                    }
                    if (ProgressBar.this.progressBarHandlers.containsKey(id)) {
                        ProgressBar.this.progressBarHandlers.remove(id);
                    }
                    ProgressBar.this.removeRow(progressPanel);
                } else {
                    progressPanel = new JPanel(new BorderLayout(10, 5));
                    JProgressBar progressBar = new JProgressBar();
                    progressBar.setIndeterminate(true);
                    progressPanel.add((Component)new JLabel(message), "West");
                    progressPanel.add((Component)progressBar, "Center");
                    ProgressBar.this.addRow(progressPanel);
                    ProgressBar.this.progressBars.put(id, progressPanel);
                }
                ProgressBar.this.refreshLayout();
            }
        });
    }

    protected void refreshLayout() {
        Component root = SwingUtilities.getRoot(this.statusPanel);
        if (root != null) {
            root.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRow(JPanel progressPanel) {
        JPanel jPanel = this.statusPanel;
        synchronized (jPanel) {
            this.statusPanel.remove(progressPanel);
            GridLayout layout = (GridLayout)this.statusPanel.getLayout();
            layout.setRows(layout.getRows() - 1);
            this.statusPanel.remove(progressPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRow(JPanel progressPanel) {
        JPanel jPanel = this.statusPanel;
        synchronized (jPanel) {
            GridLayout layout = (GridLayout)this.statusPanel.getLayout();
            layout.setRows(layout.getRows() + 1);
            this.statusPanel.add(progressPanel);
        }
    }

    @Override
    public void registerHandler(final long id, final IProgressIndicatorHandler handler) {
        final ProgressBar us = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JPanel progressPanel = ProgressBar.this.progressBars.get(id);
                if (progressPanel == null) {
                    System.err.println("call setProgressBar before registering the progress bar's handler.");
                    return;
                }
                if (!handler.canCancel()) {
                    return;
                }
                ProgressBar.this.progressBarHandlers.put(id, handler);
                JButton cancel = new JButton(MessageManager.getString("action.cancel"));
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        handler.cancelActivity(id);
                        us.setProgressBar(MessageManager.formatMessage("label.cancelled_params", ((JLabel)progressPanel.getComponent(0)).getText()), id);
                    }
                });
                progressPanel.add((Component)cancel, "East");
                ProgressBar.this.refreshLayout();
            }
        });
    }
}

