/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.bin.Cache;
import jalview.gui.ProgressPanel;
import jalview.gui.SequenceRenderer;
import jalview.renderer.OverviewRenderer;
import jalview.renderer.OverviewResColourFinder;
import jalview.renderer.seqfeatures.FeatureRenderer;
import jalview.viewmodel.OverviewDimensions;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class OverviewCanvas
extends JPanel {
    private static final Color TRANS_GREY = new Color(100, 100, 100, 25);
    private volatile boolean restart = false;
    private volatile boolean updaterunning = false;
    private boolean dispose = false;
    private BufferedImage miniMe;
    private BufferedImage lastMiniMe = null;
    private SequenceRenderer sr;
    private FeatureRenderer fr;
    private OverviewDimensions od;
    private OverviewRenderer or = null;
    private AlignViewportI av;
    private OverviewResColourFinder cf;
    private ProgressPanel progressPanel;

    public OverviewCanvas(OverviewDimensions overviewDims, AlignViewportI alignvp, ProgressPanel pp) {
        this.od = overviewDims;
        this.av = alignvp;
        this.progressPanel = pp;
        this.sr = new SequenceRenderer(this.av);
        this.sr.renderGaps = false;
        this.fr = new FeatureRenderer(this.av);
        boolean useLegacy = Cache.getDefault("USE_LEGACY_GAP", false);
        Color gapCol = Cache.getDefaultColour("GAP_COLOUR", OverviewResColourFinder.OVERVIEW_DEFAULT_GAP);
        Color hiddenCol = Cache.getDefaultColour("HIDDEN_COLOUR", OverviewResColourFinder.OVERVIEW_DEFAULT_HIDDEN);
        this.cf = new OverviewResColourFinder(useLegacy, gapCol, hiddenCol);
        this.setSize(this.od.getWidth(), this.od.getHeight());
    }

    public void resetOviewDims(OverviewDimensions overviewDims) {
        this.od = overviewDims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartDraw() {
        OverviewCanvas overviewCanvas = this;
        synchronized (overviewCanvas) {
            if (this.updaterunning) {
                this.restart = true;
                if (this.or != null) {
                    this.or.setRedraw(true);
                }
            } else {
                this.updaterunning = true;
            }
            return this.restart;
        }
    }

    public void draw(boolean showSequenceFeatures, boolean showAnnotation, FeatureRendererModel transferRenderer) {
        this.miniMe = null;
        if (showSequenceFeatures) {
            this.fr.transferSettings(transferRenderer);
        }
        this.setPreferredSize(new Dimension(this.od.getWidth(), this.od.getHeight()));
        this.or = new OverviewRenderer(this.fr, this.od, this.av.getAlignment(), this.av.getResidueShading(), this.cf);
        this.or.addPropertyChangeListener(this.progressPanel);
        this.miniMe = this.or.draw(this.od.getRows(this.av.getAlignment()), this.od.getColumns(this.av.getAlignment()));
        Graphics mg = this.miniMe.getGraphics();
        if (showAnnotation) {
            mg.translate(0, this.od.getSequencesHeight());
            this.or.drawGraph(mg, this.av.getAlignmentConservationAnnotation(), this.od.getGraphHeight(), this.od.getColumns(this.av.getAlignment()));
            mg.translate(0, -this.od.getSequencesHeight());
        }
        this.or.removePropertyChangeListener(this.progressPanel);
        this.or = null;
        if (this.restart) {
            this.restart = false;
            if (!this.dispose) {
                this.draw(showSequenceFeatures, showAnnotation, transferRenderer);
            }
        } else {
            this.updaterunning = false;
            this.lastMiniMe = this.miniMe;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.restart) {
            if (this.lastMiniMe == null) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g.drawImage(this.lastMiniMe, 0, 0, this.getWidth(), this.getHeight(), this);
            }
            g.setColor(TRANS_GREY);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.lastMiniMe != null) {
            if (this.getWidth() > 0 && this.getHeight() > 0 && (this.getWidth() != this.od.getWidth() || this.getHeight() != this.od.getHeight())) {
                if (this.od.getGraphHeight() > 0 && this.od.getSequencesHeight() > 0) {
                    BufferedImage topImage = this.lastMiniMe.getSubimage(0, 0, this.od.getWidth(), this.od.getSequencesHeight());
                    BufferedImage bottomImage = this.lastMiniMe.getSubimage(0, this.od.getSequencesHeight(), this.od.getWidth(), this.od.getGraphHeight());
                    this.od.setWidth(this.getWidth());
                    this.od.setHeight(this.getHeight());
                    this.lastMiniMe = new BufferedImage(this.od.getWidth(), this.od.getHeight(), 1);
                    Graphics lg = this.lastMiniMe.getGraphics();
                    lg.drawImage(topImage, 0, 0, this.od.getWidth(), this.od.getSequencesHeight(), null);
                    lg.drawImage(bottomImage, 0, this.od.getSequencesHeight(), this.od.getWidth(), this.od.getGraphHeight(), this);
                    lg.dispose();
                } else {
                    this.od.setWidth(this.getWidth());
                    this.od.setHeight(this.getHeight());
                }
                this.od.setBoxPosition(this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
            }
            g.drawImage(this.lastMiniMe, 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g.drawImage(this.lastMiniMe, 0, 0, this.getWidth(), this.getHeight(), this);
        }
        g.setColor(Color.red);
        this.od.drawBox(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.dispose = true;
        this.od = null;
        OverviewCanvas overviewCanvas = this;
        synchronized (overviewCanvas) {
            this.restart = true;
            if (this.or != null) {
                this.or.setRedraw(true);
            }
        }
    }
}

