/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.gui.OptsParametersContainerI;
import jalview.gui.Slider;
import jalview.util.MessageManager;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.OptionI;
import jalview.ws.params.ParameterI;
import jalview.ws.params.ValueConstrainI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class OptsAndParamsPage {
    boolean compact = false;
    public static final int PARAM_WIDTH = 340;
    public static final int PARAM_HEIGHT = 150;
    public static final int PARAM_CLOSEDHEIGHT = 80;
    URL linkImageURL = this.getClass().getResource("/images/link.gif");
    Map<String, OptionBox> optSet = new LinkedHashMap<String, OptionBox>();
    Map<String, ParamBox> paramSet = new LinkedHashMap<String, ParamBox>();
    OptsParametersContainerI poparent;

    public OptsAndParamsPage(OptsParametersContainerI paramContainer) {
        this(paramContainer, false);
    }

    public OptsAndParamsPage(OptsParametersContainerI paramContainer, boolean compact) {
        this.poparent = paramContainer;
        this.compact = compact;
    }

    public static void showUrlPopUp(JComponent invoker, final String finfo, int x, int y) {
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem mitem = new JMenuItem(MessageManager.formatMessage("label.view_params", new String[]{finfo}));
        mitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.showUrl(finfo);
            }
        });
        mnu.add(mitem);
        mnu.show(invoker, x, y);
    }

    public Map<String, OptionBox> getOptSet() {
        return this.optSet;
    }

    public void setOptSet(Map<String, OptionBox> optSet) {
        this.optSet = optSet;
    }

    public Map<String, ParamBox> getParamSet() {
        return this.paramSet;
    }

    public void setParamSet(Map<String, ParamBox> paramSet) {
        this.paramSet = paramSet;
    }

    OptionBox addOption(OptionI opt) {
        OptionBox cb = this.optSet.get(opt.getName());
        if (cb == null) {
            cb = new OptionBox(opt);
            this.optSet.put(opt.getName(), cb);
        }
        return cb;
    }

    ParamBox addParameter(ParameterI arg) {
        ParamBox pb = this.paramSet.get(arg.getName());
        if (pb == null) {
            pb = new ParamBox(this.poparent, arg);
            this.paramSet.put(arg.getName(), pb);
        }
        pb.init();
        pb.updateControls(arg);
        return pb;
    }

    void selectOption(OptionI option, String string) {
        OptionBox cb = this.optSet.get(option.getName());
        if (cb == null) {
            cb = this.addOption(option);
        }
        cb.enabled.setSelected(string != null);
        if (string != null) {
            if (option.getPossibleValues().contains(string)) {
                cb.val.setSelectedItem(string);
            } else {
                throw new Error(MessageManager.formatMessage("error.invalid_value_for_option", new String[]{string, option.getName()}));
            }
        }
        if (!option.isRequired() || !cb.enabled.isSelected()) {
            // empty if block
        }
        cb.setInitialValue();
    }

    void setParameter(ParameterI arg) {
        ParamBox pb = this.paramSet.get(arg.getName());
        if (pb == null) {
            this.addParameter(arg);
        } else {
            pb.updateControls(arg);
        }
    }

    public List<ArgumentI> getCurrentSettings() {
        ArrayList<ArgumentI> argSet = new ArrayList<ArgumentI>();
        for (OptionBox opts : this.getOptSet().values()) {
            OptionI opt = opts.getOptionIfEnabled();
            if (opt == null) continue;
            argSet.add(opt);
        }
        for (ParamBox parambox : this.getParamSet().values()) {
            ParameterI parm = parambox.getParameter();
            if (parm == null) continue;
            argSet.add(parm);
        }
        return argSet;
    }

    public class ParamBox
    extends JPanel
    implements ChangeListener,
    ActionListener,
    MouseListener {
        boolean adjusting = false;
        boolean choice = false;
        JComboBox<String> choicebox;
        JPanel controlPanel = new JPanel();
        boolean descisvisible = false;
        JScrollPane descPanel = new JScrollPane();
        final URL finfo;
        boolean integ = false;
        String lastVal;
        ParameterI parameter;
        final OptsParametersContainerI pmdialogbox;
        JPanel settingPanel = new JPanel();
        JButton showDesc = new JButton();
        Slider slider = null;
        JTextArea string = new JTextArea();
        ValueConstrainI validator = null;
        JTextField valueField = null;

        public ParamBox(OptsParametersContainerI pmlayout, ParameterI parm) {
            this.pmdialogbox = pmlayout;
            this.finfo = parm.getFurtherDetails();
            this.validator = parm.getValidValue();
            this.parameter = parm;
            if (this.validator != null) {
                this.integ = this.validator.getType() == ValueConstrainI.ValueType.Integer;
            } else if (this.parameter.getPossibleValues() != null) {
                this.choice = true;
            }
            if (!OptsAndParamsPage.this.compact) {
                this.makeExpanderParam(parm);
            } else {
                this.makeCompactParam(parm);
            }
        }

        private void makeCompactParam(ParameterI parm) {
            this.setLayout((LayoutManager)new MigLayout("", "[][grow]"));
            String ttipText = null;
            this.controlPanel.setLayout(new BorderLayout());
            if (parm.getDescription() != null && parm.getDescription().trim().length() > 0) {
                ttipText = JvSwingUtils.wrapTooltip(true, parm.getDescription() + (String)(this.finfo != null ? "<br><img src=\"" + OptsAndParamsPage.this.linkImageURL + "\"/>" + MessageManager.getString("label.opt_and_params_further_details") : ""));
            }
            JvSwingUtils.mgAddtoLayout(this, ttipText, new JLabel(parm.getName()), this.controlPanel, "");
            this.updateControls(parm);
            this.validate();
        }

        private void makeExpanderParam(ParameterI parm) {
            this.setPreferredSize(new Dimension(340, 80));
            this.setBorder(new TitledBorder(parm.getName()));
            this.setLayout(null);
            this.showDesc.setFont(new Font("Verdana", 0, 6));
            this.showDesc.setText("+");
            this.string.setFont(new Font("Verdana", 0, 11));
            this.string.setBackground(this.getBackground());
            this.string.setEditable(false);
            this.descPanel.getViewport().setView(this.string);
            this.descPanel.setVisible(false);
            JPanel firstrow = new JPanel();
            firstrow.setLayout(null);
            this.controlPanel.setLayout(new BorderLayout());
            this.controlPanel.setBounds(new Rectangle(39, 10, 270, 30));
            firstrow.add(this.controlPanel);
            firstrow.setBounds(new Rectangle(10, 20, 310, 50));
            final ParamBox me = this;
            if (parm.getDescription() != null && parm.getDescription().trim().length() > 0) {
                if (this.finfo != null) {
                    this.showDesc.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("label.opt_and_params_show_brief_desc_image_link", new String[]{OptsAndParamsPage.this.linkImageURL.toExternalForm()})));
                    this.showDesc.addMouseListener(this);
                } else {
                    this.showDesc.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.opt_and_params_show_brief_desc")));
                }
                this.showDesc.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ParamBox.this.descisvisible = !ParamBox.this.descisvisible;
                        ParamBox.this.descPanel.setVisible(ParamBox.this.descisvisible);
                        ParamBox.this.descPanel.getVerticalScrollBar().setValue(0);
                        me.setPreferredSize(new Dimension(340, ParamBox.this.descisvisible ? 150 : 80));
                        me.validate();
                        ParamBox.this.pmdialogbox.refreshParamLayout();
                    }
                });
                this.string.setWrapStyleWord(true);
                this.string.setLineWrap(true);
                this.string.setColumns(32);
                this.string.setText(parm.getDescription());
                this.showDesc.setBounds(new Rectangle(10, 10, 16, 16));
                firstrow.add(this.showDesc);
            }
            this.add(firstrow);
            this.validator = parm.getValidValue();
            this.parameter = parm;
            if (this.validator != null) {
                this.integ = this.validator.getType() == ValueConstrainI.ValueType.Integer;
            } else if (this.parameter.getPossibleValues() != null) {
                this.choice = true;
            }
            this.updateControls(parm);
            this.descPanel.setBounds(new Rectangle(10, 80, 320, 65));
            this.add(this.descPanel);
            this.validate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.adjusting) {
                return;
            }
            if (!this.choice) {
                this.updateSliderFromValueField();
            }
            this.checkIfModified();
        }

        private void checkIfModified() {
            String cstate = this.getCurrentValue();
            boolean modified = !cstate.equals(this.lastVal);
            this.pmdialogbox.argSetModified(this, modified);
        }

        private String getCurrentValue() {
            return this.choice ? (String)this.choicebox.getSelectedItem() : this.valueField.getText();
        }

        @Override
        public int getBaseline(int width, int height) {
            return 0;
        }

        @Override
        public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
        }

        public int getBoxHeight() {
            return this.descisvisible ? 150 : 80;
        }

        public ParameterI getParameter() {
            ParameterI prm = this.parameter.copy();
            if (this.choice) {
                prm.setValue((String)this.choicebox.getSelectedItem());
            } else {
                prm.setValue(this.valueField.getText());
            }
            return prm;
        }

        public void init() {
            this.lastVal = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.adjusting) {
                float value = this.slider.getSliderValue();
                this.valueField.setText(this.integ ? Integer.toString((int)value) : Float.toString(value));
                this.checkIfModified();
            }
        }

        public void updateControls(ParameterI parm) {
            boolean init;
            this.adjusting = true;
            boolean bl = init = this.choicebox == null && this.valueField == null;
            if (init) {
                if (this.choice) {
                    this.choicebox = new JComboBox();
                    this.choicebox.addActionListener(this);
                    this.controlPanel.add(this.choicebox, "Center");
                } else {
                    this.valueField = new JTextField();
                    this.valueField.addActionListener(this);
                    this.valueField.addKeyListener(new KeyListener(){

                        @Override
                        public void keyTyped(KeyEvent e) {
                        }

                        @Override
                        public void keyReleased(KeyEvent e) {
                            if (e.isActionKey() && ParamBox.this.valueField.getText().trim().length() > 0) {
                                ParamBox.this.actionPerformed(null);
                            }
                        }

                        @Override
                        public void keyPressed(KeyEvent e) {
                        }
                    });
                    this.valueField.setPreferredSize(new Dimension(60, 25));
                    this.slider = this.makeSlider(parm.getValidValue());
                    this.slider.addChangeListener(this);
                    this.controlPanel.add((Component)this.slider, "West");
                    this.controlPanel.add((Component)this.valueField, "East");
                }
            }
            if (parm != null) {
                if (this.choice) {
                    if (init) {
                        List<String> vals = parm.getPossibleValues();
                        for (String val : vals) {
                            this.choicebox.addItem(val);
                        }
                    }
                    if (parm.getValue() != null) {
                        this.choicebox.setSelectedItem(parm.getValue());
                    }
                } else {
                    this.valueField.setText(parm.getValue());
                }
            }
            this.lastVal = this.getCurrentValue();
            this.adjusting = false;
        }

        private Slider makeSlider(ValueConstrainI validValue) {
            if (validValue != null) {
                Number minValue = validValue.getMin();
                Number maxValue = validValue.getMax();
                if (minValue != null && maxValue != null) {
                    return new Slider(minValue.floatValue(), maxValue.floatValue(), minValue.floatValue());
                }
            }
            return new Slider(0.0f, 100.0f, 50.0f);
        }

        public void updateSliderFromValueField() {
            if (this.validator != null) {
                Number minValue = this.validator.getMin();
                Number maxValue = this.validator.getMax();
                if (this.integ) {
                    int iVal = 0;
                    try {
                        this.valueField.setText(this.valueField.getText().trim());
                        iVal = Integer.valueOf(this.valueField.getText());
                        if (minValue != null && minValue.intValue() > iVal) {
                            iVal = minValue.intValue();
                        }
                        if (maxValue != null && maxValue.intValue() < iVal) {
                            iVal = maxValue.intValue();
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println(e.toString());
                    }
                    if (minValue != null || maxValue != null) {
                        this.valueField.setText(String.valueOf(iVal));
                        this.slider.setSliderValue(iVal);
                    } else {
                        this.slider.setVisible(false);
                    }
                } else {
                    float fVal = 0.0f;
                    try {
                        this.valueField.setText(this.valueField.getText().trim());
                        fVal = Float.valueOf(this.valueField.getText()).floatValue();
                        if (minValue != null && minValue.floatValue() > fVal) {
                            fVal = minValue.floatValue();
                            this.valueField.setText("" + fVal);
                        }
                        if (maxValue != null && maxValue.floatValue() < fVal) {
                            fVal = maxValue.floatValue();
                            this.valueField.setText("" + fVal);
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println(e.toString());
                    }
                    if (minValue != null && maxValue != null) {
                        this.slider.setSliderModel(minValue.floatValue(), maxValue.floatValue(), fVal);
                    } else {
                        this.slider.setVisible(false);
                    }
                }
            } else if (!this.choice) {
                this.slider.setVisible(false);
            }
        }
    }

    public class OptionBox
    extends JPanel
    implements MouseListener,
    ActionListener {
        JCheckBox enabled = new JCheckBox();
        final URL finfo;
        boolean hasLink = false;
        boolean initEnabled = false;
        String initVal = null;
        OptionI option;
        JLabel optlabel = new JLabel();
        JComboBox val = new JComboBox();

        public OptionBox(OptionI opt) {
            this.option = opt;
            this.setLayout(new BorderLayout());
            this.enabled.setSelected(opt.isRequired());
            this.enabled.setFont(new Font("Verdana", 0, 11));
            this.enabled.setText("");
            this.enabled.setText(opt.getName());
            this.enabled.addActionListener(this);
            this.finfo = this.option.getFurtherDetails();
            String desc = opt.getDescription();
            if (this.finfo != null) {
                this.hasLink = true;
                this.enabled.setToolTipText(JvSwingUtils.wrapTooltip(true, (desc == null || desc.trim().length() == 0 ? MessageManager.getString("label.opt_and_params_further_details") : desc) + "<br><img src=\"" + OptsAndParamsPage.this.linkImageURL + "\"/>"));
                this.enabled.addMouseListener(this);
            } else if (desc != null && desc.trim().length() > 0) {
                this.enabled.setToolTipText(JvSwingUtils.wrapTooltip(true, opt.getDescription()));
            }
            this.add((Component)this.enabled, "North");
            for (String str : opt.getPossibleValues()) {
                this.val.addItem(str);
            }
            this.val.setSelectedItem(opt.getValue());
            if (opt.getPossibleValues().size() > 1) {
                this.setLayout(new GridLayout(1, 2));
                this.val.addActionListener(this);
                this.add((Component)this.val, "South");
            }
            this.setInitialValue();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != this.enabled) {
                this.enabled.setSelected(true);
            }
            this.checkIfModified();
        }

        private void checkIfModified() {
            boolean notmod;
            boolean bl = notmod = this.initEnabled == this.enabled.isSelected();
            notmod = this.enabled.isSelected() ? (this.initVal != null ? (notmod &= this.initVal.equals(this.val.getSelectedItem())) : (notmod &= this.option.getValue() == null || this.option.getValue().equals(this.val.getSelectedItem()))) : (notmod &= this.initVal != null ? this.initVal.equals(this.val.getSelectedItem()) : this.val.getSelectedItem() != this.initVal);
            OptsAndParamsPage.this.poparent.argSetModified(this, !notmod);
        }

        public OptionI getOptionIfEnabled() {
            if (!this.enabled.isSelected()) {
                return null;
            }
            OptionI opt = this.option.copy();
            if (opt.getPossibleValues() != null && opt.getPossibleValues().size() == 1) {
                opt.setValue(opt.getPossibleValues().get(0));
            }
            if (this.val.getSelectedItem() != null) {
                opt.setValue((String)this.val.getSelectedItem());
            } else if (this.option.getValue() != null) {
                opt.setValue(this.option.getValue());
            }
            return opt;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public void resetToDefault(boolean setDefaultParams) {
            this.enabled.setSelected(false);
            if (this.option.isRequired() || setDefaultParams && this.option.getValue() != null) {
                OptsAndParamsPage.this.selectOption(this.option, this.option.getValue());
            }
        }

        public void setInitialValue() {
            this.initEnabled = this.enabled.isSelected();
            this.initVal = this.option.getPossibleValues() != null && this.option.getPossibleValues().size() > 1 ? (String)this.val.getSelectedItem() : (this.initEnabled ? (String)this.val.getSelectedItem() : null);
        }
    }
}

