/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.util.Platform;
import jalview.util.dialogrunner.DialogRunnerI;
import java.awt.Component;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JvOptionPane
extends JOptionPane
implements DialogRunnerI,
PropertyChangeListener {
    private static final long serialVersionUID = -3019167117756785229L;
    private static Object mockResponse = 2;
    private static boolean interactiveMode = true;
    private Component parentComponent;
    private Map<Object, Runnable> callbacks = new HashMap<Object, Runnable>();
    List<Object> ourOptions;

    public JvOptionPane(Component parent) {
        this.parentComponent = Platform.isJS() ? this : parent;
    }

    public static int showConfirmDialog(Component parentComponent, Object message) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showConfirmDialog(parentComponent, message) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, icon) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalConfirmDialog(parentComponent, message) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showInternalConfirmDialog(Component parentComponent, String message, String title, int optionType) {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, icon);
    }

    public static int showOptionDialog(Component parentComponent, String message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        return JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue);
    }

    public static void showMessageDialog(Component parentComponent, String message) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message);
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, JvOptionPane.getPrefix(messageType) + message, title, messageType);
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType, Icon icon) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, messageType, icon);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message) {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message);
    }

    public static void showInternalMessageDialog(Component parentComponent, String message, String title, int messageType) {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, JvOptionPane.getPrefix(messageType) + message, title, messageType);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, messageType, icon);
    }

    public static String showInputDialog(Object message) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            return JvOptionPane.getMockResponse().toString();
        }
        return JOptionPane.showInputDialog(message);
    }

    public static String showInputDialog(String message, String initialSelectionValue) {
        if (!JvOptionPane.isInteractiveMode()) {
            return JvOptionPane.getMockResponse().toString();
        }
        return JOptionPane.showInputDialog(message, (Object)initialSelectionValue);
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        if (!JvOptionPane.isInteractiveMode()) {
            return JvOptionPane.getMockResponse().toString();
        }
        return JOptionPane.showInputDialog(message, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, String message) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, (Object)message) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInputDialog(Component parentComponent, String message, String initialSelectionValue) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInputDialog(Component parentComponent, String message, String title, int messageType) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, title, messageType) : JvOptionPane.getMockResponse().toString();
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInternalInputDialog(Component parentComponent, String message) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalInputDialog(parentComponent, message) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInternalInputDialog(Component parentComponent, String message, String title, int messageType) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalInputDialog(parentComponent, JvOptionPane.getPrefix(messageType) + message, title, messageType) : JvOptionPane.getMockResponse().toString();
    }

    public static Object showInternalInputDialog(Component parentComponent, String message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    private static void outputMessage(Object message) {
        System.out.println(">>> JOption Message : " + message.toString());
    }

    public static Object getMockResponse() {
        return mockResponse;
    }

    public static void setMockResponse(Object mockOption) {
        mockResponse = mockOption;
    }

    public static void resetMock() {
        JvOptionPane.setMockResponse(2);
        JvOptionPane.setInteractiveMode(true);
    }

    public static boolean isInteractiveMode() {
        return interactiveMode;
    }

    public static void setInteractiveMode(boolean interactive) {
        interactiveMode = interactive;
    }

    private static String getPrefix(int messageType) {
        String prefix = "";
        if (Platform.isJS()) {
            switch (messageType) {
                case 2: {
                    prefix = "WARNING! ";
                    break;
                }
                case 0: {
                    prefix = "ERROR! ";
                    break;
                }
                default: {
                    prefix = "Note: ";
                }
            }
        }
        return prefix;
    }

    public static JvOptionPane newOptionDialog(Component parentComponent) {
        return new JvOptionPane(parentComponent);
    }

    public void showDialog(String message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        if (!JvOptionPane.isInteractiveMode()) {
            this.handleResponse(JvOptionPane.getMockResponse());
        }
        this.ourOptions = Arrays.asList(options);
        int response = JOptionPane.showOptionDialog(this.parentComponent, message, title, optionType, messageType, icon, options, initialValue);
        if (!Platform.isJS()) {
            this.handleResponse(response);
        }
    }

    public void showInternalDialog(JPanel mainPanel, String title, int yesNoCancelOption, int questionMessage, Icon icon, Object[] options, String initresponse) {
        if (!JvOptionPane.isInteractiveMode()) {
            this.handleResponse(JvOptionPane.getMockResponse());
        }
        this.ourOptions = Arrays.asList(options);
        int response = this.parentComponent != this ? JOptionPane.showInternalOptionDialog(this.parentComponent, mainPanel, title, yesNoCancelOption, questionMessage, icon, options, initresponse) : JOptionPane.showOptionDialog(this.parentComponent, mainPanel, title, yesNoCancelOption, questionMessage, icon, options, initresponse);
        if (!Platform.isJS()) {
            this.handleResponse(response);
        }
    }

    @Override
    public JvOptionPane setResponseHandler(Object response, Runnable action) {
        this.callbacks.put(response, action);
        return this;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        int ourOption = this.ourOptions.indexOf(newValue);
        if (ourOption >= 0) {
            this.handleResponse(ourOption);
        } else {
            this.handleResponse(newValue);
        }
    }

    @Override
    public void handleResponse(Object response) {
        if (response != null && !response.equals(response)) {
            return;
        }
        Runnable action = this.callbacks.get(response);
        if (action != null) {
            action.run();
        }
    }
}

