/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.gui.IProgressIndicator;
import jalview.gui.LineartOptions;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImageExporter {
    private IProgressIndicator messageBoard;
    private ImageWriterI imageWriter;
    ImageMaker.TYPE imageType;
    private String title;

    public ImageExporter(ImageWriterI writer, IProgressIndicator statusBar, ImageMaker.TYPE type, String fileTitle) {
        this.imageWriter = writer;
        this.messageBoard = statusBar;
        this.imageType = type;
        this.title = fileTitle;
    }

    public void doExport(File file, Component parent, final int width, final int height, String imageSource) {
        final long messageId = System.currentTimeMillis();
        this.setStatus(MessageManager.formatMessage("status.exporting_alignment_as_x_file", new Object[]{this.imageType}), messageId);
        if (file == null && !Jalview.isHeadlessMode()) {
            JalviewFileChooser chooser = this.imageType.getFileChooser();
            chooser.setFileView(new JalviewFileView());
            MessageManager.formatMessage("label.create_image_of", this.imageType.getName(), imageSource);
            String title = "Create " + this.imageType.getName() + " image from alignment";
            chooser.setDialogTitle(title);
            chooser.setToolTipText(MessageManager.getString("action.save"));
            int value = chooser.showSaveDialog(parent);
            if (value != 0) {
                String msg = MessageManager.formatMessage("status.cancelled_image_export_operation", this.imageType.name);
                this.setStatus(msg, messageId);
                return;
            }
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            file = chooser.getSelectedFile();
        }
        String renderStyle = Cache.getDefault(this.imageType.getName() + "_RENDERING", "Prompt each time");
        if (Platform.isJS()) {
            renderStyle = "Text";
        }
        final AtomicBoolean textSelected = new AtomicBoolean(!"Lineart".equals(renderStyle));
        if ((this.imageType == ImageMaker.TYPE.EPS || this.imageType == ImageMaker.TYPE.SVG) && "Prompt each time".equals(renderStyle) && !Jalview.isHeadlessMode()) {
            final File chosenFile = file;
            Runnable okAction = new Runnable(){

                @Override
                public void run() {
                    ImageExporter.this.exportImage(chosenFile, !textSelected.get(), width, height, messageId);
                }
            };
            LineartOptions epsOption = new LineartOptions(ImageMaker.TYPE.EPS.getName(), textSelected);
            epsOption.setResponseAction(1, new Runnable(){

                @Override
                public void run() {
                    ImageExporter.this.setStatus(MessageManager.formatMessage("status.cancelled_image_export_operation", ImageExporter.this.imageType.getName()), messageId);
                }
            });
            epsOption.setResponseAction(0, okAction);
            epsOption.showDialog();
        } else {
            this.exportImage(file, !textSelected.get(), width, height, messageId);
        }
    }

    protected void exportImage(File chosenFile, boolean asLineart, int width, int height, long messageId) {
        String type = this.imageType.getName();
        try {
            ImageMaker im = new ImageMaker(this.imageType, width, height, chosenFile, this.title, asLineart);
            this.imageWriter.exportImage(im.getGraphics());
            im.writeImage();
            this.setStatus(MessageManager.formatMessage("status.export_complete", type), messageId);
        }
        catch (Exception e) {
            System.out.println(String.format("Error creating %s file: %s", type, e.toString()));
            this.setStatus(MessageManager.formatMessage("info.error_creating_file", type), messageId);
        }
    }

    void setStatus(String msg, long id) {
        if (this.messageBoard != null && !Jalview.isHeadlessMode()) {
            this.messageBoard.setProgressBar(msg, id);
        }
    }

    public static interface ImageWriterI {
        public void exportImage(Graphics var1) throws Exception;
    }
}

