/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.SplitFrame;
import jalview.gui.TreePanel;
import jalview.jbgui.GFontChooser;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

public class FontChooser
extends GFontChooser {
    AlignmentPanel ap;
    TreePanel tp;
    Font oldFont;
    Font oldComplementFont;
    boolean oldProteinScale;
    boolean oldMirrorFont;
    boolean init = true;
    JInternalFrame frame;
    private Font lastSelected = null;
    private boolean lastSelMono = false;
    private boolean oldSmoothFont;
    private boolean oldComplementSmooth;

    public FontChooser(TreePanel treePanel) {
        this.tp = treePanel;
        this.ap = treePanel.getTreeCanvas().getAssociatedPanel();
        this.oldFont = treePanel.getTreeFont();
        this.defaultButton.setVisible(false);
        this.smoothFont.setEnabled(false);
        this.init();
    }

    public FontChooser(AlignmentPanel alignPanel) {
        this.oldFont = alignPanel.av.getFont();
        this.oldProteinScale = alignPanel.av.isScaleProteinAsCdna();
        this.oldMirrorFont = alignPanel.av.isProteinFontAsCdna();
        this.oldSmoothFont = alignPanel.av.antiAlias;
        this.ap = alignPanel;
        this.init();
    }

    void init() {
        int i;
        boolean inSplitFrame;
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.smoothFont.setSelected(this.ap.av.antiAlias);
        boolean bl = inSplitFrame = this.ap.av.getCodingComplement() != null;
        if (inSplitFrame) {
            this.oldComplementFont = ((AlignViewport)this.ap.av.getCodingComplement()).getFont();
            this.oldComplementSmooth = ((AlignViewport)this.ap.av.getCodingComplement()).antiAlias;
            this.scaleAsCdna.setVisible(true);
            this.scaleAsCdna.setSelected(this.ap.av.isScaleProteinAsCdna());
            this.fontAsCdna.setVisible(true);
            this.fontAsCdna.setSelected(this.ap.av.isProteinFontAsCdna());
        }
        if (this.isTreeFont()) {
            Desktop.addInternalFrame(this.frame, MessageManager.getString("action.change_font_tree_panel"), 400, 200, false);
        } else {
            Desktop.addInternalFrame(this.frame, MessageManager.getString("action.change_font"), 380, 220, false);
        }
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i = 0; i < fonts.length; ++i) {
            this.fontName.addItem(fonts[i]);
        }
        for (i = 1; i < 51; ++i) {
            this.fontSize.addItem(i);
        }
        this.fontStyle.addItem("plain");
        this.fontStyle.addItem("bold");
        this.fontStyle.addItem("italic");
        this.fontName.setSelectedItem(this.oldFont.getName());
        this.fontSize.setSelectedItem(this.oldFont.getSize());
        this.fontStyle.setSelectedIndex(this.oldFont.getStyle());
        FontMetrics fm = this.getGraphics().getFontMetrics(this.oldFont);
        this.monospaced.setSelected(fm.getStringBounds("M", this.getGraphics()).getWidth() == fm.getStringBounds("|", this.getGraphics()).getWidth());
        this.init = false;
    }

    @Override
    protected void smoothFont_actionPerformed() {
        this.ap.av.antiAlias = this.smoothFont.isSelected();
        this.ap.getAnnotationPanel().image = null;
        this.ap.paintAlignment(true, false);
        if (this.ap.av.getCodingComplement() != null && this.ap.av.isProteinFontAsCdna()) {
            ((AlignViewport)this.ap.av.getCodingComplement()).antiAlias = this.ap.av.antiAlias;
            SplitFrame sv = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
            sv.adjustLayout();
            sv.repaint();
        }
    }

    @Override
    protected void ok_actionPerformed() {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.ap != null && this.ap.getOverviewPanel() != null) {
            this.ap.getOverviewPanel().updateOverviewImage();
        }
    }

    @Override
    protected void cancel_actionPerformed() {
        if (this.isTreeFont()) {
            this.tp.setTreeFont(this.oldFont);
        } else if (this.ap != null) {
            this.ap.av.setFont(this.oldFont, true);
            this.ap.av.setScaleProteinAsCdna(this.oldProteinScale);
            this.ap.av.setProteinFontAsCdna(this.oldMirrorFont);
            this.ap.av.antiAlias = this.oldSmoothFont;
            this.ap.fontChanged();
            if (this.scaleAsCdna.isVisible() && this.scaleAsCdna.isEnabled()) {
                this.ap.av.getCodingComplement().setScaleProteinAsCdna(this.oldProteinScale);
                this.ap.av.getCodingComplement().setProteinFontAsCdna(this.oldMirrorFont);
                ((AlignViewport)this.ap.av.getCodingComplement()).antiAlias = this.oldComplementSmooth;
                this.ap.av.getCodingComplement().setFont(this.oldComplementFont, true);
                SplitFrame splitFrame = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
                splitFrame.adjustLayout();
                splitFrame.repaint();
            }
        }
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isTreeFont() {
        return this.tp != null;
    }

    void changeFont() {
        if (this.lastSelected == null) {
            double iw;
            this.lastSelected = this.oldFont;
            FontMetrics fm = this.getGraphics().getFontMetrics(this.oldFont);
            double mw = fm.getStringBounds("M", this.getGraphics()).getWidth();
            this.lastSelMono = mw == (iw = fm.getStringBounds("I", this.getGraphics()).getWidth());
        }
        Font newFont = new Font(this.fontName.getSelectedItem().toString(), this.fontStyle.getSelectedIndex(), (Integer)this.fontSize.getSelectedItem());
        FontMetrics fm = this.getGraphics().getFontMetrics(newFont);
        double mw = fm.getStringBounds("M", this.getGraphics()).getWidth();
        Rectangle2D iBounds = fm.getStringBounds("I", this.getGraphics());
        double iw = iBounds.getWidth();
        if (mw < 1.0 || iw < 1.0) {
            String message = iBounds.getHeight() < 1.0 ? MessageManager.getString("label.font_doesnt_have_letters_defined") : MessageManager.getString("label.font_too_small");
            JvOptionPane.showInternalMessageDialog((Component)this, message, MessageManager.getString("label.invalid_font"), 2);
            if (this.lastSelected.getSize() != ((Integer)this.fontSize.getSelectedItem()).intValue()) {
                this.fontSize.setSelectedItem(this.lastSelected.getSize());
            }
            if (!this.lastSelected.getName().equals(this.fontName.getSelectedItem().toString())) {
                this.fontName.setSelectedItem(this.lastSelected.getName());
            }
            if (this.lastSelected.getStyle() != this.fontStyle.getSelectedIndex()) {
                this.fontStyle.setSelectedIndex(this.lastSelected.getStyle());
            }
            if (this.lastSelMono != this.monospaced.isSelected()) {
                this.monospaced.setSelected(this.lastSelMono);
            }
            return;
        }
        if (this.isTreeFont()) {
            this.tp.setTreeFont(newFont);
        } else if (this.ap != null) {
            this.ap.av.setFont(newFont, true);
            this.ap.fontChanged();
            if (this.fontAsCdna.isVisible()) {
                if (this.fontAsCdna.isSelected()) {
                    this.ap.av.getCodingComplement().setFont(newFont, true);
                }
                SplitFrame splitFrame = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
                splitFrame.adjustLayout();
                splitFrame.repaint();
            }
        }
        this.monospaced.setSelected(mw == iw);
        this.lastSelected = newFont;
    }

    @Override
    protected void fontName_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    @Override
    protected void fontSize_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    @Override
    protected void fontStyle_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    @Override
    public void defaultButton_actionPerformed() {
        Cache.setProperty("FONT_NAME", this.fontName.getSelectedItem().toString());
        Cache.setProperty("FONT_STYLE", "" + this.fontStyle.getSelectedIndex());
        Cache.setProperty("FONT_SIZE", this.fontSize.getSelectedItem().toString());
        Cache.setProperty("ANTI_ALIAS", Boolean.toString(this.smoothFont.isSelected()));
        Cache.setProperty("SCALE_PROTEIN_TO_CDNA", Boolean.toString(this.scaleAsCdna.isSelected()));
    }

    @Override
    protected void scaleAsCdna_actionPerformed() {
        this.ap.av.setScaleProteinAsCdna(this.scaleAsCdna.isSelected());
        this.ap.av.getCodingComplement().setScaleProteinAsCdna(this.scaleAsCdna.isSelected());
        SplitFrame splitFrame = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
        splitFrame.adjustLayout();
        splitFrame.repaint();
    }

    @Override
    protected void mirrorFonts_actionPerformed() {
        boolean selected = this.fontAsCdna.isSelected();
        this.ap.av.setProteinFontAsCdna(selected);
        this.ap.av.getCodingComplement().setProteinFontAsCdna(selected);
        if (!selected) {
            this.ap.av.getCodingComplement().setFont(this.oldComplementFont, true);
        }
        this.changeFont();
    }
}

