/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureColourI;
import jalview.bin.Cache;
import jalview.datamodel.GraphLine;
import jalview.datamodel.features.FeatureAttributes;
import jalview.datamodel.features.FeatureMatcher;
import jalview.datamodel.features.FeatureMatcherI;
import jalview.datamodel.features.FeatureMatcherSet;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JalviewDialog;
import jalview.gui.JvSwingUtils;
import jalview.gui.Slider;
import jalview.schemes.FeatureColour;
import jalview.util.ColorUtils;
import jalview.util.MessageManager;
import jalview.util.matcher.Condition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FeatureTypeSettings
extends JalviewDialog {
    private static final MathContext FOUR_SIG_FIG = new MathContext(4);
    private static final String LABEL_18N = MessageManager.getString("label.label");
    private static final String SCORE_18N = MessageManager.getString("label.score");
    private static final int RADIO_WIDTH = 130;
    private static final String COLON = ":";
    private static final int MAX_TOOLTIP_LENGTH = 50;
    private static final int NO_COLOUR_OPTION = 0;
    private static final int MIN_COLOUR_OPTION = 1;
    private static final int MAX_COLOUR_OPTION = 2;
    private static final int ABOVE_THRESHOLD_OPTION = 1;
    private static final int BELOW_THRESHOLD_OPTION = 2;
    private static final DecimalFormat DECFMT_2_2 = new DecimalFormat("##.##");
    private final FeatureRenderer fr;
    final AlignmentViewPanel ap;
    final String featureType;
    private final FeatureColourI originalColour;
    private final FeatureMatcherSetI originalFilter;
    boolean adjusting = false;
    private float min;
    private float max;
    JRadioButton simpleColour = new JRadioButton();
    JRadioButton byCategory = new JRadioButton();
    JRadioButton graduatedColour = new JRadioButton();
    JPanel coloursPanel;
    JPanel filtersPanel;
    JPanel singleColour = new JPanel();
    JPanel minColour = new JPanel();
    JPanel maxColour = new JPanel();
    private JComboBox<Object> threshold = new JComboBox();
    private Slider slider;
    JTextField thresholdValue = new JTextField(20);
    private JCheckBox thresholdIsMin = new JCheckBox();
    private GraphLine threshline;
    private ActionListener featureSettings = null;
    private ActionListener changeColourAction;
    private JComboBox<Object> noValueCombo;
    private JComboBox<Object> colourByTextCombo;
    private JComboBox<Object> colourByRangeCombo;
    private JRadioButton andFilters;
    private JRadioButton orFilters;
    List<FeatureMatcherI> filters;
    private JPanel chooseFiltersPanel;

    public FeatureTypeSettings(FeatureRenderer frender, String theType) {
        this.fr = frender;
        this.featureType = theType;
        this.ap = this.fr.ap;
        this.originalFilter = this.fr.getFeatureFilter(theType);
        this.originalColour = this.fr.getFeatureColours().get(theType);
        this.adjusting = true;
        try {
            this.initialise();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.updateColoursPanel();
        this.updateFiltersPanel();
        this.adjusting = false;
        this.colourChanged(false);
        String title = MessageManager.formatMessage("label.display_settings_for", new String[]{theType});
        this.initDialogFrame(this, true, false, title, 580, 500);
        this.waitForInput();
    }

    private void updateColoursPanel() {
        FeatureColourI fc = this.fr.getFeatureColours().get(this.featureType);
        this.adjusting = true;
        try {
            String[] attributeName;
            if (fc.isSimpleColour()) {
                this.singleColour.setBackground(fc.getColour());
                this.singleColour.setForeground(fc.getColour());
                this.simpleColour.setSelected(true);
            }
            if (fc.isColourByLabel()) {
                this.byCategory.setSelected(true);
                this.colourByTextCombo.setEnabled(this.colourByTextCombo.getItemCount() > 1);
                if (fc.isColourByAttribute()) {
                    attributeName = fc.getAttributeName();
                    this.colourByTextCombo.setSelectedItem(FeatureMatcher.toAttributeDisplayName(attributeName));
                } else {
                    this.colourByTextCombo.setSelectedItem(LABEL_18N);
                }
            } else {
                this.colourByTextCombo.setEnabled(false);
            }
            if (!fc.isGraduatedColour()) {
                this.colourByRangeCombo.setEnabled(false);
                this.minColour.setEnabled(false);
                this.maxColour.setEnabled(false);
                this.noValueCombo.setEnabled(false);
                this.threshold.setEnabled(false);
                this.slider.setEnabled(false);
                this.thresholdValue.setEnabled(false);
                this.thresholdIsMin.setEnabled(false);
                return;
            }
            this.graduatedColour.setSelected(true);
            this.updateColourMinMax();
            this.colourByRangeCombo.setEnabled(this.colourByRangeCombo.getItemCount() > 1);
            this.minColour.setEnabled(true);
            this.maxColour.setEnabled(true);
            this.noValueCombo.setEnabled(true);
            this.threshold.setEnabled(true);
            this.minColour.setBackground(fc.getMinColour());
            this.maxColour.setBackground(fc.getMaxColour());
            if (fc.isColourByAttribute()) {
                attributeName = fc.getAttributeName();
                this.colourByRangeCombo.setSelectedItem(FeatureMatcher.toAttributeDisplayName(attributeName));
            } else {
                this.colourByRangeCombo.setSelectedItem(SCORE_18N);
            }
            Color noColour = fc.getNoColour();
            if (noColour == null) {
                this.noValueCombo.setSelectedIndex(0);
            } else if (noColour.equals(fc.getMinColour())) {
                this.noValueCombo.setSelectedIndex(1);
            } else if (noColour.equals(fc.getMaxColour())) {
                this.noValueCombo.setSelectedIndex(2);
            }
            this.slider.setSliderModel(this.min, this.max, this.min);
            this.slider.setMajorTickSpacing((int)((float)(this.slider.getMaximum() - this.slider.getMinimum()) / 10.0f));
            this.threshline = new GraphLine((this.max - this.min) / 2.0f, "Threshold", Color.black);
            this.threshline.value = fc.getThreshold();
            if (fc.hasThreshold()) {
                this.threshold.setSelectedIndex(fc.isAboveThreshold() ? 1 : 2);
                this.slider.setEnabled(true);
                this.slider.setSliderValue(fc.getThreshold());
                this.setThresholdValueText(fc.getThreshold());
                this.thresholdValue.setEnabled(true);
                this.thresholdIsMin.setEnabled(true);
            } else {
                this.slider.setEnabled(false);
                this.thresholdValue.setEnabled(false);
                this.thresholdIsMin.setEnabled(false);
            }
            this.thresholdIsMin.setSelected(!fc.isAutoScaled());
        }
        finally {
            this.adjusting = false;
        }
    }

    private void initialise() {
        this.setLayout(new BorderLayout());
        this.changeColourAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureTypeSettings.this.colourChanged(true);
            }
        };
        JPanel coloursPanel = this.initialiseColoursPanel();
        this.add((Component)coloursPanel, "North");
        JPanel filtersPanel = this.initialiseFiltersPanel();
        this.add((Component)filtersPanel, "Center");
        JPanel okCancelPanel = this.initialiseOkCancelPanel();
        this.add((Component)okCancelPanel, "South");
    }

    protected void updateColourMinMax() {
        if (!this.graduatedColour.isSelected()) {
            return;
        }
        String colourBy = (String)this.colourByRangeCombo.getSelectedItem();
        float[] minMax = this.getMinMax(colourBy);
        if (minMax != null) {
            this.min = minMax[0];
            this.max = minMax[1];
        }
    }

    private float[] getMinMax(String attName) {
        float[] minMax = null;
        minMax = SCORE_18N.equals(attName) ? this.fr.getMinMax().get(this.featureType)[0] : FeatureAttributes.getInstance().getMinMax(this.featureType, FeatureMatcher.fromAttributeDisplayName(attName));
        return minMax;
    }

    private JPanel initialiseGraduatedColourPanel() {
        JPanel graduatedColourPanel = new JPanel();
        graduatedColourPanel.setLayout(new BoxLayout(graduatedColourPanel, 1));
        JvSwingUtils.createTitledBorder(graduatedColourPanel, MessageManager.getString("label.graduated_colour"), true);
        graduatedColourPanel.setBackground(Color.white);
        JPanel graduatedChoicePanel = new JPanel(new FlowLayout(0));
        graduatedChoicePanel.setBackground(Color.white);
        this.graduatedColour = new JRadioButton(MessageManager.getString("label.by_range_of") + COLON);
        this.graduatedColour.setPreferredSize(new Dimension(130, 20));
        this.graduatedColour.setOpaque(false);
        this.graduatedColour.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FeatureTypeSettings.this.graduatedColour.isSelected()) {
                    FeatureTypeSettings.this.colourChanged(true);
                }
            }
        });
        graduatedChoicePanel.add(this.graduatedColour);
        List<String[]> attNames = FeatureAttributes.getInstance().getAttributes(this.featureType);
        this.colourByRangeCombo = this.populateAttributesDropdown(attNames, true, false);
        this.colourByRangeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FeatureTypeSettings.this.colourChanged(true);
            }
        });
        this.graduatedColour.setEnabled(this.colourByRangeCombo.getItemCount() > 0);
        graduatedChoicePanel.add(this.colourByRangeCombo);
        graduatedColourPanel.add(graduatedChoicePanel);
        JPanel colourRangePanel = new JPanel(new FlowLayout(0));
        colourRangePanel.setBackground(Color.white);
        graduatedColourPanel.add(colourRangePanel);
        this.minColour.setFont(JvSwingUtils.getLabelFont());
        this.minColour.setBorder(BorderFactory.createLineBorder(Color.black));
        this.minColour.setPreferredSize(new Dimension(40, 20));
        this.minColour.setToolTipText(MessageManager.getString("label.min_colour"));
        this.minColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FeatureTypeSettings.this.minColour.isEnabled()) {
                    String ttl = MessageManager.getString("label.select_colour_minimum_value");
                    FeatureTypeSettings.this.showColourChooser(FeatureTypeSettings.this.minColour, ttl);
                }
            }
        });
        this.maxColour.setFont(JvSwingUtils.getLabelFont());
        this.maxColour.setBorder(BorderFactory.createLineBorder(Color.black));
        this.maxColour.setPreferredSize(new Dimension(40, 20));
        this.maxColour.setToolTipText(MessageManager.getString("label.max_colour"));
        this.maxColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FeatureTypeSettings.this.maxColour.isEnabled()) {
                    String ttl = MessageManager.getString("label.select_colour_maximum_value");
                    FeatureTypeSettings.this.showColourChooser(FeatureTypeSettings.this.maxColour, ttl);
                }
            }
        });
        this.maxColour.setBorder(new LineBorder(Color.black));
        Color max = this.originalColour.getMaxColour();
        if (max == null) {
            max = this.originalColour.getColour();
            this.minColour.setBackground(ColorUtils.bleachColour(max, 0.9f));
        } else {
            this.maxColour.setBackground(max);
            this.minColour.setBackground(this.originalColour.getMinColour());
        }
        this.noValueCombo = new JComboBox();
        this.noValueCombo.addItem(MessageManager.getString("label.no_colour"));
        this.noValueCombo.addItem(MessageManager.getString("label.min_colour"));
        this.noValueCombo.addItem(MessageManager.getString("label.max_colour"));
        this.noValueCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FeatureTypeSettings.this.colourChanged(true);
            }
        });
        JLabel minText = new JLabel(MessageManager.getString("label.min_value") + COLON);
        minText.setFont(JvSwingUtils.getLabelFont());
        JLabel maxText = new JLabel(MessageManager.getString("label.max_value") + COLON);
        maxText.setFont(JvSwingUtils.getLabelFont());
        JLabel noText = new JLabel(MessageManager.getString("label.no_value") + COLON);
        noText.setFont(JvSwingUtils.getLabelFont());
        colourRangePanel.add(minText);
        colourRangePanel.add(this.minColour);
        colourRangePanel.add(maxText);
        colourRangePanel.add(this.maxColour);
        colourRangePanel.add(noText);
        colourRangePanel.add(this.noValueCombo);
        JPanel thresholdPanel = new JPanel(new FlowLayout(0));
        thresholdPanel.setBackground(Color.white);
        graduatedColourPanel.add(thresholdPanel);
        this.threshold.addActionListener(this.changeColourAction);
        this.threshold.setToolTipText(MessageManager.getString("label.threshold_feature_display_by_score"));
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_no_threshold"));
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_above_threshold"));
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_below_threshold"));
        this.thresholdValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureTypeSettings.this.thresholdValue_actionPerformed();
            }
        });
        this.thresholdValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FeatureTypeSettings.this.thresholdValue_actionPerformed();
            }
        });
        this.slider = new Slider(0.0f, 100.0f, 50.0f);
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(true);
        this.slider.setBackground(Color.white);
        this.slider.setEnabled(false);
        this.slider.setOpaque(false);
        this.slider.setPreferredSize(new Dimension(100, 32));
        this.slider.setToolTipText(MessageManager.getString("label.adjust_threshold"));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!FeatureTypeSettings.this.adjusting) {
                    FeatureTypeSettings.this.setThresholdValueText(FeatureTypeSettings.this.slider.getSliderValue());
                    FeatureTypeSettings.this.thresholdValue.setBackground(Color.white);
                    FeatureTypeSettings.this.sliderValueChanged();
                }
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (FeatureTypeSettings.this.ap != null) {
                    FeatureTypeSettings.this.refreshDisplay(true);
                }
            }
        });
        this.thresholdValue.setEnabled(false);
        this.thresholdValue.setColumns(7);
        thresholdPanel.add(this.threshold);
        thresholdPanel.add(this.slider);
        thresholdPanel.add(this.thresholdValue);
        this.thresholdIsMin.setBackground(Color.white);
        this.thresholdIsMin.setText(MessageManager.getString("label.threshold_minmax"));
        this.thresholdIsMin.setToolTipText(MessageManager.getString("label.toggle_absolute_relative_display_threshold"));
        this.thresholdIsMin.addActionListener(this.changeColourAction);
        thresholdPanel.add(this.thresholdIsMin);
        return graduatedColourPanel;
    }

    private JPanel initialiseOkCancelPanel() {
        JPanel okCancelPanel = new JPanel();
        okCancelPanel.add(this.ok);
        okCancelPanel.add(this.cancel);
        return okCancelPanel;
    }

    private JPanel initialiseColoursPanel() {
        JPanel colourByPanel = new JPanel();
        colourByPanel.setBackground(Color.white);
        colourByPanel.setLayout(new BoxLayout(colourByPanel, 1));
        JvSwingUtils.createTitledBorder(colourByPanel, MessageManager.getString("action.colour"), true);
        JPanel simpleColourPanel = new JPanel(new FlowLayout(0));
        simpleColourPanel.setBackground(Color.white);
        colourByPanel.add(simpleColourPanel);
        this.simpleColour = new JRadioButton(MessageManager.getString("label.simple_colour"));
        this.simpleColour.setPreferredSize(new Dimension(130, 20));
        this.simpleColour.setOpaque(false);
        this.simpleColour.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FeatureTypeSettings.this.simpleColour.isSelected() && !FeatureTypeSettings.this.adjusting) {
                    FeatureTypeSettings.this.colourChanged(true);
                }
            }
        });
        this.singleColour.setFont(JvSwingUtils.getLabelFont());
        this.singleColour.setBorder(BorderFactory.createLineBorder(Color.black));
        this.singleColour.setPreferredSize(new Dimension(40, 20));
        this.singleColour.setBackground(this.originalColour.getColour());
        this.singleColour.setForeground(this.originalColour.getColour());
        this.singleColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FeatureTypeSettings.this.simpleColour.isSelected()) {
                    String ttl = MessageManager.formatMessage("label.select_colour_for", FeatureTypeSettings.this.featureType);
                    FeatureTypeSettings.this.showColourChooser(FeatureTypeSettings.this.singleColour, ttl);
                }
            }
        });
        simpleColourPanel.add(this.simpleColour);
        simpleColourPanel.add(this.singleColour);
        JPanel byTextPanel = new JPanel(new FlowLayout(0));
        byTextPanel.setBackground(Color.white);
        JvSwingUtils.createTitledBorder(byTextPanel, MessageManager.getString("label.colour_by_text"), true);
        colourByPanel.add(byTextPanel);
        this.byCategory = new JRadioButton(MessageManager.getString("label.by_text_of") + COLON);
        this.byCategory.setPreferredSize(new Dimension(130, 20));
        this.byCategory.setOpaque(false);
        this.byCategory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FeatureTypeSettings.this.byCategory.isSelected()) {
                    FeatureTypeSettings.this.colourChanged(true);
                }
            }
        });
        byTextPanel.add(this.byCategory);
        List<String[]> attNames = FeatureAttributes.getInstance().getAttributes(this.featureType);
        this.colourByTextCombo = this.populateAttributesDropdown(attNames, false, true);
        this.colourByTextCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FeatureTypeSettings.this.colourChanged(true);
            }
        });
        byTextPanel.add(this.colourByTextCombo);
        JPanel graduatedColourPanel = this.initialiseGraduatedColourPanel();
        colourByPanel.add(graduatedColourPanel);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.simpleColour);
        bg.add(this.byCategory);
        bg.add(this.graduatedColour);
        return colourByPanel;
    }

    void showColourChooser(final JPanel colourPanel, String title) {
        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

            @Override
            public void colourSelected(Color col) {
                colourPanel.setBackground(col);
                colourPanel.setForeground(col);
                colourPanel.repaint();
                FeatureTypeSettings.this.colourChanged(true);
            }
        };
        JalviewColourChooser.showColourChooser(this, title, colourPanel.getBackground(), listener);
    }

    void colourChanged(boolean updateStructsAndOverview) {
        if (this.adjusting) {
            return;
        }
        this.updateColourMinMax();
        FeatureColourI acg = this.makeColourFromInputs();
        this.fr.setColour(this.featureType, acg);
        this.refreshDisplay(updateStructsAndOverview);
        this.updateColoursPanel();
    }

    private FeatureColourI makeColourFromInputs() {
        float thresh = 0.0f;
        try {
            thresh = Float.valueOf(this.thresholdValue.getText()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float minValue = this.min;
        float maxValue = this.max;
        int thresholdOption = this.threshold.getSelectedIndex();
        if (this.thresholdIsMin.isSelected() && thresholdOption == 1) {
            minValue = thresh;
        }
        if (this.thresholdIsMin.isSelected() && thresholdOption == 2) {
            maxValue = thresh;
        }
        Color noColour = null;
        if (this.noValueCombo.getSelectedIndex() == 1) {
            noColour = this.minColour.getBackground();
        } else if (this.noValueCombo.getSelectedIndex() == 2) {
            noColour = this.maxColour.getBackground();
        }
        FeatureColour fc = new FeatureColour(this.singleColour.getBackground(), this.minColour.getBackground(), this.maxColour.getBackground(), noColour, minValue, maxValue);
        if (this.simpleColour.isSelected()) {
            fc.setGraduatedColour(false);
            return fc;
        }
        if (this.byCategory.isSelected()) {
            fc.setColourByLabel(true);
            String byWhat = (String)this.colourByTextCombo.getSelectedItem();
            if (!LABEL_18N.equals(byWhat)) {
                fc.setAttributeName(FeatureMatcher.fromAttributeDisplayName(byWhat));
            }
            return fc;
        }
        String byWhat = (String)this.colourByRangeCombo.getSelectedItem();
        if (!SCORE_18N.equals(byWhat)) {
            fc.setAttributeName(FeatureMatcher.fromAttributeDisplayName(byWhat));
        }
        fc.setThreshold(thresh);
        fc.setAutoScaled(!this.thresholdIsMin.isSelected());
        fc.setAboveThreshold(thresholdOption == 1);
        fc.setBelowThreshold(thresholdOption == 2);
        if (this.threshline == null) {
            this.threshline = new GraphLine((this.max - this.min) / 2.0f, "Threshold", Color.black);
        }
        return fc;
    }

    @Override
    protected void raiseClosed() {
        if (this.featureSettings != null) {
            this.featureSettings.actionPerformed(new ActionEvent(this, 0, "CLOSED"));
        }
    }

    @Override
    public void okPressed() {
    }

    @Override
    public void cancelPressed() {
        this.fr.setColour(this.featureType, this.originalColour);
        this.fr.setFeatureFilter(this.featureType, this.originalFilter);
        this.refreshDisplay(true);
    }

    protected void thresholdValue_actionPerformed() {
        try {
            this.adjusting = true;
            float f = Float.parseFloat(this.thresholdValue.getText());
            f = Float.max(f, this.min);
            f = Float.min(f, this.max);
            this.setThresholdValueText(f);
            this.slider.setSliderValue(f);
            this.threshline.value = f;
            this.thresholdValue.setBackground(Color.white);
            this.adjusting = false;
            this.colourChanged(true);
        }
        catch (NumberFormatException ex) {
            this.thresholdValue.setBackground(Color.red);
            this.adjusting = false;
        }
    }

    void setThresholdValueText(float f) {
        BigDecimal formatted = new BigDecimal(f).round(FOUR_SIG_FIG).stripTrailingZeros();
        this.thresholdValue.setText(formatted.toPlainString());
    }

    protected void sliderValueChanged() {
        this.threshline.value = this.slider.getSliderValue();
        this.colourChanged(false);
    }

    void addActionListener(ActionListener listener) {
        if (this.featureSettings != null) {
            System.err.println("IMPLEMENTATION ISSUE: overwriting action listener for FeatureColourChooser");
        }
        this.featureSettings = listener;
    }

    protected JComboBox<Object> populateAttributesDropdown(List<String[]> attNames, boolean withRange, boolean withText) {
        float[][] minMax;
        ArrayList<String> displayAtts = new ArrayList<String>();
        ArrayList<String> tooltips = new ArrayList<String>();
        if (withText) {
            displayAtts.add(LABEL_18N);
            tooltips.add(MessageManager.getString("label.description"));
        }
        if (withRange && (minMax = this.fr.getMinMax().get(this.featureType)) != null && minMax[0][0] != minMax[0][1]) {
            displayAtts.add(SCORE_18N);
            tooltips.add(SCORE_18N);
        }
        FeatureAttributes fa = FeatureAttributes.getInstance();
        for (String[] attName : attNames) {
            boolean hasRange;
            float[] minMax2 = fa.getMinMax(this.featureType, attName);
            boolean bl = hasRange = minMax2 != null && minMax2[0] != minMax2[1];
            if (!withText && !hasRange) continue;
            displayAtts.add(FeatureMatcher.toAttributeDisplayName(attName));
            Object desc = fa.getDescription(this.featureType, attName);
            if (desc != null && ((String)desc).length() > 50) {
                desc = ((String)desc).substring(0, 50) + "...";
            }
            tooltips.add((String)(desc == null ? "" : desc));
        }
        ArrayList<Object> displayAttsObjects = new ArrayList<Object>(displayAtts);
        JComboBox<Object> attCombo = JvSwingUtils.buildComboWithTooltips(displayAttsObjects, tooltips);
        return attCombo;
    }

    private JPanel initialiseFiltersPanel() {
        this.filters = new ArrayList<FeatureMatcherI>();
        JPanel filtersPanel = new JPanel();
        filtersPanel.setLayout(new BoxLayout(filtersPanel, 1));
        filtersPanel.setBackground(Color.white);
        JvSwingUtils.createTitledBorder(filtersPanel, MessageManager.getString("label.filters"), true);
        JPanel andOrPanel = this.initialiseAndOrPanel();
        filtersPanel.add(andOrPanel);
        this.chooseFiltersPanel = new JPanel();
        this.chooseFiltersPanel.setBackground(Color.white);
        filtersPanel.add(this.chooseFiltersPanel);
        return filtersPanel;
    }

    private JPanel initialiseAndOrPanel() {
        JPanel andOrPanel = new JPanel(new FlowLayout(0));
        andOrPanel.setBackground(Color.white);
        this.andFilters = new JRadioButton(MessageManager.getString("label.and"));
        this.orFilters = new JRadioButton(MessageManager.getString("label.or"));
        this.andFilters.setOpaque(false);
        this.orFilters.setOpaque(false);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureTypeSettings.this.filtersChanged();
            }
        };
        this.andFilters.addActionListener(actionListener);
        this.orFilters.addActionListener(actionListener);
        ButtonGroup andOr = new ButtonGroup();
        andOr.add(this.andFilters);
        andOr.add(this.orFilters);
        this.andFilters.setSelected(true);
        andOrPanel.add(new JLabel(MessageManager.getString("label.join_conditions")));
        andOrPanel.add(this.andFilters);
        andOrPanel.add(this.orFilters);
        return andOrPanel;
    }

    private void updateFiltersPanel() {
        this.chooseFiltersPanel.removeAll();
        this.filters.clear();
        List<String[]> attNames = FeatureAttributes.getInstance().getAttributes(this.featureType);
        FeatureMatcherSetI featureFilters = this.fr.getFeatureFilter(this.featureType);
        if (featureFilters != null) {
            if (!featureFilters.isAnded()) {
                this.orFilters.setSelected(true);
            }
            for (FeatureMatcherI matcher : featureFilters.getMatchers()) {
                this.filters.add(matcher);
            }
        }
        this.filters.add(FeatureMatcher.NULL_MATCHER);
        if (this.filters.size() <= 5) {
            this.chooseFiltersPanel.setLayout(new GridLayout(5, 1));
        } else {
            this.chooseFiltersPanel.setLayout(new BoxLayout(this.chooseFiltersPanel, 1));
        }
        int filterIndex = 0;
        for (FeatureMatcherI filter : this.filters) {
            JPanel row = this.addFilter(filter, attNames, filterIndex);
            this.chooseFiltersPanel.add(row);
            ++filterIndex;
        }
        this.validate();
        this.repaint();
    }

    protected JPanel addFilter(FeatureMatcherI filter, List<String[]> attNames, final int filterIndex) {
        String[] attName = filter.getAttribute();
        Condition cond = filter.getMatcher().getCondition();
        String pattern = filter.getMatcher().getPattern();
        JPanel filterRow = new JPanel(new FlowLayout(0));
        filterRow.setBackground(Color.white);
        final JComboBox<Object> attCombo = this.populateAttributesDropdown(attNames, true, true);
        String filterBy = this.setSelectedAttribute(attCombo, filter);
        final JComboBox<Condition> condCombo = new JComboBox<Condition>();
        final JTextField patternField = new JTextField(8);
        patternField.setText(pattern);
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FeatureTypeSettings.this.validateFilter(patternField, condCombo) && FeatureTypeSettings.this.updateFilter(attCombo, condCombo, patternField, filterIndex)) {
                    FeatureTypeSettings.this.filtersChanged();
                }
            }
        };
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                actionListener.actionPerformed(null);
            }
        };
        if (filter == FeatureMatcher.NULL_MATCHER) {
            attCombo.setSelectedIndex(0);
        } else {
            attCombo.setSelectedItem(FeatureMatcher.toAttributeDisplayName(attName));
        }
        attCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FeatureTypeSettings.this.populateConditions((String)attCombo.getSelectedItem(), (Condition)((Object)condCombo.getSelectedItem()), condCombo, patternField);
                actionListener.actionPerformed(null);
            }
        });
        filterRow.add(attCombo);
        this.populateConditions(filterBy, cond, condCombo, patternField);
        condCombo.setPreferredSize(new Dimension(150, 20));
        condCombo.addItemListener(itemListener);
        filterRow.add(condCombo);
        patternField.addActionListener(actionListener);
        patternField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                actionListener.actionPerformed(null);
            }
        });
        filterRow.add(patternField);
        Condition selectedCondition = (Condition)((Object)condCombo.getSelectedItem());
        patternField.setEnabled(selectedCondition.needsAPattern());
        this.setNumericHints(filterBy, selectedCondition, patternField);
        if (!patternField.isEnabled() || pattern != null && pattern.trim().length() > 0) {
            JButton removeCondition = new JButton("\u2717");
            removeCondition.setBorder(new EmptyBorder(0, 0, 0, 0));
            removeCondition.setBackground(Color.WHITE);
            removeCondition.setPreferredSize(new Dimension(23, 17));
            removeCondition.setToolTipText(MessageManager.getString("label.delete_condition"));
            removeCondition.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeatureTypeSettings.this.filters.remove(filterIndex);
                    FeatureTypeSettings.this.filtersChanged();
                }
            });
            filterRow.add(removeCondition);
        }
        return filterRow;
    }

    private String setSelectedAttribute(JComboBox<Object> attCombo, FeatureMatcherI filter) {
        String item = null;
        item = filter.isByScore() ? SCORE_18N : (filter.isByLabel() ? LABEL_18N : FeatureMatcher.toAttributeDisplayName(filter.getAttribute()));
        attCombo.setSelectedItem(item);
        return item;
    }

    private void setNumericHints(String attName, Condition selectedCondition, JTextField patternField) {
        float[] minMax;
        patternField.setToolTipText("");
        if (selectedCondition.isNumeric() && (minMax = this.getMinMax(attName)) != null) {
            String minFormatted = DECFMT_2_2.format(minMax[0]);
            String maxFormatted = DECFMT_2_2.format(minMax[1]);
            String tip = String.format("(%s - %s)", minFormatted, maxFormatted);
            patternField.setToolTipText(tip);
            if (patternField.getText().isEmpty()) {
                if (selectedCondition == Condition.GE || selectedCondition == Condition.GT) {
                    patternField.setText(minFormatted);
                } else if (selectedCondition == Condition.LE || selectedCondition == Condition.LT) {
                    patternField.setText(maxFormatted);
                }
            }
        }
    }

    void populateConditions(String attName, Condition cond, JComboBox<Condition> condCombo, JTextField patternField) {
        FeatureAttributes.Datatype type = FeatureAttributes.getInstance().getDatatype(this.featureType, FeatureMatcher.fromAttributeDisplayName(attName));
        if (LABEL_18N.equals(attName)) {
            type = FeatureAttributes.Datatype.Character;
        } else if (SCORE_18N.equals(attName)) {
            type = FeatureAttributes.Datatype.Number;
        }
        ItemListener listener = condCombo.getItemListeners()[0];
        condCombo.removeItemListener(listener);
        boolean condIsValid = false;
        condCombo.removeAllItems();
        for (Condition c : Condition.values()) {
            if ((!c.isNumeric() || type != FeatureAttributes.Datatype.Number) && (c.isNumeric() || type == FeatureAttributes.Datatype.Number)) continue;
            condCombo.addItem(c);
            if (c != cond) continue;
            condIsValid = true;
        }
        if (condIsValid) {
            condCombo.setSelectedItem((Object)cond);
        } else {
            condCombo.setSelectedIndex(0);
        }
        if (((Condition)((Object)condCombo.getSelectedItem())).isNumeric()) {
            try {
                String pattern = patternField.getText().trim();
                if (pattern.length() > 0) {
                    Float.valueOf(pattern);
                }
            }
            catch (NumberFormatException e) {
                patternField.setText("");
            }
        }
        condCombo.addItemListener(listener);
    }

    protected boolean validateFilter(JTextField value, JComboBox<Condition> condCombo) {
        if (value == null || condCombo == null) {
            return true;
        }
        Condition cond = (Condition)((Object)condCombo.getSelectedItem());
        if (!cond.needsAPattern()) {
            return true;
        }
        value.setBackground(Color.white);
        value.setToolTipText("");
        String v1 = value.getText().trim();
        if (v1.length() == 0) {
            // empty if block
        }
        if (cond.isNumeric() && v1.length() > 0) {
            try {
                Float.valueOf(v1);
            }
            catch (NumberFormatException e) {
                value.setBackground(Color.red);
                value.setToolTipText(MessageManager.getString("label.numeric_required"));
                return false;
            }
        }
        return true;
    }

    protected boolean updateFilter(JComboBox<Object> attCombo, JComboBox<Condition> condCombo, JTextField valueField, int filterIndex) {
        String attName;
        try {
            attName = (String)attCombo.getSelectedItem();
        }
        catch (Exception e) {
            Cache.log.error((Object)"Problem casting Combo box entry to String");
            attName = attCombo.getSelectedItem().toString();
        }
        Condition cond = (Condition)((Object)condCombo.getSelectedItem());
        String pattern = valueField.getText().trim();
        this.setNumericHints(attName, cond, valueField);
        if (pattern.length() == 0 && cond.needsAPattern()) {
            valueField.setEnabled(true);
            return false;
        }
        FeatureMatcher km = null;
        km = LABEL_18N.equals(attName) ? FeatureMatcher.byLabel(cond, pattern) : (SCORE_18N.equals(attName) ? FeatureMatcher.byScore(cond, pattern) : FeatureMatcher.byAttribute(cond, pattern, FeatureMatcher.fromAttributeDisplayName(attName)));
        this.filters.set(filterIndex, km);
        return true;
    }

    protected void filtersChanged() {
        boolean anded = this.andFilters.isSelected();
        FeatureMatcherSet combined = new FeatureMatcherSet();
        for (FeatureMatcherI filter : this.filters) {
            String pattern = filter.getMatcher().getPattern();
            Condition condition = filter.getMatcher().getCondition();
            if (pattern.trim().length() <= 0 && condition.needsAPattern()) continue;
            if (anded) {
                combined.and(filter);
                continue;
            }
            combined.or(filter);
        }
        this.fr.setFeatureFilter(this.featureType, combined.isEmpty() ? null : combined);
        this.refreshDisplay(true);
        this.updateFiltersPanel();
    }

    void refreshDisplay(boolean updateStructsAndOverview) {
        this.ap.paintAlignment(true, updateStructsAndOverview);
        AlignViewportI complement = this.ap.getAlignViewport().getCodingComplement();
        if (complement != null && complement.isShowComplementFeatures()) {
            AlignFrame af2 = Desktop.getAlignFrameFor(complement);
            af2.alignPanel.paintAlignment(true, updateStructsAndOverview);
        }
    }
}

