/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.StructureSelectionManagerProvider;
import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.gui.APQHandlers;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.AquaInternalFrameManager;
import jalview.gui.BlogReader;
import jalview.gui.Console;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.FeatureSettings;
import jalview.gui.Help;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.ImageExporter;
import jalview.gui.JalviewChangeSupport;
import jalview.gui.JvOptionPane;
import jalview.gui.OOMWarning;
import jalview.gui.PCAPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.PairwiseAlignPanel;
import jalview.gui.Preferences;
import jalview.gui.SequenceFetcher;
import jalview.gui.SplashScreen;
import jalview.gui.SplitFrame;
import jalview.gui.StructureViewerBase;
import jalview.gui.TreePanel;
import jalview.gui.UserQuestionnaireCheck;
import jalview.gui.VamsasApplication;
import jalview.gui.WsParamSetManager;
import jalview.io.BackupFiles;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GDesktop;
import jalview.jbgui.GSplitFrame;
import jalview.jbgui.GStructureViewer;
import jalview.project.Jalview2XML;
import jalview.structure.StructureSelectionManager;
import jalview.urls.IdOrgSettings;
import jalview.util.BrowserLauncher;
import jalview.util.ChannelProperties;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.ShortcutKeyMaskExWrapper;
import jalview.util.UrlConstants;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.jws1.Discoverer;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.params.ParamManager;
import jalview.ws.utils.UrlDownloadClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.stackoverflowusers.file.WindowsShortcut;

public class Desktop
extends GDesktop
implements DropTargetListener,
ClipboardOwner,
IProgressIndicator,
StructureSelectionManagerProvider {
    private static final String CITATION;
    private static final String DEFAULT_AUTHORS = "The Jalview Authors (See AUTHORS file for current list)";
    private static int DEFAULT_MIN_WIDTH;
    private static int DEFAULT_MIN_HEIGHT;
    private static int ALIGN_FRAME_DEFAULT_MIN_WIDTH;
    private static int ALIGN_FRAME_DEFAULT_MIN_HEIGHT;
    private static final String EXPERIMENTAL_FEATURES = "EXPERIMENTAL_FEATURES";
    protected static final String CONFIRM_KEYBOARD_QUIT = "CONFIRM_KEYBOARD_QUIT";
    public static HashMap<String, FileWriter> savingFiles;
    private JalviewChangeSupport changeSupport = new JalviewChangeSupport();
    public static boolean nosplash;
    private BlogReader jvnews = null;
    private File projectFile;
    public static Desktop instance;
    public static MyDesktopPane desktop;
    static int openFrameCount;
    static final int xOffset = 30;
    static final int yOffset = 30;
    public static Discoverer discoverer;
    public static Object[] jalviewClipboard;
    public static boolean internalCopy;
    static int fileLoadingCount;
    Console jconsole = null;
    JPanel progressPanel;
    ArrayList<JPanel> fileLoadingPanels = new ArrayList();
    int totalProgressCount = 0;
    private Hashtable<Long, JPanel> progressBars;
    private Hashtable<Long, IProgressIndicatorHandler> progressBarHandlers;
    private boolean inBatchMode = false;
    private Runnable serviceChangedDialog = null;
    public static WsParamSetManager wsparamManager;
    ExecutorService dialogExecutor = Executors.newSingleThreadExecutor();
    private volatile boolean dialogPause = true;
    private Semaphore block = new Semaphore(0);
    private static groovy.ui.Console groovyConsole;
    public static final String debugScaleMessage = "Desktop graphics transform scale=";
    private static boolean debugScaleMessageDone;

    public void addJalviewPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addJalviewPropertyChangeListener(listener);
    }

    public void addJalviewPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addJalviewPropertyChangeListener(propertyName, listener);
    }

    public void removeJalviewPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removeJalviewPropertyChangeListener(propertyName, listener);
    }

    public static MyDesktopPane getDesktop() {
        return desktop;
    }

    public Desktop() {
        instance = this;
        this.doConfigureStructurePrefs();
        this.setTitle(ChannelProperties.getProperty("app_name") + " " + Cache.getProperty("VERSION"));
        if (Platform.isLinux()) {
            try {
                Toolkit xToolkit = Toolkit.getDefaultToolkit();
                Field[] declaredFields = xToolkit.getClass().getDeclaredFields();
                Field awtAppClassNameField = null;
                if (Arrays.stream(declaredFields).anyMatch(f -> f.getName().equals("awtAppClassName"))) {
                    awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                }
                String title = ChannelProperties.getProperty("app_name");
                if (awtAppClassNameField != null) {
                    awtAppClassNameField.setAccessible(true);
                    awtAppClassNameField.set(xToolkit, title);
                } else {
                    Cache.log.debug((Object)"XToolkit: awtAppClassName not found");
                }
            }
            catch (Exception e) {
                Cache.debug("Error setting awtAppClassName");
                Cache.trace(Cache.getStackTraceString(e));
            }
        }
        try {
            APQHandlers.setAPQHandlers(this);
        }
        catch (Throwable t) {
            Cache.warn("Error setting APQHandlers: " + t.toString());
            Cache.trace(Cache.getStackTraceString(t));
        }
        this.setIconImages(ChannelProperties.getIconList());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                Desktop.this.quit();
            }
        });
        boolean selmemusage = Cache.getDefault("SHOW_MEMUSAGE", false);
        boolean showjconsole = Cache.getDefault("SHOW_JAVA_CONSOLE", false);
        desktop = new MyDesktopPane(selmemusage);
        this.showMemusage.setSelected(selmemusage);
        desktop.setBackground(Color.white);
        this.setIconImages(ChannelProperties.getIconList());
        this.getContentPane().setLayout(new BorderLayout());
        if (Platform.isJS()) {
            this.getRootPane().putClientProperty("swingjs.overflow.hidden", "false");
        }
        this.getContentPane().add((Component)desktop, "Center");
        desktop.setDragMode(1);
        desktop.setDesktopManager(new MyDesktopManager(Platform.isWindowsAndNotJS() ? new DefaultDesktopManager() : (Platform.isAMacAndNotJS() ? new AquaInternalFrameManager(desktop.getDesktopManager()) : desktop.getDesktopManager())));
        Rectangle dims = this.getLastKnownDimensions("");
        if (dims != null) {
            this.setBounds(dims);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xPos = Math.max(5, (screenSize.width - 900) / 2);
            int yPos = Math.max(5, (screenSize.height - 650) / 2);
            this.setBounds(xPos, yPos, 900, 650);
        }
        if (!Platform.isJS()) {
            this.jconsole = new Console(this, showjconsole);
            this.jconsole.setHeader(Cache.getVersionDetailsForConsole());
            this.showConsole(showjconsole);
            this.showNews.setVisible(false);
            this.experimentalFeatures.setSelected(this.showExperimental());
            this.getIdentifiersOrgData();
            this.checkURLLinks();
            if (!nosplash) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new SplashScreen(true);
                    }
                });
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Cache.log.debug((Object)"Filechooser init thread started.");
                    String fileFormat = Cache.getProperty("DEFAULT_FILE_FORMAT");
                    JalviewFileChooser.forRead(Cache.getProperty("LAST_DIRECTORY"), fileFormat);
                    Cache.log.debug((Object)"Filechooser init thread finished.");
                }
            }).start();
            this.changeSupport.addJalviewPropertyChangeListener("services", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Cache.log.debug((Object)("Firing service changed event for " + evt.getNewValue()));
                    Desktop.this.JalviewServicesChanged(evt);
                }
            });
        }
        this.setDropTarget(new DropTarget(desktop, this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Desktop.this.quit();
            }
        });
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Desktop.this.showPasteMenu(evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Desktop.this.showPasteMenu(evt.getX(), evt.getY());
                }
            }
        };
        this.addMouseListener(ma);
        desktop.addMouseListener(ma);
    }

    public boolean showExperimental() {
        String experimental = Cache.getDefault(EXPERIMENTAL_FEATURES, Boolean.FALSE.toString());
        return Boolean.valueOf(experimental);
    }

    public void doConfigureStructurePrefs() {
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(this);
        if (Cache.getDefault("ADD_SS_ANN", true)) {
            ssm.setAddTempFacAnnot(Cache.getDefault("ADD_TEMPFACT_ANN", true));
            ssm.setProcessSecondaryStructure(Cache.getDefault("STRUCT_FROM_PDB", true));
            ssm.setSecStructServices(Cache.getDefault("USE_RNAVIEW", true));
        } else {
            ssm.setAddTempFacAnnot(false);
            ssm.setProcessSecondaryStructure(false);
            ssm.setSecStructServices(false);
        }
    }

    public void checkForNews() {
        final Desktop me = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Cache.log.debug((Object)"Starting news thread.");
                Desktop.this.jvnews = new BlogReader(me);
                Desktop.this.showNews.setVisible(true);
                Cache.log.debug((Object)"Completed news thread.");
            }
        }).start();
    }

    public void getIdentifiersOrgData() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Cache.log.debug((Object)"Downloading data from identifiers.org");
                try {
                    UrlDownloadClient.download(IdOrgSettings.getUrl(), IdOrgSettings.getDownloadLocation());
                }
                catch (IOException e) {
                    Cache.log.debug((Object)("Exception downloading identifiers.org data" + e.getMessage()));
                }
            }
        }).start();
    }

    @Override
    protected void showNews_actionPerformed(ActionEvent e) {
        this.showNews(this.showNews.isSelected());
    }

    void showNews(boolean visible) {
        Cache.log.debug((Object)((visible ? "Showing" : "Hiding") + " news."));
        this.showNews.setSelected(visible);
        if (visible && !this.jvnews.isVisible()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long now = System.currentTimeMillis();
                    instance.setProgressBar(MessageManager.getString("status.refreshing_news"), now);
                    Desktop.this.jvnews.refreshNews();
                    instance.setProgressBar(null, now);
                    Desktop.this.jvnews.showNews();
                }
            }).start();
        }
    }

    Rectangle getLastKnownDimensions(String windowName) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String x = Cache.getProperty(windowName + "SCREEN_X");
        String y = Cache.getProperty(windowName + "SCREEN_Y");
        String width = Cache.getProperty(windowName + "SCREEN_WIDTH");
        String height = Cache.getProperty(windowName + "SCREEN_HEIGHT");
        if (x != null && y != null && width != null && height != null) {
            int ix = Integer.parseInt(x);
            int iy = Integer.parseInt(y);
            int iw = Integer.parseInt(width);
            int ih = Integer.parseInt(height);
            if (Cache.getProperty("SCREENGEOMETRY_WIDTH") != null) {
                double sw = 1.0f * (float)screenSize.width / (1.0f * (float)Integer.parseInt(Cache.getProperty("SCREENGEOMETRY_WIDTH")));
                double sh = 1.0f * (float)screenSize.height / (1.0f * (float)Integer.parseInt(Cache.getProperty("SCREENGEOMETRY_HEIGHT")));
                iw = (int)((double)iw * sw);
                iy = (int)((double)iy * sh);
                ih = (int)((double)ih * sh);
                for (ix = (int)((double)ix * sw); ix >= screenSize.width; ix -= screenSize.width) {
                    Cache.log.debug((Object)"Window geometry location recall error: shifting horizontal to within screenbounds.");
                }
                while (iy >= screenSize.height) {
                    Cache.log.debug((Object)"Window geometry location recall error: shifting vertical to within screenbounds.");
                    iy -= screenSize.height;
                }
                Cache.log.debug((Object)("Got last known dimensions for " + windowName + ": x:" + ix + " y:" + iy + " width:" + iw + " height:" + ih));
            }
            return new Rectangle(ix, iy, iw, ih);
        }
        return null;
    }

    void showPasteMenu(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem(MessageManager.getString("label.paste_new_window"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.paste();
            }
        });
        popup.add(item);
        popup.show(this, x, y);
    }

    public void paste() {
        try {
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = c.getContents(this);
            if (contents != null) {
                String file = (String)contents.getTransferData(DataFlavor.stringFlavor);
                FileFormatI format = new IdentifyFile().identify(file, DataSourceType.PASTE);
                new FileLoader().LoadFile(file, DataSourceType.PASTE, format);
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to paste alignment from system clipboard:\n" + ex);
        }
    }

    public static synchronized void addInternalFrame(JInternalFrame frame, String title, int w, int h) {
        Desktop.addInternalFrame(frame, title, true, w, h, true, false);
    }

    public static synchronized void addInternalFrame(JInternalFrame frame, String title, boolean makeVisible, int w, int h) {
        Desktop.addInternalFrame(frame, title, makeVisible, w, h, true, false);
    }

    public static synchronized void addInternalFrame(JInternalFrame frame, String title, int w, int h, boolean resizable) {
        Desktop.addInternalFrame(frame, title, true, w, h, resizable, false);
    }

    public static synchronized void addInternalFrame(final JInternalFrame frame, String title, boolean makeVisible, int w, int h, boolean resizable, boolean ignoreMinSize) {
        frame.setTitle(title);
        if (frame.getWidth() < 1 || frame.getHeight() < 1) {
            frame.setSize(w, h);
        }
        if (instance == null || System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true")) {
            return;
        }
        ++openFrameCount;
        if (!ignoreMinSize) {
            frame.setMinimumSize(new Dimension(DEFAULT_MIN_WIDTH, DEFAULT_MIN_HEIGHT));
            if (frame instanceof AlignFrame) {
                frame.setMinimumSize(new Dimension(ALIGN_FRAME_DEFAULT_MIN_WIDTH, ALIGN_FRAME_DEFAULT_MIN_HEIGHT));
            }
        }
        frame.setVisible(makeVisible);
        frame.setClosable(true);
        frame.setResizable(resizable);
        frame.setMaximizable(resizable);
        frame.setIconifiable(resizable);
        frame.setOpaque(Platform.isJS());
        if (frame.getX() < 1 && frame.getY() < 1) {
            frame.setLocation(30 * openFrameCount, 30 * ((openFrameCount - 1) % 10) + 30);
        }
        final JMenuItem menuItem = new JMenuItem(title);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                JInternalFrame itf = desktop.getSelectedFrame();
                if (itf != null) {
                    if (itf instanceof AlignFrame) {
                        Jalview.setCurrentAlignFrame((AlignFrame)itf);
                    }
                    itf.requestFocus();
                }
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                PaintRefresher.RemoveComponent(frame);
                if (openFrameCount > 0) {
                    --openFrameCount;
                }
                if (menuItem.getActionListeners().length > 0) {
                    menuItem.removeActionListener(menuItem.getActionListeners()[0]);
                }
                windowMenu.remove(menuItem);
            }
        });
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    frame.setSelected(true);
                    frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        Desktop.setKeyBindings(frame);
        desktop.add(frame);
        windowMenu.add(menuItem);
        frame.toFront();
        try {
            frame.setSelected(true);
            frame.requestFocus();
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (ClassCastException cex) {
            Cache.log.warn((Object)"Squashed a possible GUI implementation error. If you can recreate this, please look at https://issues.jalview.org/browse/JAL-869", (Throwable)cex);
        }
    }

    private static void setKeyBindings(final JInternalFrame frame) {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        };
        KeyStroke ctrlWKey = KeyStroke.getKeyStroke(87, 128);
        KeyStroke cmdWKey = KeyStroke.getKeyStroke(87, ShortcutKeyMaskExWrapper.getMenuShortcutKeyMaskEx());
        InputMap inputMap = frame.getInputMap(2);
        String ctrlW = ctrlWKey.toString();
        inputMap.put(ctrlWKey, ctrlW);
        inputMap.put(cmdWKey, ctrlW);
        ActionMap actionMap = frame.getActionMap();
        actionMap.put(ctrlW, closeAction);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        if (!internalCopy) {
            jalviewClipboard = null;
        }
        internalCopy = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        boolean success = true;
        evt.acceptDrop(3);
        Transferable t = evt.getTransferable();
        ArrayList<Object> files = new ArrayList<Object>();
        ArrayList<DataSourceType> protocols = new ArrayList<DataSourceType>();
        try {
            Desktop.transferFromDropTarget(files, protocols, evt, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        if (files != null) {
            try {
                for (int i = 0; i < files.size(); ++i) {
                    Object file = files.get(i);
                    String fileName = file.toString();
                    DataSourceType protocol = protocols == null ? DataSourceType.FILE : (DataSourceType)((Object)protocols.get(i));
                    FileFormatI format = null;
                    format = fileName.endsWith(".jar") ? FileFormat.Jalview : new IdentifyFile().identify(file, protocol);
                    if (file instanceof File) {
                        Platform.cacheFileData((File)file);
                    }
                    new FileLoader().LoadFile(null, file, protocol, format);
                }
            }
            catch (Exception ex) {
                success = false;
            }
        }
        evt.dropComplete(success);
    }

    @Override
    public void inputLocalFileMenuItem_actionPerformed(final AlignViewport viewport) {
        String fileFormat = Cache.getProperty("DEFAULT_FILE_FORMAT");
        final JalviewFileChooser chooser = JalviewFileChooser.forRead(Cache.getProperty("LAST_DIRECTORY"), fileFormat, BackupFiles.getEnabled());
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.open_local_file"));
        chooser.setToolTipText(MessageManager.getString("action.open"));
        chooser.setResponseHandler(0, new Runnable(){

            @Override
            public void run() {
                File selectedFile = chooser.getSelectedFile();
                Cache.setProperty("LAST_DIRECTORY", selectedFile.getParent());
                FileFormatI format = chooser.getSelectedFormat();
                Desktop.this.openFile(selectedFile, format, viewport);
            }
        });
        chooser.showOpenDialog(this);
    }

    public void openFile(File selectedFile, FileFormatI format, AlignViewport viewport) {
        if (FileFormats.getInstance().isIdentifiable(format)) {
            try {
                format = new IdentifyFile().identify(selectedFile, DataSourceType.FILE);
            }
            catch (FileFormatException fileFormatException) {
                // empty catch block
            }
        }
        new FileLoader().LoadFile(viewport, selectedFile, DataSourceType.FILE, format);
    }

    @Override
    public void inputURLMenuItem_actionPerformed(final AlignViewport viewport) {
        JComponent history;
        JLabel label = new JLabel(MessageManager.getString("label.input_file_url"));
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.add(label);
        String urlBase = "https://www.";
        if (Platform.isJS()) {
            history = new JTextField(urlBase, 35);
        } else {
            JComboBox<String> asCombo = new JComboBox<String>();
            asCombo.setPreferredSize(new Dimension(400, 20));
            asCombo.setEditable(true);
            asCombo.addItem(urlBase);
            String historyItems = Cache.getProperty("RECENT_URL");
            if (historyItems != null) {
                for (String token : historyItems.split("\\t")) {
                    asCombo.addItem(token);
                }
            }
            history = asCombo;
        }
        panel.add(history);
        Object[] options = new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")};
        Runnable action = new Runnable(){

            @Override
            public void run() {
                String url;
                String string = url = history instanceof JTextField ? ((JTextField)history).getText() : ((JComboBox)history).getEditor().getItem().toString().trim();
                if (!Desktop.this.loadUrl(url, viewport)) {
                    String msg = MessageManager.formatMessage("label.couldnt_locate", url);
                    JvOptionPane.showInternalMessageDialog((Component)desktop, msg, MessageManager.getString("label.url_not_found"), 2);
                }
            }
        };
        String dialogOption = MessageManager.getString("label.input_alignment_from_url");
        JvOptionPane.newOptionDialog(desktop).setResponseHandler(0, action).showInternalDialog(panel, dialogOption, 1, -1, null, options, MessageManager.getString("action.ok"));
    }

    public boolean loadUrl(String url, AlignViewport viewport) {
        FileFormatI format = null;
        try {
            format = new IdentifyFile().identify(url, DataSourceType.URL);
        }
        catch (FileFormatException fileFormatException) {
            // empty catch block
        }
        if (format == null) {
            return false;
        }
        if (viewport != null) {
            new FileLoader().LoadFile(viewport, url, DataSourceType.URL, format);
        } else {
            new FileLoader().LoadFile(url, DataSourceType.URL, format);
        }
        return true;
    }

    @Override
    public void inputTextboxMenuItem_actionPerformed(AlignmentViewPanel viewPanel) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        cap.setForInput(viewPanel);
        Desktop.addInternalFrame((JInternalFrame)cap, MessageManager.getString("label.cut_paste_alignmen_file"), true, 600, 500);
    }

    @Override
    public void quit() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Cache.setProperty("SCREENGEOMETRY_WIDTH", "" + screen.width);
        Cache.setProperty("SCREENGEOMETRY_HEIGHT", "" + screen.height);
        this.storeLastKnownDimensions("", new Rectangle(this.getBounds().x, this.getBounds().y, this.getWidth(), this.getHeight()));
        if (this.jconsole != null) {
            this.storeLastKnownDimensions("JAVA_CONSOLE_", this.jconsole.getBounds());
            this.jconsole.stopConsole();
        }
        if (this.jvnews != null) {
            this.storeLastKnownDimensions("JALVIEW_RSS_WINDOW_", this.jvnews.getBounds());
        }
        if (this.dialogExecutor != null) {
            this.dialogExecutor.shutdownNow();
        }
        this.closeAll_actionPerformed(null);
        if (groovyConsole != null) {
            groovyConsole.setDirty(false);
            groovyConsole.exit();
        }
        System.exit(0);
    }

    private void storeLastKnownDimensions(String string, Rectangle jc) {
        Cache.log.debug((Object)("Storing last known dimensions for " + string + ": x:" + jc.x + " y:" + jc.y + " width:" + jc.width + " height:" + jc.height));
        Cache.setProperty(string + "SCREEN_X", "" + jc.x);
        Cache.setProperty(string + "SCREEN_Y", "" + jc.y);
        Cache.setProperty(string + "SCREEN_WIDTH", "" + jc.width);
        Cache.setProperty(string + "SCREEN_HEIGHT", "" + jc.height);
    }

    @Override
    public void aboutMenuItem_actionPerformed(ActionEvent e) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                new SplashScreen(false);
            }
        }).start();
    }

    public String getAboutMessage() {
        StringBuilder message = new StringBuilder(1024);
        message.append("<div style=\"font-family: sans-serif;\">").append("<h1><strong>Version: ").append(Cache.getProperty("VERSION")).append("</strong></h1>").append("<strong>Built: <em>").append(Cache.getDefault("BUILD_DATE", "unknown")).append("</em> from ").append(Cache.getBuildDetailsForSplash()).append("</strong>");
        String latestVersion = Cache.getDefault("LATEST_VERSION", "Checking");
        if (!latestVersion.equals("Checking") && !latestVersion.equals(Cache.getProperty("VERSION"))) {
            boolean red = false;
            if (Cache.getProperty("VERSION").toLowerCase().indexOf("automated build") == -1) {
                red = true;
                message.append("<div style=\"color: #FF0000;font-style: bold;\">");
            }
            message.append("<br>!! Version ").append(Cache.getDefault("LATEST_VERSION", "..Checking..")).append(" is available for download from ").append(Cache.getDefault("www.jalview.org", "https://www.jalview.org")).append(" !!");
            if (red) {
                message.append("</div>");
            }
        }
        message.append("<br>Authors:  ");
        message.append(Cache.getDefault("AUTHORFNAMES", DEFAULT_AUTHORS));
        message.append(CITATION);
        message.append("</div>");
        return message.toString();
    }

    @Override
    public void documentationMenuItem_actionPerformed() {
        try {
            if (Platform.isJS()) {
                BrowserLauncher.openURL("https://www.jalview.org/help.html");
            } else {
                Help.showHelpWindow();
            }
        }
        catch (Exception ex) {
            System.err.println("Error opening help: " + ex.getMessage());
        }
    }

    @Override
    public void closeAll_actionPerformed(ActionEvent e) {
        JInternalFrame[] frames = desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setClosed(true);
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        Jalview.setCurrentAlignFrame(null);
        System.out.println("ALL CLOSED");
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(this);
        if (ssm != null) {
            ssm.resetAll();
        }
    }

    @Override
    public void raiseRelated_actionPerformed(ActionEvent e) {
        this.reorderAssociatedWindows(false, false);
    }

    @Override
    public void minimizeAssociated_actionPerformed(ActionEvent e) {
        this.reorderAssociatedWindows(true, false);
    }

    void closeAssociatedWindows() {
        this.reorderAssociatedWindows(false, true);
    }

    @Override
    protected void garbageCollect_actionPerformed(ActionEvent e) {
        Cache.log.debug((Object)"Collecting garbage...");
        System.gc();
        Cache.log.debug((Object)"Finished garbage collection.");
    }

    @Override
    protected void showMemusage_actionPerformed(ActionEvent e) {
        desktop.showMemoryUsage(this.showMemusage.isSelected());
    }

    @Override
    protected void showConsole_actionPerformed(ActionEvent e) {
        this.showConsole(this.showConsole.isSelected());
    }

    void showConsole(boolean selected) {
        if (this.jconsole != null) {
            this.showConsole.setSelected(selected);
            Cache.setProperty("SHOW_JAVA_CONSOLE", Boolean.valueOf(selected).toString());
            this.jconsole.setVisible(selected);
        }
    }

    void reorderAssociatedWindows(boolean minimize, boolean close) {
        JInternalFrame[] frames = desktop.getAllFrames();
        if (frames == null || frames.length < 1) {
            return;
        }
        AlignmentViewport source = null;
        AlignmentViewport target = null;
        if (frames[0] instanceof AlignFrame) {
            source = ((AlignFrame)frames[0]).getCurrentView();
        } else if (frames[0] instanceof TreePanel) {
            source = ((TreePanel)frames[0]).getViewPort();
        } else if (frames[0] instanceof PCAPanel) {
            source = ((PCAPanel)frames[0]).av;
        } else if (frames[0].getContentPane() instanceof PairwiseAlignPanel) {
            source = ((PairwiseAlignPanel)frames[0].getContentPane()).av;
        }
        if (source != null) {
            for (int i = 0; i < frames.length; ++i) {
                target = null;
                if (frames[i] == null) continue;
                if (frames[i] instanceof AlignFrame) {
                    target = ((AlignFrame)frames[i]).getCurrentView();
                } else if (frames[i] instanceof TreePanel) {
                    target = ((TreePanel)frames[i]).getViewPort();
                } else if (frames[i] instanceof PCAPanel) {
                    target = ((PCAPanel)frames[i]).av;
                } else if (frames[i].getContentPane() instanceof PairwiseAlignPanel) {
                    target = ((PairwiseAlignPanel)frames[i].getContentPane()).av;
                }
                if (source != target) continue;
                try {
                    if (close) {
                        frames[i].setClosed(true);
                        continue;
                    }
                    frames[i].setIcon(minimize);
                    if (minimize) continue;
                    frames[i].toFront();
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void preferences_actionPerformed(ActionEvent e) {
        Preferences.openPreferences();
    }

    @Override
    public void saveState_actionPerformed() {
        this.saveState_actionPerformed(false);
    }

    public void saveState_actionPerformed(boolean saveAs) {
        File projectFile = this.getProjectFile();
        boolean autoSave = projectFile != null && !saveAs && BackupFiles.getEnabled();
        boolean approveSave = false;
        if (!autoSave) {
            JalviewFileChooser chooser = new JalviewFileChooser("jvp", "Jalview Project");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle(MessageManager.getString("label.save_state"));
            int value = chooser.showSaveDialog(this);
            if (value == 0) {
                projectFile = chooser.getSelectedFile();
                this.setProjectFile(projectFile);
                approveSave = true;
            }
        }
        if (approveSave || autoSave) {
            final Desktop me = this;
            final File chosenFile = projectFile;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.setProgressBar(MessageManager.formatMessage("label.saving_jalview_project", chosenFile.getName()), chosenFile.hashCode());
                    Cache.setProperty("LAST_DIRECTORY", chosenFile.getParent());
                    try {
                        boolean doBackup = BackupFiles.getEnabled();
                        BackupFiles backupfiles = doBackup ? new BackupFiles(chosenFile) : null;
                        new Jalview2XML().saveState(doBackup ? backupfiles.getTempFile() : chosenFile);
                        if (doBackup) {
                            backupfiles.setWriteSuccess(true);
                            backupfiles.rollBackupsAndRenameTempFile();
                        }
                    }
                    catch (OutOfMemoryError oom) {
                        new OOMWarning("Whilst saving current state to " + chosenFile.getName(), oom);
                    }
                    catch (Exception ex) {
                        Cache.log.error((Object)("Problems whilst trying to save to " + chosenFile.getName()), (Throwable)ex);
                        JvOptionPane.showMessageDialog((Component)me, MessageManager.formatMessage("label.error_whilst_saving_current_state_to", chosenFile.getName()), MessageManager.getString("label.couldnt_save_project"), 2);
                    }
                    Desktop.this.setProgressBar(null, chosenFile.hashCode());
                }
            }).start();
        }
    }

    @Override
    public void saveAsState_actionPerformed(ActionEvent e) {
        this.saveState_actionPerformed(true);
    }

    private void setProjectFile(File choice) {
        this.projectFile = choice;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    @Override
    public void loadState_actionPerformed() {
        String[] suffix = new String[]{"jvp", "jar"};
        String[] desc = new String[]{"Jalview Project", "Jalview Project (old)"};
        final JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), suffix, desc, "Jalview Project", true, BackupFiles.getEnabled());
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.restore_state"));
        chooser.setResponseHandler(0, new Runnable(){

            @Override
            public void run() {
                final File selectedFile = chooser.getSelectedFile();
                Desktop.this.setProjectFile(selectedFile);
                final String choice = selectedFile.getAbsolutePath();
                Cache.setProperty("LAST_DIRECTORY", selectedFile.getParent());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new Jalview2XML().loadJalviewAlign(selectedFile);
                        }
                        catch (OutOfMemoryError oom) {
                            new OOMWarning("Whilst loading project from " + choice, oom);
                        }
                        catch (Exception ex) {
                            Cache.log.error((Object)("Problems whilst loading project from " + choice), (Throwable)ex);
                            JvOptionPane.showMessageDialog((Component)desktop, MessageManager.formatMessage("label.error_whilst_loading_project_from", choice), MessageManager.getString("label.couldnt_load_project"), 2);
                        }
                    }
                }, "Project Loader").start();
            }
        });
        chooser.showOpenDialog(this);
    }

    @Override
    public void inputSequence_actionPerformed(ActionEvent e) {
        new SequenceFetcher(this);
    }

    public void startLoading(Object fileName) {
        if (fileLoadingCount == 0) {
            this.fileLoadingPanels.add(this.addProgressPanel(MessageManager.formatMessage("label.loading_file", fileName)));
        }
        ++fileLoadingCount;
    }

    private JPanel addProgressPanel(String string) {
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel(new GridLayout(1, 1));
            this.totalProgressCount = 0;
            instance.getContentPane().add((Component)this.progressPanel, "South");
        }
        JPanel thisprogress = new JPanel(new BorderLayout(10, 5));
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        thisprogress.add((Component)new JLabel(string), "West");
        thisprogress.add((Component)progressBar, "Center");
        this.progressPanel.add(thisprogress);
        ((GridLayout)this.progressPanel.getLayout()).setRows(((GridLayout)this.progressPanel.getLayout()).getRows() + 1);
        ++this.totalProgressCount;
        instance.validate();
        return thisprogress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgressPanel(JPanel progbar) {
        if (this.progressPanel != null) {
            JPanel jPanel = this.progressPanel;
            synchronized (jPanel) {
                this.progressPanel.remove(progbar);
                GridLayout gl = (GridLayout)this.progressPanel.getLayout();
                gl.setRows(gl.getRows() - 1);
                if (--this.totalProgressCount < 1) {
                    this.getContentPane().remove(this.progressPanel);
                    this.progressPanel = null;
                }
            }
        }
        this.validate();
    }

    public void stopLoading() {
        if (--fileLoadingCount < 1) {
            while (this.fileLoadingPanels.size() > 0) {
                this.removeProgressPanel(this.fileLoadingPanels.remove(0));
            }
            this.fileLoadingPanels.clear();
            fileLoadingCount = 0;
        }
        this.validate();
    }

    public static int getViewCount(String alignmentId) {
        AlignmentViewport[] aps = Desktop.getViewports(alignmentId);
        return aps == null ? 0 : aps.length;
    }

    public static AlignmentPanel[] getAlignmentPanels(String alignmentId) {
        if (desktop == null) {
            return null;
        }
        ArrayList<AlignmentPanel> aps = new ArrayList<AlignmentPanel>();
        AlignFrame[] frames = Desktop.getAlignFrames();
        if (frames == null) {
            return null;
        }
        for (AlignFrame af : frames) {
            for (AlignmentPanel ap : af.alignPanels) {
                if (alignmentId != null && !alignmentId.equals(ap.av.getSequenceSetId())) continue;
                aps.add(ap);
            }
        }
        if (aps.size() == 0) {
            return null;
        }
        AlignmentPanel[] vap = aps.toArray(new AlignmentPanel[aps.size()]);
        return vap;
    }

    public static AlignmentViewport[] getViewports(String sequenceSetId) {
        ArrayList<AlignViewport> viewp = new ArrayList<AlignViewport>();
        if (desktop != null) {
            AlignFrame[] frames;
            for (AlignFrame afr : frames = Desktop.getAlignFrames()) {
                if (sequenceSetId != null && !afr.getViewport().getSequenceSetId().equals(sequenceSetId)) continue;
                if (afr.alignPanels != null) {
                    for (AlignmentPanel ap : afr.alignPanels) {
                        if (sequenceSetId != null && !sequenceSetId.equals(ap.av.getSequenceSetId())) continue;
                        viewp.add(ap.av);
                    }
                    continue;
                }
                viewp.add(afr.getViewport());
            }
            if (viewp.size() > 0) {
                return viewp.toArray(new AlignmentViewport[viewp.size()]);
            }
        }
        return null;
    }

    public static void explodeViews(AlignFrame af) {
        int size = af.alignPanels.size();
        if (size < 2) {
            return;
        }
        FeatureSettings viewFeatureSettings = af.featureSettings != null && af.featureSettings.isOpen() ? af.featureSettings : null;
        Rectangle fsBounds = af.getFeatureSettingsGeometry();
        for (int i = 0; i < size; ++i) {
            Rectangle geometry;
            AlignmentPanel ap = af.alignPanels.get(i);
            AlignFrame newaf = new AlignFrame(ap);
            if (ap == af.alignPanel) {
                if (viewFeatureSettings != null && viewFeatureSettings.fr.ap == ap) {
                    newaf.featureSettings = viewFeatureSettings;
                }
                newaf.setFeatureSettingsGeometry(fsBounds);
            }
            if ((geometry = ap.av.getExplodedGeometry()) != null) {
                newaf.setBounds(geometry);
            }
            ap.av.setGatherViewsHere(false);
            Desktop.addInternalFrame(newaf, af.getTitle(), 700, 500);
            if (ap != af.alignPanel || newaf.featureSettings == null || !newaf.featureSettings.isOpen() || !af.alignPanel.getAlignViewport().isShowSequenceFeatures()) continue;
            newaf.showFeatureSettingsUI();
        }
        af.featureSettings = null;
        af.alignPanels.clear();
        af.closeMenuItem_actionPerformed(true);
    }

    public void gatherViews(AlignFrame source) {
        source.viewport.setGatherViewsHere(true);
        source.viewport.setExplodedGeometry(source.getBounds());
        JInternalFrame[] frames = desktop.getAllFrames();
        String viewId = source.viewport.getSequenceSetId();
        for (int t = 0; t < frames.length; ++t) {
            if (!(frames[t] instanceof AlignFrame) || frames[t] == source) continue;
            AlignFrame af = (AlignFrame)frames[t];
            boolean gatherThis = false;
            for (int a = 0; a < af.alignPanels.size(); ++a) {
                AlignmentPanel ap = af.alignPanels.get(a);
                if (!viewId.equals(ap.av.getSequenceSetId())) continue;
                gatherThis = true;
                ap.av.setGatherViewsHere(false);
                ap.av.setExplodedGeometry(af.getBounds());
                source.addAlignmentPanel(ap, false);
            }
            if (!gatherThis) continue;
            if (af.featureSettings != null && af.featureSettings.isOpen()) {
                if (source.featureSettings == null) {
                    source.featureSettings = af.featureSettings;
                    source.setFeatureSettingsGeometry(af.getFeatureSettingsGeometry());
                } else {
                    af.featureSettings.close();
                }
            }
            af.alignPanels.clear();
            af.closeMenuItem_actionPerformed(true);
        }
        if (source.featureSettings != null && source.featureSettings.isOpen()) {
            source.showFeatureSettingsUI();
        }
    }

    public JInternalFrame[] getAllFrames() {
        return desktop.getAllFrames();
    }

    public void checkForQuestionnaire(String url) {
        UserQuestionnaireCheck jvq = new UserQuestionnaireCheck(url);
        new Thread(jvq).start();
    }

    public void checkURLLinks() {
        this.addDialogThread(new Runnable(){

            @Override
            public void run() {
                if (Cache.getDefault("CHECKURLLINKS", true)) {
                    List<String> links = Preferences.sequenceUrlLinks.getLinksForMenu();
                    ListIterator<String> li = links.listIterator();
                    boolean check = false;
                    ArrayList<JLabel> urls = new ArrayList<JLabel>();
                    while (li.hasNext()) {
                        String link = li.next();
                        if (!link.contains("SEQUENCE_ID") || UrlConstants.isDefaultString(link)) continue;
                        check = true;
                        int barPos = link.indexOf("|");
                        String urlMsg = barPos == -1 ? link : link.substring(0, barPos) + ": " + link.substring(barPos + 1);
                        urls.add(new JLabel(urlMsg));
                    }
                    if (!check) {
                        return;
                    }
                    JPanel msgPanel = new JPanel();
                    msgPanel.setLayout(new BoxLayout(msgPanel, 3));
                    msgPanel.add(Box.createVerticalGlue());
                    JLabel msg = new JLabel(MessageManager.getString("label.SEQUENCE_ID_for_DB_ACCESSION1"));
                    JLabel msg2 = new JLabel(MessageManager.getString("label.SEQUENCE_ID_for_DB_ACCESSION2"));
                    msgPanel.add(msg);
                    for (JLabel url : urls) {
                        msgPanel.add(url);
                    }
                    msgPanel.add(msg2);
                    final JCheckBox jcb = new JCheckBox(MessageManager.getString("label.do_not_display_again"));
                    jcb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean showWarningAgain = !jcb.isSelected();
                            Cache.setProperty("CHECKURLLINKS", Boolean.valueOf(showWarningAgain).toString());
                        }
                    });
                    msgPanel.add(jcb);
                    JvOptionPane.showMessageDialog(desktop, msgPanel, MessageManager.getString("label.SEQUENCE_ID_no_longer_used"), 2);
                }
            }
        });
    }

    public static AlignFrame[] getAlignFrames() {
        if (Jalview.isHeadlessMode()) {
            return new AlignFrame[]{Jalview.currentAlignFrame};
        }
        JInternalFrame[] frames = desktop.getAllFrames();
        if (frames == null) {
            return null;
        }
        ArrayList<AlignFrame> avp = new ArrayList<AlignFrame>();
        for (int i = frames.length - 1; i > -1; --i) {
            if (frames[i] instanceof AlignFrame) {
                avp.add((AlignFrame)frames[i]);
                continue;
            }
            if (!(frames[i] instanceof SplitFrame)) continue;
            GSplitFrame sf = (GSplitFrame)frames[i];
            if (sf.getTopFrame() instanceof AlignFrame) {
                avp.add((AlignFrame)sf.getTopFrame());
            }
            if (!(sf.getBottomFrame() instanceof AlignFrame)) continue;
            avp.add((AlignFrame)sf.getBottomFrame());
        }
        if (avp.size() == 0) {
            return null;
        }
        AlignFrame[] afs = avp.toArray(new AlignFrame[avp.size()]);
        return afs;
    }

    public GStructureViewer[] getJmols() {
        JInternalFrame[] frames = desktop.getAllFrames();
        if (frames == null) {
            return null;
        }
        ArrayList<GStructureViewer> avp = new ArrayList<GStructureViewer>();
        for (int i = frames.length - 1; i > -1; --i) {
            if (!(frames[i] instanceof AppJmol)) continue;
            GStructureViewer af = (GStructureViewer)frames[i];
            avp.add(af);
        }
        if (avp.size() == 0) {
            return null;
        }
        GStructureViewer[] afs = avp.toArray(new GStructureViewer[avp.size()]);
        return afs;
    }

    @Override
    public void groovyShell_actionPerformed() {
        try {
            this.openGroovyConsole();
        }
        catch (Exception ex) {
            Cache.log.error((Object)"Groovy Shell Creation failed.", (Throwable)ex);
            JvOptionPane.showInternalMessageDialog((Component)desktop, MessageManager.getString("label.couldnt_create_groovy_shell"), MessageManager.getString("label.groovy_support_failed"), 0);
        }
    }

    void openGroovyConsole() {
        if (groovyConsole == null) {
            groovyConsole = new groovy.ui.Console();
            groovyConsole.setVariable("Jalview", (Object)this);
            groovyConsole.run();
            Window window = (Window)((Object)groovyConsole.getFrame());
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Desktop.this.addQuitHandler();
                    Desktop.this.enableExecuteGroovy(false);
                }
            });
        }
        ((Window)((Object)groovyConsole.getFrame())).setVisible(true);
        this.enableExecuteGroovy(true);
    }

    protected void addQuitHandler() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(81, ShortcutKeyMaskExWrapper.getMenuShortcutKeyMaskEx()), "Quit");
        this.getRootPane().getActionMap().put("Quit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this.quit();
            }
        });
    }

    public void enableExecuteGroovy(boolean enabled) {
        this.groovyShell.setEnabled(!enabled);
        AlignFrame[] alignFrames = Desktop.getAlignFrames();
        if (alignFrames != null) {
            for (AlignFrame af : alignFrames) {
                af.setGroovyEnabled(enabled);
            }
        }
    }

    @Override
    public void setProgressBar(String message, long id) {
        if (this.progressBars == null) {
            this.progressBars = new Hashtable();
            this.progressBarHandlers = new Hashtable();
        }
        if (this.progressBars.get(id) != null) {
            JPanel panel = this.progressBars.remove(id);
            if (this.progressBarHandlers.contains(id)) {
                this.progressBarHandlers.remove(id);
            }
            this.removeProgressPanel(panel);
        } else {
            this.progressBars.put(id, this.addProgressPanel(message));
        }
    }

    @Override
    public void registerHandler(final long id, final IProgressIndicatorHandler handler) {
        if (this.progressBarHandlers == null || !this.progressBars.containsKey(id)) {
            throw new Error(MessageManager.getString("error.call_setprogressbar_before_registering_handler"));
        }
        this.progressBarHandlers.put(id, handler);
        final JPanel progressPanel = this.progressBars.get(id);
        if (handler.canCancel()) {
            JButton cancel = new JButton(MessageManager.getString("action.cancel"));
            final Desktop us = this;
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    handler.cancelActivity(id);
                    us.setProgressBar(MessageManager.formatMessage("label.cancelled_params", ((JLabel)progressPanel.getComponent(0)).getText()), id);
                }
            });
            progressPanel.add((Component)cancel, "East");
        }
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBars != null && this.progressBars.size() > 0;
    }

    public static AlignFrame getAlignFrameFor(AlignViewportI viewport) {
        if (desktop != null) {
            AlignmentPanel[] aps = Desktop.getAlignmentPanels(viewport.getSequenceSetId());
            for (int panel = 0; aps != null && panel < aps.length; ++panel) {
                if (aps[panel] == null || aps[panel].av != viewport) continue;
                return aps[panel].alignFrame;
            }
        }
        return null;
    }

    public VamsasApplication getVamsasApplication() {
        return null;
    }

    public boolean isInBatchMode() {
        return this.inBatchMode;
    }

    public void setInBatchMode(boolean inBatchMode) {
        this.inBatchMode = inBatchMode;
    }

    public void startServiceDiscovery() {
        this.startServiceDiscovery(false);
    }

    public void startServiceDiscovery(boolean blocking) {
        boolean alive = true;
        Thread t0 = null;
        Thread t1 = null;
        Thread t2 = null;
        if (discoverer == null) {
            discoverer = new Discoverer();
            discoverer.addPropertyChangeListener(this.changeSupport);
        }
        t0 = new Thread(discoverer);
        t0.start();
        if (Cache.getDefault("SHOW_JWS2_SERVICES", true)) {
            t2 = Jws2Discoverer.getDiscoverer().startDiscoverer(this.changeSupport);
        }
        Thread t3 = null;
        if (blocking) {
            while (alive) {
                try {
                    Thread.sleep(15L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                alive = t1 != null && t1.isAlive() || t2 != null && t2.isAlive() || t3 != null && t3.isAlive() || t0 != null && t0.isAlive();
            }
        }
    }

    protected void JalviewServicesChanged(PropertyChangeEvent evt) {
        String ermsg;
        if ((evt.getNewValue() == null || evt.getNewValue() instanceof Vector) && (ermsg = Jws2Discoverer.getDiscoverer().getErrorMessages()) != null) {
            if (Cache.getDefault("SHOW_WSDISCOVERY_ERRORS", true)) {
                if (this.serviceChangedDialog == null) {
                    this.serviceChangedDialog = new Runnable(){

                        @Override
                        public void run() {
                            JvOptionPane.showConfirmDialog(desktop, new JLabel("<html><table width=\"450\"><tr><td>" + ermsg + "</td></tr></table><p>It may be that you have invalid JABA URLs<br/>in your web service preferences,<br>or as a command-line argument, or mis-configured HTTP proxy settings.</p><p>Check the <em>Connections</em> and <em>Web services</em> tab<br/>of the Tools->Preferences dialog box to change them.</p></html>"), "Web Service Configuration Problem", -1, 0);
                            Desktop.this.serviceChangedDialog = null;
                        }
                    };
                    this.addDialogThread(this.serviceChangedDialog);
                }
            } else {
                Cache.log.error((Object)("Errors reported by JABA discovery service. Check web services preferences.\n" + ermsg));
            }
        }
    }

    public static void showUrl(String url) {
        Desktop.showUrl(url, instance);
    }

    public static void showUrl(final String url, final IProgressIndicator progress) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (progress != null) {
                        progress.setProgressBar(MessageManager.formatMessage("status.opening_params", url), this.hashCode());
                    }
                    BrowserLauncher.openURL(url);
                }
                catch (Exception ex) {
                    JvOptionPane.showInternalMessageDialog((Component)desktop, MessageManager.getString("label.web_browser_not_found_unix"), MessageManager.getString("label.web_browser_not_found"), 2);
                    ex.printStackTrace();
                }
                if (progress != null) {
                    progress.setProgressBar(null, this.hashCode());
                }
            }
        }).start();
    }

    public static ParamManager getUserParameterStore() {
        if (wsparamManager == null) {
            wsparamManager = new WsParamSetManager();
        }
        return wsparamManager;
    }

    public static void hyperlinkUpdate(HyperlinkEvent e) {
        block4: {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = null;
                try {
                    url = e.getURL().toString();
                    Desktop.showUrl(url);
                }
                catch (Exception x) {
                    if (url == null) break block4;
                    if (Cache.log != null) {
                        Cache.log.error((Object)("Couldn't handle string " + url + " as a URL."));
                    }
                    System.err.println("Couldn't handle string " + url + " as a URL.");
                }
            }
        }
    }

    public void addDialogThread(final Runnable prompter) {
        this.dialogExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (Desktop.this.dialogPause) {
                    try {
                        Desktop.this.block.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (instance == null) {
                    return;
                }
                try {
                    SwingUtilities.invokeAndWait(prompter);
                }
                catch (Exception q) {
                    Cache.log.warn((Object)"Unexpected Exception in dialog thread.", (Throwable)q);
                }
            }
        });
    }

    public void startDialogQueue() {
        this.dialogPause = false;
        this.block.release();
    }

    @Override
    protected void snapShotWindow_actionPerformed(ActionEvent e) {
        this.invalidate();
        int width = this.getWidth();
        int height = this.getHeight();
        final File of = new File("Jalview_snapshot_" + System.currentTimeMillis() + ".eps");
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics g) throws Exception {
                Desktop.this.paintAll(g);
                Cache.log.info((Object)("Successfully written snapshot to file " + of.getAbsolutePath()));
            }
        };
        String title = "View of desktop";
        ImageExporter exporter = new ImageExporter(writer, null, ImageMaker.TYPE.EPS, title);
        exporter.doExport(of, this, width, height, title);
    }

    public void explodeViews(SplitFrame sf) {
        AlignFrame oldTopFrame = (AlignFrame)sf.getTopFrame();
        AlignFrame oldBottomFrame = (AlignFrame)sf.getBottomFrame();
        List<? extends AlignmentViewPanel> topPanels = oldTopFrame.getAlignPanels();
        List<? extends AlignmentViewPanel> bottomPanels = oldBottomFrame.getAlignPanels();
        int viewCount = topPanels.size();
        if (viewCount < 2) {
            return;
        }
        for (int i = viewCount - 1; i >= 0; --i) {
            AlignmentPanel topPanel = (AlignmentPanel)topPanels.get(i);
            AlignFrame newTopFrame = new AlignFrame(topPanel);
            newTopFrame.setSize(oldTopFrame.getSize());
            newTopFrame.setVisible(true);
            Rectangle geometry = ((AlignViewport)topPanel.getAlignViewport()).getExplodedGeometry();
            if (geometry != null) {
                newTopFrame.setSize(geometry.getSize());
            }
            AlignmentPanel bottomPanel = (AlignmentPanel)bottomPanels.get(i);
            AlignFrame newBottomFrame = new AlignFrame(bottomPanel);
            newBottomFrame.setSize(oldBottomFrame.getSize());
            newBottomFrame.setVisible(true);
            geometry = ((AlignViewport)bottomPanel.getAlignViewport()).getExplodedGeometry();
            if (geometry != null) {
                newBottomFrame.setSize(geometry.getSize());
            }
            topPanel.av.setGatherViewsHere(false);
            bottomPanel.av.setGatherViewsHere(false);
            SplitFrame splitFrame = new SplitFrame(newTopFrame, newBottomFrame);
            if (geometry != null) {
                splitFrame.setLocation(geometry.getLocation());
            }
            Desktop.addInternalFrame(splitFrame, sf.getTitle(), -1, -1);
        }
        topPanels.clear();
        bottomPanels.clear();
        sf.close();
    }

    public void gatherViews(GSplitFrame source) {
        JInternalFrame[] frames;
        AlignFrame myTopFrame = (AlignFrame)source.getTopFrame();
        AlignFrame myBottomFrame = (AlignFrame)source.getBottomFrame();
        myTopFrame.viewport.setExplodedGeometry(new Rectangle(source.getX(), source.getY(), myTopFrame.getWidth(), myTopFrame.getHeight()));
        myBottomFrame.viewport.setExplodedGeometry(new Rectangle(source.getX(), source.getY(), myBottomFrame.getWidth(), myBottomFrame.getHeight()));
        myTopFrame.viewport.setGatherViewsHere(true);
        myBottomFrame.viewport.setGatherViewsHere(true);
        String topViewId = myTopFrame.viewport.getSequenceSetId();
        String bottomViewId = myBottomFrame.viewport.getSequenceSetId();
        for (JInternalFrame frame : frames = desktop.getAllFrames()) {
            if (!(frame instanceof SplitFrame) || frame == source) continue;
            SplitFrame sf = (SplitFrame)frame;
            AlignFrame topFrame = (AlignFrame)sf.getTopFrame();
            AlignFrame bottomFrame = (AlignFrame)sf.getBottomFrame();
            boolean gatherThis = false;
            for (int a = 0; a < topFrame.alignPanels.size(); ++a) {
                AlignmentPanel topPanel = topFrame.alignPanels.get(a);
                AlignmentPanel bottomPanel = bottomFrame.alignPanels.get(a);
                if (!topViewId.equals(topPanel.av.getSequenceSetId()) || !bottomViewId.equals(bottomPanel.av.getSequenceSetId())) continue;
                gatherThis = true;
                topPanel.av.setGatherViewsHere(false);
                bottomPanel.av.setGatherViewsHere(false);
                topPanel.av.setExplodedGeometry(new Rectangle(sf.getLocation(), topFrame.getSize()));
                bottomPanel.av.setExplodedGeometry(new Rectangle(sf.getLocation(), bottomFrame.getSize()));
                myTopFrame.addAlignmentPanel(topPanel, false);
                myBottomFrame.addAlignmentPanel(bottomPanel, false);
            }
            if (!gatherThis) continue;
            topFrame.getAlignPanels().clear();
            bottomFrame.getAlignPanels().clear();
            sf.close();
        }
        myTopFrame.setDisplayedView(myTopFrame.alignPanel);
    }

    public static groovy.ui.Console getGroovyConsole() {
        return groovyConsole;
    }

    public static void transferFromDropTarget(List<Object> files, List<DataSourceType> protocols, DropTargetDropEvent evt, Transferable t) throws Exception {
        DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        DataFlavor urlFlavour = null;
        try {
            urlFlavour = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException cfe) {
            Cache.log.debug((Object)"Couldn't instantiate the URL dataflavor.", (Throwable)cfe);
        }
        if (urlFlavour != null && t.isDataFlavorSupported(urlFlavour)) {
            try {
                URL url = (URL)t.getTransferData(urlFlavour);
                if (url != null) {
                    protocols.add(DataSourceType.URL);
                    files.add(url.toString());
                    Cache.log.debug((Object)("Drop handled as URL dataflavor " + files.get(files.size() - 1)));
                    return;
                }
                if (Platform.isAMacAndNotJS()) {
                    System.err.println("Please ignore plist error - occurs due to problem with java 8 on OSX");
                }
            }
            catch (Throwable ex) {
                Cache.log.debug((Object)"URL drop handler failed.", ex);
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Cache.log.debug((Object)"Drop handled as javaFileListFlavor");
            for (Object file : (List)t.getTransferData(DataFlavor.javaFileListFlavor)) {
                files.add(file);
                protocols.add(DataSourceType.FILE);
            }
        } else {
            boolean added = false;
            String data = null;
            if (t.isDataFlavorSupported(uriListFlavor)) {
                Cache.log.debug((Object)"Drop handled as uriListFlavor");
                data = (String)t.getTransferData(uriListFlavor);
            }
            if (data == null) {
                Cache.log.debug((Object)"standard URIListFlavor failed. Trying text");
                DataFlavor textDf = new DataFlavor("text/plain;class=java.lang.String");
                if (t.isDataFlavorSupported(textDf)) {
                    data = (String)t.getTransferData(textDf);
                }
                Cache.log.debug((Object)("Plain text drop content returned " + (data == null ? "Null - failed" : data)));
            }
            if (data != null) {
                while (protocols.size() < files.size()) {
                    Cache.log.debug((Object)("Adding missing FILE protocol for " + files.get(protocols.size())));
                    protocols.add(DataSourceType.FILE);
                }
                DataFlavor[] st = new StringTokenizer(data, "\r\n");
                while (st.hasMoreTokens()) {
                    added = true;
                    String s = st.nextToken();
                    if (s.startsWith("#")) continue;
                    URI uri = new URI(s);
                    if (uri.getScheme().toLowerCase().startsWith("http")) {
                        protocols.add(DataSourceType.URL);
                        files.add(uri.toString());
                        continue;
                    }
                    File file = new File(uri);
                    protocols.add(DataSourceType.FILE);
                    files.add(file.toString());
                }
            }
            if (Cache.log.isDebugEnabled() && (data == null || !added)) {
                if (t.getTransferDataFlavors() != null && t.getTransferDataFlavors().length > 0) {
                    Cache.log.debug((Object)"Couldn't resolve drop data. Here are the supported flavors:");
                    for (DataFlavor fl : t.getTransferDataFlavors()) {
                        Cache.log.debug((Object)("Supported transfer dataflavor: " + fl.toString()));
                        Object df = t.getTransferData(fl);
                        if (df != null) {
                            Cache.log.debug((Object)("Retrieves: " + df));
                            continue;
                        }
                        Cache.log.debug((Object)"Retrieved nothing");
                    }
                } else {
                    Cache.log.debug((Object)("Couldn't resolve dataflavor for drop: " + t.toString()));
                }
            }
        }
        if (Platform.isWindowsAndNotJS()) {
            Cache.log.debug((Object)"Scanning dropped content for Windows Link Files");
            for (int f = 0; f < files.size(); ++f) {
                String source = files.get(f).toString().toLowerCase();
                if (!protocols.get(f).equals((Object)DataSourceType.FILE) || !source.endsWith(".lnk") && !source.endsWith(".url") && !source.endsWith(".site")) continue;
                try {
                    Object obj = files.get(f);
                    File lf = obj instanceof File ? (File)obj : new File((String)obj);
                    Cache.log.debug((Object)("Found potential link file: " + lf));
                    WindowsShortcut wscfile = new WindowsShortcut(lf);
                    String fullname = wscfile.getRealFilename();
                    protocols.set(f, FormatAdapter.checkProtocol(fullname));
                    files.set(f, fullname);
                    Cache.log.debug((Object)("Parsed real filename " + fullname + " to extract protocol: " + (Object)((Object)protocols.get(f))));
                    continue;
                }
                catch (Exception ex) {
                    Cache.log.error((Object)("Couldn't parse " + files.get(f) + " as a link file."), (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected void showExperimental_actionPerformed(boolean selected) {
        Cache.setProperty(EXPERIMENTAL_FEATURES, Boolean.toString(selected));
    }

    public List<StructureViewerBase> getStructureViewers(AlignmentPanel apanel, Class<? extends StructureViewerBase> structureViewerClass) {
        JInternalFrame[] frames;
        ArrayList<StructureViewerBase> result = new ArrayList<StructureViewerBase>();
        for (JInternalFrame frame : frames = instance.getAllFrames()) {
            if (!(frame instanceof StructureViewerBase) || structureViewerClass != null && !structureViewerClass.isInstance(frame) || apanel != null && !((StructureViewerBase)frame).isLinkedWith(apanel)) continue;
            result.add((StructureViewerBase)frame);
        }
        return result;
    }

    public static void debugScaleMessage(Graphics g) {
        if (debugScaleMessageDone) {
            return;
        }
        try {
            Graphics2D gg = (Graphics2D)g;
            if (gg != null) {
                AffineTransform t = gg.getTransform();
                double scaleX = t.getScaleX();
                double scaleY = t.getScaleY();
                Cache.debug(debugScaleMessage + scaleX + " (X)");
                Cache.debug(debugScaleMessage + scaleY + " (Y)");
                debugScaleMessageDone = true;
            } else {
                Cache.debug("Desktop graphics null");
            }
        }
        catch (Exception e) {
            Cache.debug(Cache.getStackTraceString(e));
        }
    }

    static {
        URL bg_logo_url = ChannelProperties.getImageURL("bg_logo." + String.valueOf(SplashScreen.logoSize));
        URL uod_logo_url = ChannelProperties.getImageURL("uod_banner." + String.valueOf(SplashScreen.logoSize));
        boolean logo = bg_logo_url != null || uod_logo_url != null;
        StringBuilder sb = new StringBuilder();
        sb.append("<br><br>Development managed by The Barton Group, University of Dundee, Scotland, UK.");
        if (logo) {
            sb.append("<br>");
        }
        sb.append((String)(bg_logo_url == null ? "" : "<img alt=\"Barton Group logo\" src=\"" + bg_logo_url.toString() + "\">"));
        sb.append((String)(uod_logo_url == null ? "" : "&nbsp;<img alt=\"University of Dundee shield\" src=\"" + uod_logo_url.toString() + "\">"));
        sb.append("<br><br>For help, see the FAQ at <a href=\"https://www.jalview.org/faq\">www.jalview.org/faq</a> and/or join the jalview-discuss@jalview.org mailing list");
        sb.append("<br><br>If  you use Jalview, please cite:<br>Waterhouse, A.M., Procter, J.B., Martin, D.M.A, Clamp, M. and Barton, G. J. (2009)<br>Jalview Version 2 - a multiple sequence alignment editor and analysis workbench<br>Bioinformatics doi: 10.1093/bioinformatics/btp033");
        CITATION = sb.toString();
        DEFAULT_MIN_WIDTH = 300;
        DEFAULT_MIN_HEIGHT = 250;
        ALIGN_FRAME_DEFAULT_MIN_WIDTH = 600;
        ALIGN_FRAME_DEFAULT_MIN_HEIGHT = 70;
        savingFiles = new HashMap();
        nosplash = false;
        openFrameCount = 0;
        internalCopy = false;
        fileLoadingCount = 0;
        wsparamManager = null;
        debugScaleMessageDone = false;
    }

    public class MyDesktopPane
    extends JDesktopPane
    implements Runnable {
        private static final float ONE_MB = 1048576.0f;
        boolean showMemoryUsage = false;
        Runtime runtime;
        NumberFormat df;
        float maxMemory;
        float allocatedMemory;
        float freeMemory;
        float totalFreeMemory;
        float percentUsage;

        public MyDesktopPane(boolean showMemoryUsage) {
            this.showMemoryUsage(showMemoryUsage);
        }

        public void showMemoryUsage(boolean showMemory) {
            this.showMemoryUsage = showMemory;
            if (showMemory) {
                Thread worker = new Thread(this);
                worker.start();
            }
            this.repaint();
        }

        public boolean isShowMemoryUsage() {
            return this.showMemoryUsage;
        }

        @Override
        public void run() {
            this.df = NumberFormat.getNumberInstance();
            this.df.setMaximumFractionDigits(2);
            this.runtime = Runtime.getRuntime();
            while (this.showMemoryUsage) {
                try {
                    this.maxMemory = (float)this.runtime.maxMemory() / 1048576.0f;
                    this.allocatedMemory = (float)this.runtime.totalMemory() / 1048576.0f;
                    this.freeMemory = (float)this.runtime.freeMemory() / 1048576.0f;
                    this.totalFreeMemory = this.freeMemory + (this.maxMemory - this.allocatedMemory);
                    this.percentUsage = this.totalFreeMemory / this.maxMemory * 100.0f;
                    this.repaint();
                    Thread.sleep(3000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.showMemoryUsage && g != null && this.df != null) {
                FontMetrics fm;
                if (this.percentUsage < 20.0f) {
                    g.setColor(Color.red);
                }
                if ((fm = g.getFontMetrics()) != null) {
                    g.drawString(MessageManager.formatMessage("label.memory_stats", this.df.format(this.totalFreeMemory), this.df.format(this.maxMemory), this.df.format(this.percentUsage)), 10, this.getHeight() - fm.getHeight());
                }
            }
            Desktop.debugScaleMessage(Desktop.getDesktop().getGraphics());
        }
    }

    class MyDesktopManager
    implements DesktopManager {
        private DesktopManager delegate;

        public MyDesktopManager(DesktopManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void activateFrame(JInternalFrame f) {
            try {
                this.delegate.activateFrame(f);
            }
            catch (NullPointerException npe) {
                Point p = Desktop.this.getMousePosition();
                instance.showPasteMenu(p.x, p.y);
            }
        }

        @Override
        public void beginDraggingFrame(JComponent f) {
            this.delegate.beginDraggingFrame(f);
        }

        @Override
        public void beginResizingFrame(JComponent f, int direction) {
            this.delegate.beginResizingFrame(f, direction);
        }

        @Override
        public void closeFrame(JInternalFrame f) {
            this.delegate.closeFrame(f);
        }

        @Override
        public void deactivateFrame(JInternalFrame f) {
            this.delegate.deactivateFrame(f);
        }

        @Override
        public void deiconifyFrame(JInternalFrame f) {
            this.delegate.deiconifyFrame(f);
        }

        @Override
        public void dragFrame(JComponent f, int newX, int newY) {
            if (newY < 0) {
                newY = 0;
            }
            this.delegate.dragFrame(f, newX, newY);
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            this.delegate.endDraggingFrame(f);
            desktop.repaint();
        }

        @Override
        public void endResizingFrame(JComponent f) {
            this.delegate.endResizingFrame(f);
            desktop.repaint();
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            this.delegate.iconifyFrame(f);
        }

        @Override
        public void maximizeFrame(JInternalFrame f) {
            this.delegate.maximizeFrame(f);
        }

        @Override
        public void minimizeFrame(JInternalFrame f) {
            this.delegate.minimizeFrame(f);
        }

        @Override
        public void openFrame(JInternalFrame f) {
            this.delegate.openFrame(f);
        }

        @Override
        public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            if (newY < 0) {
                newY = 0;
            }
            this.delegate.resizeFrame(f, newX, newY, newWidth, newHeight);
        }

        @Override
        public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            this.delegate.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
        }
    }
}

