/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.bin.Cache;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.datamodel.StructureViewerModel;
import jalview.ext.rbvi.chimera.JalviewChimeraBinding;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JalviewChimeraBindingModel;
import jalview.gui.JvOptionPane;
import jalview.gui.OOMWarning;
import jalview.gui.ProgressBar;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ChimeraViewFrame
extends StructureViewerBase {
    private JalviewChimeraBinding jmb;
    private String chimeraSessionFile = null;
    private int myWidth = 500;
    private int myHeight = 150;

    @Override
    protected void initMenus() {
        super.initMenus();
        this.savemenu.setVisible(false);
        this.viewMenu.add(this.fitToWindow);
        JMenuItem writeFeatures = new JMenuItem(MessageManager.getString("label.create_viewer_attributes"));
        writeFeatures.setToolTipText(MessageManager.getString("label.create_viewer_attributes_tip"));
        writeFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChimeraViewFrame.this.sendFeaturesToChimera();
            }
        });
        this.viewerActionMenu.add(writeFeatures);
        final JMenu fetchAttributes = new JMenu(MessageManager.getString("label.fetch_chimera_attributes"));
        fetchAttributes.setToolTipText(MessageManager.getString("label.fetch_chimera_attributes_tip"));
        fetchAttributes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ChimeraViewFrame.this.buildAttributesMenu(fetchAttributes);
            }
        });
        this.viewerActionMenu.add(fetchAttributes);
    }

    protected void buildAttributesMenu(JMenu attributesMenu) {
        List<String> atts = this.jmb.getChimeraAttributes();
        attributesMenu.removeAll();
        Collections.sort(atts);
        for (final String attName : atts) {
            JMenuItem menuItem = new JMenuItem(attName);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChimeraViewFrame.this.getBinding().copyStructureAttributesToFeatures(attName, ChimeraViewFrame.this.getAlignmentPanel()) > 0) {
                        ChimeraViewFrame.this.getAlignmentPanel().getFeatureRenderer().featuresAdded();
                    }
                }
            });
            attributesMenu.add(menuItem);
        }
    }

    protected void sendFeaturesToChimera() {
        int count = this.jmb.sendFeaturesToViewer(this.getAlignmentPanel());
        this.statusBar.setText(MessageManager.formatMessage("label.attributes_set", count));
    }

    public ChimeraViewFrame(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap) {
        this();
        this.openNewChimera(ap, new PDBEntry[]{pdbentry}, new SequenceI[][]{seq});
    }

    protected void createProgressBar() {
        if (this.getProgressIndicator() == null) {
            this.setProgressIndicator(new ProgressBar(this.statusPanel, this.statusBar));
        }
    }

    private void openNewChimera(AlignmentPanel ap, PDBEntry[] pdbentrys, SequenceI[][] seqs) {
        this.createProgressBar();
        this.jmb = this.newBindingModel(ap, pdbentrys, seqs);
        this.addAlignmentPanel(ap);
        this.useAlignmentPanelForColourbyseq(ap);
        if (pdbentrys.length > 1) {
            this.useAlignmentPanelForSuperposition(ap);
        }
        this.jmb.setColourBySequence(true);
        this.setSize(this.myWidth, this.myHeight);
        this.initMenus();
        this.addingStructures = false;
        this.worker = new Thread(this);
        this.worker.start();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ChimeraViewFrame.this.closeViewer(false);
            }
        });
    }

    protected JalviewChimeraBindingModel newBindingModel(AlignmentPanel ap, PDBEntry[] pdbentrys, SequenceI[][] seqs) {
        return new JalviewChimeraBindingModel(this, ap.getStructureSelectionManager(), pdbentrys, seqs, null);
    }

    public ChimeraViewFrame(StructureViewerModel viewerData, AlignmentPanel alignPanel, String sessionFile, String vid) {
        this();
        this.setViewId(vid);
        this.chimeraSessionFile = sessionFile;
        Map<File, StructureViewerModel.StructureData> pdbData = viewerData.getFileData();
        PDBEntry[] pdbArray = new PDBEntry[pdbData.size()];
        SequenceI[][] seqsArray = new SequenceI[pdbData.size()][];
        int i = 0;
        for (StructureViewerModel.StructureData data : pdbData.values()) {
            PDBEntry pdbentry;
            pdbArray[i] = pdbentry = new PDBEntry(data.getPdbId(), null, PDBEntry.Type.PDB, data.getFilePath());
            List<SequenceI> sequencesForPdb = data.getSeqList();
            seqsArray[i] = sequencesForPdb.toArray(new SequenceI[sequencesForPdb.size()]);
            ++i;
        }
        this.openNewChimera(alignPanel, pdbArray, seqsArray);
        if (viewerData.isColourByViewer()) {
            this.jmb.setColourBySequence(false);
            this.seqColour.setSelected(false);
            this.viewerColour.setSelected(true);
        } else if (viewerData.isColourWithAlignPanel()) {
            this.jmb.setColourBySequence(true);
            this.seqColour.setSelected(true);
            this.viewerColour.setSelected(false);
        }
    }

    public ChimeraViewFrame(PDBEntry[] pe, boolean alignAdded, SequenceI[][] seqs, AlignmentPanel ap) {
        this();
        this.setAlignAddedStructures(alignAdded);
        this.openNewChimera(ap, pe, seqs);
    }

    public ChimeraViewFrame() {
        this.setDefaultCloseOperation(0);
    }

    void initChimera() {
        boolean opened;
        this.jmb.setFinishedInit(false);
        Desktop.addInternalFrame(this, this.jmb.getViewerTitle(this.getViewerName(), true), this.getBounds().width, this.getBounds().height);
        if (!this.jmb.launchChimera()) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.open_viewer_failed", this.getViewerName()), MessageManager.getString("label.error_loading_file"), 0);
            this.dispose();
            return;
        }
        if (this.chimeraSessionFile != null && !(opened = this.jmb.openSession(this.chimeraSessionFile))) {
            System.err.println("An error occurred opening Chimera session file " + this.chimeraSessionFile);
        }
        this.jmb.startChimeraListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._started = true;
        StringBuilder errormsgs = new StringBuilder(128);
        StringBuilder files = new StringBuilder(128);
        ArrayList<PDBEntry> filePDB = new ArrayList<PDBEntry>();
        ArrayList<Integer> filePDBpos = new ArrayList<Integer>();
        PDBEntry thePdbEntry = null;
        StructureFile pdb = null;
        try {
            String[] curfiles = this.jmb.getStructureFiles();
            for (int pi = 0; pi < this.jmb.getPdbCount(); ++pi) {
                String file;
                block30: {
                    block29: {
                        file = null;
                        thePdbEntry = this.jmb.getPdbEntry(pi);
                        if (thePdbEntry.getFile() != null) break block29;
                        file = this.fetchPdbFile(thePdbEntry);
                        if (file != null) break block30;
                        errormsgs.append("'" + thePdbEntry.getId() + "' ");
                        break block30;
                    }
                    file = new File(thePdbEntry.getFile()).getAbsoluteFile().getPath();
                    if (curfiles != null && curfiles.length > 0) {
                        this.addingStructures = true;
                        for (int c = 0; c < curfiles.length; ++c) {
                            if (!curfiles[c].equals(file)) continue;
                            file = null;
                            break;
                        }
                    }
                }
                if (file == null) continue;
                filePDB.add(thePdbEntry);
                filePDBpos.add(pi);
                files.append(" \"" + Platform.escapeBackslashes(file) + "\"");
            }
        }
        catch (OutOfMemoryError oomerror) {
            new OOMWarning("Retrieving PDB files: " + thePdbEntry.getId(), oomerror);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errormsgs.append("When retrieving pdbfiles for '" + thePdbEntry.getId() + "'");
        }
        if (errormsgs.length() > 0) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.pdb_entries_couldnt_be_retrieved", errormsgs.toString()), MessageManager.getString("label.couldnt_load_file"), 0);
        }
        if (files.length() > 0) {
            this.jmb.setFinishedInit(false);
            if (!this.addingStructures) {
                try {
                    this.initChimera();
                }
                catch (Exception ex) {
                    Cache.log.error((Object)"Couldn't open Chimera viewer!", (Throwable)ex);
                }
            }
            int num = -1;
            for (PDBEntry pe : filePDB) {
                ++num;
                if (pe.getFile() == null) continue;
                try {
                    int pos = (Integer)filePDBpos.get(num);
                    long startTime = this.startProgressBar(this.getViewerName() + " " + MessageManager.getString("status.opening_file_for") + " " + pe.getId());
                    this.jmb.openFile(pe);
                    this.jmb.addSequence(pos, this.jmb.getSequence()[pos]);
                    File fl = new File(pe.getFile());
                    DataSourceType protocol = DataSourceType.URL;
                    try {
                        if (fl.exists()) {
                            protocol = DataSourceType.FILE;
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.stopProgressBar("", startTime);
                    }
                    pdb = this.jmb.getSsm().setMapping(this.jmb.getSequence()[pos], this.jmb.getChains()[pos], pe.getFile(), protocol, this.getProgressIndicator());
                    this.jmb.stashFoundChains(pdb, pe.getFile());
                }
                catch (OutOfMemoryError oomerror) {
                    new OOMWarning("When trying to open and map structures from Chimera!", oomerror);
                }
                catch (Exception ex) {
                    Cache.log.error((Object)("Couldn't open " + pe.getFile() + " in Chimera viewer!"), (Throwable)ex);
                }
                finally {
                    Cache.log.debug((Object)("File locations are " + files));
                }
            }
            this.jmb.refreshGUI();
            this.jmb.setFinishedInit(true);
            this.jmb.setLoadingFromArchive(false);
            FeatureRenderer fr = this.getBinding().getFeatureRenderer(null);
            if (fr != null) {
                fr.featuresAdded();
            }
            for (AlignmentViewPanel ap : this._colourwith) {
                this.jmb.updateColours(ap);
            }
            if (this.alignAddedStructures) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ChimeraViewFrame.this.alignStructsWithAllAlignPanels();
                    }
                }).start();
            }
            this.addingStructures = false;
        }
        this._started = false;
        this.worker = null;
    }

    @Override
    public void makePDBImage(ImageMaker.TYPE imageType) {
        throw new UnsupportedOperationException("Image export for Chimera is not implemented");
    }

    @Override
    public AAStructureBindingModel getBinding() {
        return this.jmb;
    }

    @Override
    public StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.CHIMERA;
    }

    @Override
    protected String getViewerName() {
        return "Chimera";
    }
}

