/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.StructureSelectionManagerProvider;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import java.awt.Component;

public class AssociatePdbFileWithSeq {
    public PDBEntry associatePdbWithSeq(String choice, DataSourceType file, SequenceI sequence, boolean prompt, StructureSelectionManagerProvider ssmp) {
        PDBEntry entry = new PDBEntry();
        StructureFile pdbfile = null;
        pdbfile = StructureSelectionManager.getStructureSelectionManager(ssmp).setMapping(false, new SequenceI[]{sequence}, null, choice, file);
        if (pdbfile == null) {
            return null;
        }
        if (pdbfile.getId() == null) {
            String reply = null;
            if (prompt) {
                reply = JvOptionPane.showInternalInputDialog((Component)Desktop.desktop, MessageManager.getString("label.couldnt_find_pdb_id_in_file"), MessageManager.getString("label.no_pdb_id_in_file"), 3);
            }
            if (reply == null) {
                return null;
            }
            entry.setId(reply);
        } else {
            entry.setId(pdbfile.getId());
        }
        entry.setType(PDBEntry.Type.FILE);
        if (pdbfile != null) {
            entry.setFile(choice);
            sequence.getDatasetSequence().addPDBId(entry);
            StructureSelectionManager.getStructureSelectionManager(ssmp).registerPDBEntry(entry);
        }
        return entry;
    }
}

