/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.renderer.AnnotationRenderer;
import jalview.renderer.AwtRenderPanelI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.ViewportListenerI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;

public class AnnotationPanel
extends JPanel
implements AwtRenderPanelI,
MouseListener,
MouseWheelListener,
MouseMotionListener,
ActionListener,
AdjustmentListener,
Scrollable,
ViewportListenerI {
    String HELIX = MessageManager.getString("label.helix");
    String SHEET = MessageManager.getString("label.sheet");
    String STEM = MessageManager.getString("label.rna_helix");
    String LABEL = MessageManager.getString("label.label");
    String REMOVE = MessageManager.getString("label.remove_annotation");
    String COLOUR = MessageManager.getString("action.colour");
    public final Color HELIX_COLOUR = Color.red.darker();
    public final Color SHEET_COLOUR = Color.green.darker().darker();
    public final Color STEM_COLOUR = Color.blue.darker();
    public AlignViewport av;
    AlignmentPanel ap;
    public int activeRow = -1;
    public BufferedImage image;
    public volatile BufferedImage fadedImage;
    public FontMetrics fm;
    public int imgWidth = 0;
    boolean fastPaint = false;
    int graphStretch = -1;
    int mouseDragLastX = -1;
    int mouseDragLastY = -1;
    DragMode dragMode = DragMode.Undefined;
    boolean mouseDragging = false;
    int cursorX = 0;
    int cursorY = 0;
    public final AnnotationRenderer renderer;
    private MouseWheelListener[] _mwl;
    private volatile boolean imageFresh = false;
    private Rectangle visibleRect = new Rectangle();
    private Rectangle clipBounds = new Rectangle();
    private final boolean debugRedraw = false;
    private volatile boolean lastImageGood = false;
    private int[] bounds = new int[2];

    public AnnotationPanel(AlignmentPanel ap) {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.ap = ap;
        this.av = ap.av;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ap.annotationScroller.getVerticalScrollBar().addAdjustmentListener(this);
        this._mwl = ap.annotationScroller.getMouseWheelListeners();
        ap.annotationScroller.addMouseWheelListener(this);
        this.renderer = new AnnotationRenderer();
        this.av.getRanges().addPropertyChangeListener(this);
    }

    public AnnotationPanel(AlignViewport av) {
        this.av = av;
        this.renderer = new AnnotationRenderer();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        block4: {
            block2: {
                double wheelRotation;
                block3: {
                    if (!e.isShiftDown()) break block2;
                    e.consume();
                    wheelRotation = e.getPreciseWheelRotation();
                    if (!(wheelRotation > 0.0)) break block3;
                    this.av.getRanges().scrollRight(true);
                    break block4;
                }
                if (!(wheelRotation < 0.0)) break block4;
                this.av.getRanges().scrollRight(false);
                break block4;
            }
            for (MouseWheelListener mwl : this._mwl) {
                if (mwl != null) {
                    mwl.mouseWheelMoved(e);
                }
                if (e.isConsumed()) break;
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension ps = this.getPreferredSize();
        return new Dimension(ps.width, this.adjustForAlignFrame(false, ps.height));
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.ap.getAlabels().setScrollOffset(-evt.getValue());
    }

    public int adjustPanelHeight() {
        int height = this.av.calcPanelHeight();
        this.setPreferredSize(new Dimension(1, height));
        if (this.ap != null) {
            this.ap.validate();
        }
        return height;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String action;
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        Annotation[] anot = aa[this.activeRow].annotations;
        if (anot.length < this.av.getColumnSelection().getMax()) {
            Annotation[] temp = new Annotation[this.av.getColumnSelection().getMax() + 2];
            System.arraycopy(anot, 0, temp, 0, anot.length);
            anot = temp;
            aa[this.activeRow].annotations = anot;
        }
        if ((action = evt.getActionCommand()).equals(this.REMOVE)) {
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                anot[index] = null;
            }
        } else if (action.equals(this.LABEL)) {
            String exMesg = this.collectAnnotVals(anot, this.LABEL);
            String label = JvOptionPane.showInputDialog(MessageManager.getString("label.enter_label"), exMesg);
            if (label == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
            }
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", ' ', 0.0f);
                    continue;
                }
                anot[index].displayCharacter = label;
            }
        } else if (action.equals(this.COLOUR)) {
            final Annotation[] fAnot = anot;
            String title = MessageManager.getString("label.select_foreground_colour");
            JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

                @Override
                public void colourSelected(Color c) {
                    HiddenColumns hiddenColumns = AnnotationPanel.this.av.getAlignment().getHiddenColumns();
                    for (int index : AnnotationPanel.this.av.getColumnSelection().getSelected()) {
                        if (!hiddenColumns.isVisible(index)) continue;
                        if (fAnot[index] == null) {
                            fAnot[index] = new Annotation("", "", ' ', 0.0f);
                        }
                        fAnot[index].colour = c;
                    }
                }
            };
            JalviewColourChooser.showColourChooser(this, title, Color.black, listener);
        } else {
            String label;
            int type = 0;
            String symbol = "\u03b1";
            if (action.equals(this.HELIX)) {
                type = 72;
            } else if (action.equals(this.SHEET)) {
                type = 69;
                symbol = "\u03b2";
            } else if (action.equals(this.STEM)) {
                type = 83;
                int column = this.av.getColumnSelection().getSelectedRanges().get(0)[0];
                symbol = aa[this.activeRow].getDefaultRnaHelixSymbol(column);
            }
            if (!aa[this.activeRow].hasIcons) {
                aa[this.activeRow].hasIcons = true;
            }
            if ((label = JvOptionPane.showInputDialog(MessageManager.getString("label.enter_label_for_the_structure"), symbol)) == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
                if (action.equals(this.STEM)) {
                    aa[this.activeRow].showAllColLabels = true;
                }
            }
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", (char)type, 0.0f);
                }
                anot[index].secondaryStructure = type != 83 ? type : (label.length() == 0 ? 32 : (int)label.charAt(0));
                anot[index].displayCharacter = label;
            }
        }
        this.av.getAlignment().validateAnnotation(aa[this.activeRow]);
        this.ap.alignmentChanged();
        this.ap.alignFrame.setMenusForViewport();
        this.adjustPanelHeight();
        this.repaint();
    }

    private String collectAnnotVals(Annotation[] anots, String type) {
        StringBuilder collatedInput = new StringBuilder(64);
        String last = "";
        ColumnSelection viscols = this.av.getColumnSelection();
        HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
        ArrayList<Integer> selected = new ArrayList<Integer>(viscols.getSelected());
        Collections.sort(selected);
        Iterator iterator = selected.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!hidden.isVisible(index)) continue;
            Object tlabel = null;
            if (anots[index] == null) continue;
            if ((type.equals(this.HELIX) || type.equals(this.SHEET) || type.equals(this.STEM) || type.equals(this.LABEL)) && ((tlabel = anots[index].description) == null || ((String)tlabel).length() < 1)) {
                tlabel = type.equals(this.HELIX) || type.equals(this.SHEET) || type.equals(this.STEM) ? "" + anots[index].secondaryStructure : anots[index].displayCharacter;
            }
            if (tlabel == null || ((String)tlabel).equals(last)) continue;
            if (last.length() > 0) {
                collatedInput.append(" ");
            }
            collatedInput.append((String)tlabel);
        }
        return collatedInput.toString();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        this.mouseDragLastX = evt.getX();
        this.mouseDragLastY = evt.getY();
        int height = 0;
        this.activeRow = -1;
        int y = evt.getY();
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (y >= height) continue;
            if (aa[i].editable) {
                this.activeRow = i;
                break;
            }
            if (aa[i].graph <= 0) break;
            this.graphStretch = i;
            break;
        }
        if (evt.isPopupTrigger() && this.activeRow != -1) {
            this.showPopupMenu(y, evt.getX());
            return;
        }
        this.ap.getScalePanel().mousePressed(evt);
    }

    void showPopupMenu(int y, int x) {
        JMenuItem item;
        if (this.av.getColumnSelection() == null || this.av.getColumnSelection().isEmpty()) {
            return;
        }
        JPopupMenu pop = new JPopupMenu(MessageManager.getString("label.structure_type"));
        if (this.av.getAlignment().isNucleotide()) {
            item = new JMenuItem(this.STEM);
            item.addActionListener(this);
            pop.add(item);
        } else {
            item = new JMenuItem(this.HELIX);
            item.addActionListener(this);
            pop.add(item);
            item = new JMenuItem(this.SHEET);
            item.addActionListener(this);
            pop.add(item);
        }
        item = new JMenuItem(this.LABEL);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(this.COLOUR);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(this.REMOVE);
        item.addActionListener(this);
        pop.add(item);
        pop.show(this, x, y);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.graphStretch = -1;
        this.mouseDragLastX = -1;
        this.mouseDragLastY = -1;
        this.mouseDragging = false;
        if (this.dragMode == DragMode.Resize) {
            this.ap.adjustAnnotationHeight();
        }
        this.dragMode = DragMode.Undefined;
        this.ap.getScalePanel().mouseReleased(evt);
        if (evt.isPopupTrigger() && this.activeRow != -1) {
            this.showPopupMenu(evt.getY(), evt.getX());
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.mouseDragging = false;
        this.ap.getScalePanel().mouseEntered(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.ap.getScalePanel().mouseExited(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.dragMode == DragMode.Undefined) {
            int dx = Math.abs(x - this.mouseDragLastX);
            int dy = Math.abs(y - this.mouseDragLastY);
            if (this.graphStretch == -1 || dx > dy) {
                this.dragMode = DragMode.Select;
            } else if (dy > dx) {
                this.dragMode = DragMode.Resize;
            }
        }
        if (this.dragMode == DragMode.Undefined) {
            return;
        }
        try {
            if (this.dragMode == DragMode.Resize) {
                int deltaY = this.mouseDragLastY - evt.getY();
                if (deltaY != 0) {
                    int newHeight;
                    AlignmentAnnotation graphAnnotation = this.av.getAlignment().getAlignmentAnnotation()[this.graphStretch];
                    graphAnnotation.graphHeight = newHeight = Math.max(0, graphAnnotation.graphHeight + deltaY);
                    this.adjustPanelHeight();
                    this.ap.paintAlignment(false, false);
                }
            } else {
                this.ap.getScalePanel().mouseDragged(evt);
            }
        }
        finally {
            this.mouseDragLastX = x;
            this.mouseDragLastY = y;
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        AlignmentAnnotation[] aa;
        int yPos = evt.getY();
        int row = AnnotationPanel.getRowIndex(yPos, aa = this.av.getAlignment().getAlignmentAnnotation());
        if (row == -1) {
            this.setToolTipText(null);
            return;
        }
        int column = evt.getX() / this.av.getCharWidth() + this.av.getRanges().getStartRes();
        column = Math.min(column, this.av.getRanges().getEndRes());
        if (this.av.hasHiddenColumns()) {
            column = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(column);
        }
        AlignmentAnnotation ann = aa[row];
        if (row > -1 && ann.annotations != null && column < ann.annotations.length) {
            String toolTip = AnnotationPanel.buildToolTip(ann, column, aa);
            this.setToolTipText(toolTip == null ? null : JvSwingUtils.wrapTooltip(true, toolTip));
            String msg = AnnotationPanel.getStatusMessage(this.av.getAlignment(), column, ann);
            this.ap.alignFrame.setStatus(msg);
        } else {
            this.setToolTipText(null);
            this.ap.alignFrame.setStatus(" ");
        }
    }

    static int getRowIndex(int yPos, AlignmentAnnotation[] aa) {
        if (aa == null) {
            return -1;
        }
        int row = -1;
        int height = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (height <= yPos) continue;
            row = i;
            break;
        }
        return row;
    }

    static String buildToolTip(AlignmentAnnotation ann, int column, AlignmentAnnotation[] anns) {
        String tooltip = null;
        if (ann.graphGroup > -1) {
            StringBuilder tip = new StringBuilder(32);
            boolean first = true;
            for (int i = 0; i < anns.length; ++i) {
                if (anns[i].graphGroup != ann.graphGroup || anns[i].annotations[column] == null) continue;
                if (!first) {
                    tip.append("<br>");
                }
                first = false;
                tip.append(anns[i].label);
                String description = anns[i].annotations[column].description;
                if (description == null || description.length() <= 0) continue;
                tip.append(" ").append(description);
            }
            tooltip = first ? null : tip.toString();
        } else if (column < ann.annotations.length && ann.annotations[column] != null) {
            tooltip = ann.annotations[column].description;
        }
        return tooltip;
    }

    static String getStatusMessage(AlignmentI al, int column, AlignmentAnnotation ann) {
        int seqIndex;
        SequenceI seqref;
        String description;
        StringBuilder text = new StringBuilder(32);
        text.append(MessageManager.getString("label.column")).append(" ").append(column + 1);
        if (column < ann.annotations.length && ann.annotations[column] != null && (description = ann.annotations[column].description) != null && description.trim().length() > 0) {
            text.append("  ").append(description);
        }
        if ((seqref = ann.sequenceRef) != null && (seqIndex = al.findIndex(seqref)) != -1) {
            text.append(", ").append(MessageManager.getString("label.sequence")).append(" ").append(seqIndex + 1);
            char residue = seqref.getCharAt(column);
            if (!Comparison.isGap(residue)) {
                text.append(" ");
                if (al.isNucleotide()) {
                    String name = ResidueProperties.nucleotideName.get(String.valueOf(residue));
                    text.append(" Nucleotide: ").append(name != null ? name : Character.valueOf(residue));
                } else {
                    String name = 'X' == residue ? "X" : ('*' == residue ? "STOP" : ResidueProperties.aa2Triplet.get(String.valueOf(residue)));
                    text.append(" Residue: ").append(name != null ? name : Character.valueOf(residue));
                }
                int residuePos = seqref.findPosition(column);
                text.append(" (").append(residuePos).append(")");
            }
        }
        return text.toString();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    public void drawCursor(Graphics graphics, SequenceI seq, int res, int x1, int y1) {
        int pady = this.av.getCharHeight() / 5;
        int charOffset = 0;
        graphics.setColor(Color.black);
        graphics.fillRect(x1, y1, this.av.getCharWidth(), this.av.getCharHeight());
        if (this.av.validCharWidth) {
            graphics.setColor(Color.white);
            char s = seq.getCharAt(res);
            charOffset = (this.av.getCharWidth() - this.fm.charWidth(s)) / 2;
            graphics.drawString(String.valueOf(s), charOffset + x1, y1 + this.av.getCharHeight() - pady);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D gg;
        block12: {
            block13: {
                this.computeVisibleRect(this.visibleRect);
                g.setColor(Color.white);
                g.fillRect(0, 0, this.visibleRect.width, this.visibleRect.height);
                if (this.image == null) break block12;
                if (this.fastPaint) break block13;
                this.clipBounds = g.getClipBounds(this.clipBounds);
                if (this.visibleRect.width == this.clipBounds.width && this.visibleRect.height == this.clipBounds.height) break block12;
            }
            g.drawImage(this.image, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        this.imgWidth = (this.av.getRanges().getEndRes() - this.av.getRanges().getStartRes() + 1) * this.av.getCharWidth();
        if (this.imgWidth < 1) {
            return;
        }
        if (this.image == null || this.imgWidth != this.image.getWidth(this) || this.image.getHeight(this) != this.getHeight()) {
            try {
                this.image = new BufferedImage(this.imgWidth, this.ap.getAnnotationPanel().getHeight(), 1);
            }
            catch (OutOfMemoryError oom) {
                try {
                    System.gc();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new OOMWarning("Couldn't allocate memory to redraw screen. Please restart Jalview", oom);
                return;
            }
            gg = (Graphics2D)this.image.getGraphics();
            if (this.av.antiAlias) {
                gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            gg.setFont(this.av.getFont());
            this.fm = gg.getFontMetrics();
            gg.setColor(Color.white);
            gg.fillRect(0, 0, this.imgWidth, this.image.getHeight());
            this.imageFresh = true;
        } else {
            gg = (Graphics2D)this.image.getGraphics();
        }
        this.drawComponent(gg, this.av.getRanges().getStartRes(), this.av.getRanges().getEndRes() + 1);
        gg.dispose();
        this.imageFresh = false;
        g.drawImage(this.image, 0, 0, this);
    }

    public void fastPaint(int horizontal) {
        if (horizontal == 0 || this.image == null || this.av.getAlignment().getAlignmentAnnotation() == null || this.av.getAlignment().getAlignmentAnnotation().length < 1 || this.av.isCalcInProgress()) {
            this.repaint();
            return;
        }
        int sr = this.av.getRanges().getStartRes();
        int er = this.av.getRanges().getEndRes() + 1;
        int transX = 0;
        Graphics2D gg = (Graphics2D)this.image.getGraphics();
        gg.copyArea(0, 0, this.imgWidth, this.getHeight(), -horizontal * this.av.getCharWidth(), 0);
        if (horizontal > 0) {
            transX = (er - sr - horizontal) * this.av.getCharWidth();
            sr = er - horizontal;
        } else if (horizontal < 0) {
            er = sr - horizontal;
        }
        gg.translate(transX, 0);
        this.drawComponent(gg, sr, er);
        gg.translate(-transX, 0);
        gg.dispose();
        this.fastPaint = true;
        this.av.getAlignPanel().repaint();
    }

    public void drawComponent(Graphics g, int startRes, int endRes) {
        BufferedImage oldFaded = this.fadedImage;
        if (this.av.isCalcInProgress()) {
            if (this.image == null) {
                this.lastImageGood = false;
                return;
            }
            if (this.lastImageGood && (this.fadedImage == null || this.fadedImage.getWidth() != this.imgWidth || this.fadedImage.getHeight() != this.image.getHeight())) {
                this.fadedImage = new BufferedImage(this.imgWidth, this.image.getHeight(), 1);
                Graphics2D fadedG = (Graphics2D)this.fadedImage.getGraphics();
                fadedG.setColor(Color.white);
                fadedG.fillRect(0, 0, this.imgWidth, this.image.getHeight());
                fadedG.setComposite(AlphaComposite.getInstance(3, 0.3f));
                fadedG.drawImage((Image)this.image, 0, 0, this);
            }
            this.lastImageGood = false;
        } else {
            if (this.fadedImage != null) {
                oldFaded = this.fadedImage;
            }
            this.fadedImage = null;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, (endRes - startRes) * this.av.getCharWidth(), this.getHeight());
        g.setFont(this.av.getFont());
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        if (this.av.getAlignment().getAlignmentAnnotation() == null || this.av.getAlignment().getAlignmentAnnotation().length < 1) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            if (this.av.validCharWidth) {
                g.drawString(MessageManager.getString("label.alignment_has_no_annotations"), 20, 15);
            }
            return;
        }
        this.lastImageGood = this.renderer.drawComponent(this, this.av, g, this.activeRow, startRes, endRes);
        if (!this.lastImageGood && this.fadedImage == null) {
            this.fadedImage = oldFaded;
        }
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    @Override
    public Image getFadedImage() {
        return this.fadedImage;
    }

    @Override
    public int getFadedImageWidth() {
        return this.imgWidth;
    }

    @Override
    public int[] getVisibleVRange() {
        if (this.ap != null && this.ap.getAlabels() != null) {
            int sOffset = -this.ap.getAlabels().getScrollOffset();
            int visHeight = sOffset + this.ap.annotationSpaceFillerHolder.getHeight();
            this.bounds[0] = sOffset;
            this.bounds[1] = visHeight;
            return this.bounds;
        }
        return null;
    }

    public void dispose() {
        this.av = null;
        this.ap = null;
        this.image = null;
        this.fadedImage = null;
        this._mwl = null;
        if (this.renderer != null) {
            this.renderer.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("startres")) {
            this.fastPaint((Integer)evt.getNewValue() - (Integer)evt.getOldValue());
        } else if (evt.getPropertyName().equals("startresandseq")) {
            this.fastPaint(((int[])evt.getNewValue())[0] - ((int[])evt.getOldValue())[0]);
        } else if (evt.getPropertyName().equals("move_viewport")) {
            this.repaint();
        }
    }

    public int adjustForAlignFrame(boolean adjustPanelHeight, int annotationHeight) {
        int stuff = (this.ap.getViewName() != null ? 30 : 0) + (Platform.isAMacAndNotJS() ? 120 : 140);
        int availableHeight = this.ap.alignFrame.getHeight() - stuff;
        int rowHeight = this.av.getCharHeight();
        if (adjustPanelHeight) {
            int alignmentHeight = rowHeight * this.av.getAlignment().getHeight();
            if (annotationHeight + alignmentHeight > availableHeight) {
                annotationHeight = Math.min(annotationHeight, availableHeight - 2 * rowHeight);
            }
        } else {
            annotationHeight = Math.min(this.ap.annotationScroller.getSize().height, availableHeight - 2 * rowHeight);
        }
        return annotationHeight;
    }

    static enum DragMode {
        Select,
        Resize,
        Undefined;

    }
}

