/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.QuitStrategy;
import javax.swing.JOptionPane;

public class APQHandlers {
    private static boolean setAPQHandlers = false;

    protected static boolean setAPQHandlers(final Desktop jalviewDesktop) {
        if (!setAPQHandlers) {
            Class<java.awt.Desktop> desktopClass = java.awt.Desktop.class;
            java.awt.Desktop hdesktop = java.awt.Desktop.getDesktop();
            try {
                Float specversion = Float.valueOf(Float.parseFloat(System.getProperty("java.specification.version")));
                if (specversion.floatValue() >= 9.0f) {
                    if (Platform.isAMacAndNotJS()) {
                        if (desktopClass.getDeclaredMethod("setAboutHandler", AboutHandler.class) != null) {
                            hdesktop.setAboutHandler(new AboutHandler(){

                                @Override
                                public void handleAbout(AboutEvent e) {
                                    jalviewDesktop.aboutMenuItem_actionPerformed(null);
                                }
                            });
                        }
                        if (desktopClass.getDeclaredMethod("setPreferencesHandler", PreferencesHandler.class) != null) {
                            hdesktop.setPreferencesHandler(new PreferencesHandler(){

                                @Override
                                public void handlePreferences(PreferencesEvent e) {
                                    jalviewDesktop.preferences_actionPerformed(null);
                                }
                            });
                        }
                        if (desktopClass.getDeclaredMethod("setQuitHandler", QuitHandler.class) != null) {
                            hdesktop.setQuitHandler(new QuitHandler(){

                                @Override
                                public void handleQuitRequestWith(QuitEvent e, QuitResponse r) {
                                    boolean confirmQuit = Cache.getDefault("CONFIRM_KEYBOARD_QUIT", true);
                                    int n = confirmQuit ? JOptionPane.showConfirmDialog(null, MessageManager.getString("label.quit_jalview"), MessageManager.getString("action.quit"), 2, -1, null) : 0;
                                    if (n == 0) {
                                        System.out.println("Shortcut Quit confirmed by user");
                                        jalviewDesktop.quit();
                                        r.performQuit();
                                    } else {
                                        r.cancelQuit();
                                        System.out.println("Shortcut Quit cancelled by user");
                                    }
                                }
                            });
                            hdesktop.setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
                        }
                    }
                    setAPQHandlers = true;
                } else {
                    System.out.println("Not going to try setting APQ Handlers as java.spec.version is " + specversion);
                }
            }
            catch (Exception e) {
                System.out.println("Exception when looking for About, Preferences, Quit Handlers");
            }
            catch (Throwable t) {
                System.out.println("Throwable when looking for About, Preferences, Quit Handlers");
            }
        }
        return setAPQHandlers;
    }
}

