/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.uniprot;

import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.core.GFTSPanel;
import jalview.fts.service.uniprot.UniProtFTSRestClient;
import jalview.gui.Help;
import jalview.gui.SequenceFetcher;
import jalview.util.MessageManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.help.HelpSetException;

public class UniprotFTSPanel
extends GFTSPanel {
    private static String defaultFTSFrameTitle = MessageManager.getString("label.uniprot_sequence_fetcher");
    private static Map<String, Integer> tempUserPrefs = new HashMap<String, Integer>();
    private static final String UNIPROT_FTS_CACHE_KEY = "CACHE.UNIPROT_FTS";
    private static final String UNIPROT_AUTOSEARCH = "FTS.UNIPROT.AUTOSEARCH";

    public UniprotFTSPanel(SequenceFetcher fetcher) {
        super(fetcher);
        this.pageLimit = UniProtFTSRestClient.getInstance().getDefaultResponsePageSize();
        this.seqFetcher = fetcher;
        this.progressIndicator = fetcher == null ? null : fetcher.getProgressIndicator();
    }

    @Override
    public void searchAction(boolean isFreshSearch) {
        this.mainFrame.requestFocusInWindow();
        if (isFreshSearch) {
            this.offSet = 0;
        }
        new Thread(){

            @Override
            public void run() {
                UniprotFTSPanel.this.reset();
                String searchInput = UniprotFTSPanel.this.getTypedText();
                if (searchInput.length() > 0) {
                    String result;
                    FTSRestResponse resultList;
                    UniprotFTSPanel.this.setSearchInProgress(true);
                    long startTime = System.currentTimeMillis();
                    searchInput = UniprotFTSPanel.this.getTypedText();
                    String searchTarget = ((FTSDataColumnI)UniprotFTSPanel.this.cmb_searchTarget.getSelectedItem()).getAltCode();
                    UniprotFTSPanel.this.wantedFields = UniProtFTSRestClient.getInstance().getAllDefaultDisplayedFTSDataColumns();
                    String searchTerm = UniprotFTSPanel.this.decodeSearchTerm(searchInput, searchTarget);
                    FTSRestRequest request = new FTSRestRequest();
                    request.setFieldToSearchBy(searchTarget);
                    request.setSearchTerm(searchTerm);
                    request.setOffSet(UniprotFTSPanel.this.offSet);
                    request.setWantedFields(UniprotFTSPanel.this.wantedFields);
                    FTSRestClientI uniProtRestClient = UniProtFTSRestClient.getInstance();
                    try {
                        resultList = uniProtRestClient.executeRequest(request);
                    }
                    catch (Exception e) {
                        UniprotFTSPanel.this.setErrorMessage(e.getMessage());
                        UniprotFTSPanel.this.checkForErrors();
                        UniprotFTSPanel.this.setSearchInProgress(false);
                        return;
                    }
                    if (resultList.getSearchSummary() != null && resultList.getSearchSummary().size() > 0) {
                        UniprotFTSPanel.this.getResultTable().setModel(FTSRestResponse.getTableModel(request, resultList.getSearchSummary()));
                        FTSRestResponse.configureTableColumn(UniprotFTSPanel.this.getResultTable(), UniprotFTSPanel.this.wantedFields, tempUserPrefs);
                        UniprotFTSPanel.this.getResultTable().setVisible(true);
                    }
                    long endTime = System.currentTimeMillis();
                    UniprotFTSPanel.this.totalResultSetCount = resultList.getNumberOfItemsFound();
                    UniprotFTSPanel.this.resultSetCount = resultList.getSearchSummary() == null ? 0 : resultList.getSearchSummary().size();
                    String string = result = UniprotFTSPanel.this.resultSetCount > 0 ? MessageManager.getString("label.results") : MessageManager.getString("label.result");
                    if (UniprotFTSPanel.this.isPaginationEnabled() && UniprotFTSPanel.this.resultSetCount > 0) {
                        UniprotFTSPanel.this.updateSearchFrameTitle(defaultFTSFrameTitle + " - " + result + " " + totalNumberformatter.format((Object)(UniprotFTSPanel.this.offSet + 1)) + " to " + totalNumberformatter.format((Object)(UniprotFTSPanel.this.offSet + UniprotFTSPanel.this.resultSetCount)) + " of " + totalNumberformatter.format((Object)UniprotFTSPanel.this.totalResultSetCount) + "  (" + (endTime - startTime) + " milli secs)");
                    } else {
                        UniprotFTSPanel.this.updateSearchFrameTitle(defaultFTSFrameTitle + " - " + UniprotFTSPanel.this.resultSetCount + " " + result + " (" + (endTime - startTime) + " milli secs)");
                    }
                    UniprotFTSPanel.this.setSearchInProgress(false);
                    UniprotFTSPanel.this.refreshPaginatorState();
                    UniprotFTSPanel.this.updateSummaryTableSelections();
                }
                UniprotFTSPanel.this.txt_search.updateCache();
            }
        }.start();
    }

    public String decodeSearchTerm(String enteredText, String targetField) {
        int searchTargetLength = targetField.equalsIgnoreCase("Search All") ? 0 : targetField.length() + 1;
        Object searchTarget = targetField.equalsIgnoreCase("Search All") ? "" : targetField + ":";
        String foundSearchTerms = enteredText;
        StringBuilder foundSearchTermsBuilder = new StringBuilder();
        if (enteredText.contains(";")) {
            String[] searchTerms;
            for (String searchTerm : searchTerms = enteredText.split(";")) {
                foundSearchTermsBuilder.append((String)searchTarget).append(searchTerm).append(" OR ");
            }
            int endIndex = foundSearchTermsBuilder.lastIndexOf(" OR ");
            foundSearchTerms = foundSearchTermsBuilder.toString();
            if (foundSearchTerms.contains(" OR ")) {
                foundSearchTerms = foundSearchTerms.substring(searchTargetLength, endIndex);
            }
        }
        return foundSearchTerms;
    }

    @Override
    public boolean isPaginationEnabled() {
        return true;
    }

    @Override
    public void okAction() {
        this.disableActionButtons();
        StringBuilder selectedIds = new StringBuilder();
        HashSet<String> selectedIdsSet = new HashSet<String>();
        int primaryKeyColIndex = 0;
        try {
            primaryKeyColIndex = this.getFTSRestClient().getPrimaryKeyColumIndex(this.wantedFields, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] selectedRows = this.getResultTable().getSelectedRows();
        for (int summaryRow : selectedRows) {
            String idStr = this.getResultTable().getValueAt(summaryRow, primaryKeyColIndex).toString();
            selectedIdsSet.add(idStr);
        }
        selectedIdsSet.addAll(this.paginatorCart);
        Object object = selectedIdsSet.iterator();
        while (object.hasNext()) {
            String selectedId = (String)object.next();
            selectedIds.append(selectedId).append(";");
        }
        String ids = selectedIds.toString();
        this.seqFetcher.setQuery(ids);
        Thread worker = new Thread(this.seqFetcher);
        worker.start();
        this.delayAndEnableActionButtons();
    }

    @Override
    public FTSRestClientI getFTSRestClient() {
        return UniProtFTSRestClient.getInstance();
    }

    @Override
    public String getFTSFrameTitle() {
        return defaultFTSFrameTitle;
    }

    @Override
    public Map<String, Integer> getTempUserPrefs() {
        return tempUserPrefs;
    }

    @Override
    public String getCacheKey() {
        return UNIPROT_FTS_CACHE_KEY;
    }

    @Override
    public String getAutosearchPreference() {
        return UNIPROT_AUTOSEARCH;
    }

    @Override
    protected void showHelp() {
        try {
            Help.showHelpWindow(Help.HelpId.UniprotFts);
        }
        catch (HelpSetException e1) {
            e1.printStackTrace();
        }
    }
}

