/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.core;

import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public abstract class FTSRestClient
implements FTSRestClientI {
    protected Collection<FTSDataColumnI> dataColumns = new ArrayList<FTSDataColumnI>();
    protected Collection<FTSDataColumnI.FTSDataColumnGroupI> dataColumnGroups = new ArrayList<FTSDataColumnI.FTSDataColumnGroupI>();
    protected Collection<FTSDataColumnI> searchableDataColumns = new ArrayList<FTSDataColumnI>();
    protected Collection<FTSDataColumnI> defaulDisplayedDataColumns = new ArrayList<FTSDataColumnI>();
    protected FTSDataColumnI primaryKeyColumn;
    private String primaryKeyColumnCode = null;
    private int defaultResponsePageSize = 100;

    protected FTSRestClient() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseDataColumnsConfigFile() {
        String fileName = this.getColumnDataConfigFileName();
        InputStream in = this.getClass().getResourceAsStream(fileName);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = br.readLine()) != null) {
                final String[] lineData = line.split(";");
                try {
                    if (lineData.length == 2) {
                        if (lineData[0].equalsIgnoreCase("_data_column.primary_key")) {
                            this.primaryKeyColumnCode = lineData[1];
                        }
                        if (!lineData[0].equalsIgnoreCase("_data_column.default_response_page_size")) continue;
                        this.defaultResponsePageSize = Integer.valueOf(lineData[1]);
                        continue;
                    }
                    if (lineData.length == 3) {
                        this.dataColumnGroups.add(new FTSDataColumnI.FTSDataColumnGroupI(){

                            @Override
                            public String getID() {
                                return lineData[0];
                            }

                            @Override
                            public String getName() {
                                return lineData[1];
                            }

                            @Override
                            public int getSortOrder() {
                                return Integer.valueOf(lineData[2]);
                            }

                            public String toString() {
                                return lineData[1];
                            }

                            public int hashCode() {
                                return Objects.hash(this.getID(), this.getName(), this.getSortOrder());
                            }

                            public boolean equals(Object otherObject) {
                                FTSDataColumnI.FTSDataColumnGroupI that = (FTSDataColumnI.FTSDataColumnGroupI)otherObject;
                                return this.getID().equals(that.getID()) && this.getName().equals(that.getName()) && this.getSortOrder() == that.getSortOrder();
                            }
                        });
                        continue;
                    }
                    if (lineData.length <= 6) continue;
                    FTSDataColumnI dataCol = new FTSDataColumnI(){

                        public String toString() {
                            return lineData[0];
                        }

                        @Override
                        public String getName() {
                            return lineData[0];
                        }

                        @Override
                        public String getCode() {
                            return lineData[1].split("\\|")[0];
                        }

                        @Override
                        public String getAltCode() {
                            return lineData[1].split("\\|").length > 1 ? lineData[1].split("\\|")[1] : this.getCode();
                        }

                        @Override
                        public FTSDataColumnI.DataTypeI getDataType() {
                            final String[] dataTypeString = lineData[2].split("\\|");
                            final String classString = dataTypeString[0].toUpperCase();
                            return new FTSDataColumnI.DataTypeI(){

                                @Override
                                public boolean isFormtted() {
                                    if (dataTypeString.length > 1 && dataTypeString[1] != null) {
                                        switch (dataTypeString[1].toUpperCase()) {
                                            case "T": 
                                            case "TRUE": {
                                                return true;
                                            }
                                        }
                                        return false;
                                    }
                                    return false;
                                }

                                @Override
                                public int getSignificantFigures() {
                                    if (dataTypeString.length > 2 && dataTypeString[2] != null) {
                                        return Integer.valueOf(dataTypeString[2]);
                                    }
                                    return 0;
                                }

                                @Override
                                public Class getDataTypeClass() {
                                    switch (classString) {
                                        case "INT": 
                                        case "INTEGER": {
                                            return Integer.class;
                                        }
                                        case "DOUBLE": {
                                            return Double.class;
                                        }
                                    }
                                    return String.class;
                                }
                            };
                        }

                        @Override
                        public FTSDataColumnI.FTSDataColumnGroupI getGroup() {
                            FTSDataColumnI.FTSDataColumnGroupI group = null;
                            try {
                                group = FTSRestClient.this.getDataColumnGroupById(lineData[3]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return group;
                        }

                        @Override
                        public int getMinWidth() {
                            return Integer.valueOf(lineData[4]);
                        }

                        @Override
                        public int getMaxWidth() {
                            return Integer.valueOf(lineData[5]);
                        }

                        @Override
                        public int getPreferredWidth() {
                            return Integer.valueOf(lineData[6]);
                        }

                        @Override
                        public boolean isPrimaryKeyColumn() {
                            return this.getName().equalsIgnoreCase(FTSRestClient.this.primaryKeyColumnCode) || this.getCode().equalsIgnoreCase(FTSRestClient.this.primaryKeyColumnCode);
                        }

                        @Override
                        public boolean isVisibleByDefault() {
                            return Boolean.valueOf(lineData[7]);
                        }

                        @Override
                        public boolean isSearchable() {
                            return Boolean.valueOf(lineData[8]);
                        }

                        public int hashCode() {
                            return Objects.hash(this.getName(), this.getCode(), this.getGroup());
                        }

                        public boolean equals(Object otherObject) {
                            FTSDataColumnI that = (FTSDataColumnI)otherObject;
                            return otherObject == null ? false : this.getCode().equals(that.getCode()) && this.getName().equals(that.getName()) && this.getGroup().equals(that.getGroup());
                        }
                    };
                    this.dataColumns.add(dataCol);
                    if (dataCol.isSearchable()) {
                        this.searchableDataColumns.add(dataCol);
                    }
                    if (!dataCol.isVisibleByDefault()) continue;
                    this.defaulDisplayedDataColumns.add(dataCol);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.primaryKeyColumn = this.getDataColumnByNameOrCode(this.primaryKeyColumnCode);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getPrimaryKeyColumIndex(Collection<FTSDataColumnI> wantedFields, boolean hasRefSeq) throws Exception {
        int pdbFieldIndexCounter = hasRefSeq ? 1 : 0;
        for (FTSDataColumnI field : wantedFields) {
            if (field.isPrimaryKeyColumn()) break;
            ++pdbFieldIndexCounter;
        }
        return pdbFieldIndexCounter;
    }

    @Override
    public String getDataColumnsFieldsAsCommaDelimitedString(Collection<FTSDataColumnI> dataColumnFields) {
        String result = "";
        if (dataColumnFields != null && !dataColumnFields.isEmpty()) {
            StringBuilder returnedFields = new StringBuilder();
            for (FTSDataColumnI field : dataColumnFields) {
                returnedFields.append(",").append(field.getCode());
            }
            returnedFields.deleteCharAt(0);
            result = returnedFields.toString();
        }
        return result;
    }

    @Override
    public Collection<FTSDataColumnI> getAllFTSDataColumns() {
        if (this.dataColumns == null || this.dataColumns.isEmpty()) {
            this.parseDataColumnsConfigFile();
        }
        return this.dataColumns;
    }

    @Override
    public Collection<FTSDataColumnI> getSearchableDataColumns() {
        if (this.searchableDataColumns == null || this.searchableDataColumns.isEmpty()) {
            this.parseDataColumnsConfigFile();
        }
        return this.searchableDataColumns;
    }

    @Override
    public Collection<FTSDataColumnI> getAllDefaultDisplayedFTSDataColumns() {
        if (this.defaulDisplayedDataColumns == null || this.defaulDisplayedDataColumns.isEmpty()) {
            this.parseDataColumnsConfigFile();
        }
        return this.defaulDisplayedDataColumns;
    }

    @Override
    public FTSDataColumnI getPrimaryKeyColumn() {
        if (this.defaulDisplayedDataColumns == null || this.defaulDisplayedDataColumns.isEmpty()) {
            this.parseDataColumnsConfigFile();
        }
        return this.primaryKeyColumn;
    }

    @Override
    public FTSDataColumnI getDataColumnByNameOrCode(String nameOrCode) throws Exception {
        if (this.dataColumns == null || this.dataColumns.isEmpty()) {
            this.parseDataColumnsConfigFile();
        }
        for (FTSDataColumnI column : this.dataColumns) {
            if (!column.getName().equalsIgnoreCase(nameOrCode) && !column.getCode().equalsIgnoreCase(nameOrCode)) continue;
            return column;
        }
        throw new Exception("Couldn't find data column with name : " + nameOrCode);
    }

    @Override
    public FTSDataColumnI.FTSDataColumnGroupI getDataColumnGroupById(String id) throws Exception {
        if (this.dataColumns == null || this.dataColumns.isEmpty()) {
            this.parseDataColumnsConfigFile();
        }
        for (FTSDataColumnI.FTSDataColumnGroupI columnGroup : this.dataColumnGroups) {
            if (!columnGroup.getID().equalsIgnoreCase(id)) continue;
            return columnGroup;
        }
        throw new Exception("Couldn't find data column group with id : " + id);
    }

    public static String getMessageByHTTPStatusCode(int code, String service) {
        Object message = "";
        switch (code) {
            case 400: {
                message = "Bad request. There is a problem with your input.";
                break;
            }
            case 410: {
                message = service + " rest services no longer available!";
                break;
            }
            case 403: 
            case 404: {
                message = "The requested resource could not be found";
                break;
            }
            case 408: 
            case 409: 
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                message = "There seems to be an error from the " + service + " server";
                break;
            }
            case 503: {
                message = "Service not available. The server is being updated, try again later.";
                break;
            }
        }
        return String.valueOf(code) + " " + (String)message;
    }

    protected String getResourceFile(String fileName) {
        String result = "";
        try {
            result = this.getClass().getResource(fileName).getFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public int getDefaultResponsePageSize() {
        if (this.dataColumns == null || this.dataColumns.isEmpty()) {
            this.parseDataColumnsConfigFile();
        }
        return this.defaultResponsePageSize;
    }
}

