/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.paradise;

import jalview.ext.paradise.RvalsIterator;
import jalview.util.MessageManager;
import jalview.ws.HttpClientUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Annotate3D {
    private static String twoDtoolsURL = "http://arn-ibmc.in2p3.fr/api/compute/2d?tool=rnaview";

    private static ContentHandler createContentHandler() {
        ContentHandler ch = new ContentHandler(){

            @Override
            public void startJSON() throws ParseException, IOException {
            }

            @Override
            public void endJSON() throws ParseException, IOException {
            }

            @Override
            public boolean startObject() throws ParseException, IOException {
                return false;
            }

            @Override
            public boolean endObject() throws ParseException, IOException {
                return false;
            }

            @Override
            public boolean startObjectEntry(String key) throws ParseException, IOException {
                return false;
            }

            @Override
            public boolean endObjectEntry() throws ParseException, IOException {
                return false;
            }

            @Override
            public boolean startArray() throws ParseException, IOException {
                return false;
            }

            @Override
            public boolean endArray() throws ParseException, IOException {
                return false;
            }

            @Override
            public boolean primitive(Object value) throws ParseException, IOException {
                return false;
            }
        };
        return ch;
    }

    public static Iterator<Reader> getRNAMLForPDBFileAsString(String pdbfile) throws Exception {
        ArrayList<NameValuePair> vals = new ArrayList<NameValuePair>();
        vals.add((NameValuePair)new BasicNameValuePair("tool", "rnaview"));
        vals.add((NameValuePair)new BasicNameValuePair("data", pdbfile));
        vals.add((NameValuePair)new BasicNameValuePair("output", "rnaml"));
        ArrayList<BufferedReader> readers = new ArrayList<BufferedReader>();
        BufferedReader postResponse = HttpClientUtils.doHttpUrlPost(twoDtoolsURL, vals, 0, 0);
        readers.add(postResponse);
        return readers.iterator();
    }

    public static Iterator<Reader> processJsonResponseFor(Reader respons) throws Exception {
        JSONParser jp = new JSONParser();
        try {
            RvalsIterator rvals = new RvalsIterator(respons);
            return rvals;
        }
        catch (Exception foo) {
            throw new Exception(MessageManager.getString("exception.couldnt_parse_responde_from_annotated3d_server"), foo);
        }
    }

    public static Iterator<Reader> getRNAMLForPDBId(String pdbid) throws Exception {
        ArrayList<BasicNameValuePair> vals = new ArrayList<BasicNameValuePair>();
        vals.add(new BasicNameValuePair("tool", "rnaview"));
        vals.add(new BasicNameValuePair("pdbid", pdbid));
        vals.add(new BasicNameValuePair("output", "rnaml"));
        URL geturl = new URL(twoDtoolsURL + "?tool=rnaview&pdbid=" + pdbid + "&output=rnaml");
        ArrayList<InputStreamReader> readers = new ArrayList<InputStreamReader>();
        readers.add(new InputStreamReader(geturl.openStream()));
        return readers.iterator();
    }
}

