/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.jmol;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureCommandsBase;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import jalview.util.Platform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JmolCommands
extends StructureCommandsBase {
    private static final StructureCommand SHOW_BACKBONE = new StructureCommand("select *; cartoons off; backbone", new String[0]);
    private static final StructureCommand FOCUS_VIEW = new StructureCommand("zoom 0", new String[0]);
    private static final StructureCommand COLOUR_ALL_WHITE = new StructureCommand("select *;color white;", new String[0]);
    private static final StructureCommandI COLOUR_BY_CHARGE = new StructureCommand("select *;color white;select ASP,GLU;color red;select LYS,ARG;color blue;select CYS;color yellow", new String[0]);
    private static final StructureCommandI COLOUR_BY_CHAIN = new StructureCommand("select *;color chain", new String[0]);
    private static final String PIPE = "|";
    private static final String HYPHEN = "-";
    private static final String COLON = ":";
    private static final String SLASH = "/";

    @Override
    public int getModelStartNo() {
        return 1;
    }

    protected String getColourString(Color c) {
        return c == null ? null : String.format("[%d,%d,%d]", c.getRed(), c.getGreen(), c.getBlue());
    }

    @Override
    public StructureCommandI colourByChain() {
        return COLOUR_BY_CHAIN;
    }

    @Override
    public List<StructureCommandI> colourByCharge() {
        return Arrays.asList(COLOUR_BY_CHARGE);
    }

    @Override
    public List<StructureCommandI> colourByResidues(Map<String, Color> colours) {
        List<StructureCommandI> cmds = super.colourByResidues(colours);
        cmds.add(0, COLOUR_ALL_WHITE);
        return cmds;
    }

    @Override
    public StructureCommandI setBackgroundColour(Color col) {
        return new StructureCommand("background " + this.getColourString(col), new String[0]);
    }

    @Override
    public StructureCommandI focusView() {
        return FOCUS_VIEW;
    }

    @Override
    public List<StructureCommandI> showChains(List<String> toShow) {
        StringBuilder atomSpec = new StringBuilder(128);
        boolean first = true;
        for (String chain : toShow) {
            String[] tokens = chain.split(COLON);
            if (tokens.length != 2) continue;
            if (!first) {
                atomSpec.append(" or ");
            }
            first = false;
            atomSpec.append(COLON).append(tokens[1]).append(" /").append(tokens[0]);
        }
        String spec = atomSpec.toString();
        String command = "select *;restrict " + spec + ";cartoon;center " + spec;
        return Arrays.asList(new StructureCommand(command, new String[0]));
    }

    @Override
    public List<StructureCommandI> superposeStructures(AtomSpecModel refAtoms, AtomSpecModel atomSpec) {
        StringBuilder sb = new StringBuilder(64);
        String refModel = refAtoms.getModels().iterator().next();
        String model2 = atomSpec.getModels().iterator().next();
        sb.append(String.format("compare {%s.1} {%s.1}", model2, refModel));
        sb.append(" SUBSET {(*.CA | *.P) and conformation=1} ATOMS {");
        sb.append(this.getAtomSpec(atomSpec, true)).append("}{");
        sb.append(this.getAtomSpec(refAtoms, true)).append("}");
        sb.append(" ROTATE TRANSLATE ");
        sb.append(this.getCommandSeparator());
        sb.append("select ").append(this.getAtomSpec(atomSpec, false)).append(PIPE);
        sb.append(this.getAtomSpec(refAtoms, false)).append(this.getCommandSeparator()).append("cartoons");
        return Arrays.asList(new StructureCommand(sb.toString(), new String[0]));
    }

    @Override
    public StructureCommandI openCommandFile(String path) {
        return new StructureCommand("script " + path, new String[0]);
    }

    @Override
    public StructureCommandI saveSession(String filepath) {
        return new StructureCommand("write STATE \"" + filepath + "\"", new String[0]);
    }

    @Override
    protected StructureCommandI colourResidues(String atomSpec, Color colour) {
        StringBuilder sb = new StringBuilder(atomSpec.length() + 20);
        sb.append("select ").append(atomSpec).append(this.getCommandSeparator()).append("color").append(this.getColourString(colour));
        return new StructureCommand(sb.toString(), new String[0]);
    }

    @Override
    protected String getResidueSpec(String residue) {
        return residue;
    }

    @Override
    public String getAtomSpec(AtomSpecModel model, boolean alphaOnly) {
        StringBuilder sb = new StringBuilder(128);
        boolean first = true;
        for (String modelNo : model.getModels()) {
            for (String chain : model.getChains(modelNo)) {
                for (int[] range : model.getRanges(modelNo, chain)) {
                    if (!first) {
                        sb.append(PIPE);
                    }
                    first = false;
                    if (range[0] == range[1]) {
                        sb.append(range[0]);
                    } else {
                        sb.append(range[0]).append(HYPHEN).append(range[1]);
                    }
                    sb.append(COLON).append(chain.trim()).append(SLASH);
                    sb.append(String.valueOf(modelNo)).append(".1");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public List<StructureCommandI> showBackbone() {
        return Arrays.asList(SHOW_BACKBONE);
    }

    @Override
    public StructureCommandI loadFile(String file) {
        return new StructureCommand("load FILES \"" + Platform.escapeBackslashes(file) + "\"", new String[0]);
    }

    @Deprecated
    public String[] colourBySequence(StructureSelectionManager ssm, String[] files, SequenceI[][] sequence, SequenceRenderer sr, AlignmentViewPanel viewPanel) {
        FeatureRenderer fr = viewPanel.getFeatureRenderer();
        FeatureColourFinder finder = new FeatureColourFinder(fr);
        AlignViewportI viewport = viewPanel.getAlignViewport();
        HiddenColumns cs = viewport.getAlignment().getHiddenColumns();
        AlignmentI al = viewport.getAlignment();
        ArrayList cset = new ArrayList();
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            StructureMapping[] mapping = ssm.getMapping(files[pdbfnum]);
            StringBuilder command = new StringBuilder(128);
            ArrayList<String> str = new ArrayList<String>();
            if (mapping == null || mapping.length < 1) continue;
            for (int s = 0; s < sequence[pdbfnum].length; ++s) {
                for (int m = 0; m < mapping.length; ++m) {
                    int sp;
                    if (mapping[m].getSequence() != sequence[pdbfnum][s] || (sp = al.findIndex(sequence[pdbfnum][s])) <= -1) continue;
                    int lastPos = Integer.MIN_VALUE;
                    SequenceI asp = al.getSequenceAt(sp);
                    for (int r = 0; r < asp.getLength(); ++r) {
                        int pos;
                        if (Comparison.isGap(asp.getCharAt(r)) || (pos = mapping[m].getPDBResNum(asp.findPosition(r))) == lastPos) continue;
                        if (pos == Integer.MIN_VALUE) {
                            if (command.length() > 0 && command.charAt(command.length() - 1) != ';') {
                                command.append(";");
                            }
                            lastPos = Integer.MIN_VALUE;
                            continue;
                        }
                        lastPos = pos;
                        Color col = sr.getResidueColour(sequence[pdbfnum][s], r, finder);
                        if (!cs.isVisible(r)) {
                            col = Color.GRAY;
                        }
                        String newSelcom = (String)(mapping[m].getChain() != " " ? COLON + mapping[m].getChain() : "") + SLASH + (pdbfnum + 1) + ".1;color" + this.getColourString(col);
                        if (command.length() > newSelcom.length() && command.substring(command.length() - newSelcom.length()).equals(newSelcom)) {
                            command = JmolCommands.condenseCommand(command, pos);
                            continue;
                        }
                        if (command.length() > 0 && command.charAt(command.length() - 1) != ';') {
                            command.append(";");
                        }
                        if (command.length() > 51200) {
                            str.add(command.toString());
                            command.setLength(0);
                        }
                        command.append("select " + pos);
                        command.append(newSelcom);
                    }
                }
            }
            str.add(command.toString());
            command.setLength(0);
            cset.addAll(str);
        }
        return cset.toArray(new String[cset.size()]);
    }

    @Deprecated
    private static StringBuilder condenseCommand(StringBuilder command, int pos) {
        int p;
        int q = p = command.length();
        do {
            if ((p -= 6) >= 1) continue;
            p = 0;
        } while ((q = command.indexOf("select", p)) == -1 && p > 0);
        StringBuilder sb = new StringBuilder(command.substring(0, q + 7));
        String start = (command = command.delete(0, q + 7)).indexOf(HYPHEN) > -1 ? command.substring(0, command.indexOf(HYPHEN)) : command.substring(0, command.indexOf(COLON));
        sb.append(start + HYPHEN + pos + command.substring(command.indexOf(COLON)));
        return sb;
    }

    @Override
    public StructureCommandI openSession(String filepath) {
        return this.loadFile(filepath);
    }

    @Override
    public StructureCommandI closeViewer() {
        return null;
    }
}

