/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.ext.ensembl.EnsemblXref;
import jalview.ext.ensembl.Species;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ParseException;

public class EnsemblSymbol
extends EnsemblXref {
    private static final String GENE = "gene";
    private static final String TYPE = "type";

    public EnsemblSymbol(String domain, String dbName, String dbVersion) {
        super(domain, dbName, dbVersion);
    }

    protected URL getUrl(String id, Species species, String ... type) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDomain()).append("/xrefs/symbol/").append(species.toString()).append("/").append(id).append("?content-type=application/json");
        for (String t : type) {
            sb.append("&object_type=").append(t);
        }
        try {
            String url = sb.toString();
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public List<String> getGeneIds(String identifier) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(identifier);
        String[] queries = identifier.split(this.getAccessionSeparator());
        try {
            for (String query : queries) {
                for (Species taxon : Species.getModelOrganisms()) {
                    String geneId = null;
                    try {
                        Iterator rvals = (Iterator)this.getJSON(this.getUrl(query, taxon, GENE), ids, -1, 2, null);
                        if (rvals == null) continue;
                        while (rvals.hasNext()) {
                            Map val = (Map)rvals.next();
                            String id = val.get("id").toString();
                            String type = val.get(TYPE).toString();
                            if (id == null || !GENE.equals(type)) continue;
                            geneId = id;
                            break;
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (geneId == null || result.contains(geneId)) continue;
                    result.add(geneId);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

