/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.features;

import jalview.datamodel.SequenceFeature;
import jalview.datamodel.features.FeatureMatcher;
import jalview.datamodel.features.FeatureMatcherI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.util.MessageManager;
import java.util.ArrayList;
import java.util.List;

public class FeatureMatcherSet
implements FeatureMatcherSetI {
    private static final String OR = "OR";
    private static final String AND = "AND";
    private static final String SPACE = " ";
    private static final String CLOSE_BRACKET = ")";
    private static final String OPEN_BRACKET = "(";
    private static final String OR_I18N = MessageManager.getString("label.or");
    private static final String AND_18N = MessageManager.getString("label.and");
    List<FeatureMatcherI> matchConditions = new ArrayList<FeatureMatcherI>();
    boolean andConditions;

    public static FeatureMatcherSet fromString(String descriptor) {
        String invalid = "Invalid descriptor: " + descriptor;
        boolean firstCondition = true;
        FeatureMatcherSet result = new FeatureMatcherSet();
        String leftToParse = descriptor.trim();
        while (leftToParse.length() > 0) {
            boolean and = true;
            if (!firstCondition) {
                int spacePos = leftToParse.indexOf(SPACE);
                if (spacePos == -1) {
                    System.err.println(invalid);
                    return null;
                }
                String conjunction = leftToParse.substring(0, spacePos);
                leftToParse = leftToParse.substring(spacePos + 1).trim();
                if (conjunction.equalsIgnoreCase(AND)) {
                    and = true;
                } else if (conjunction.equalsIgnoreCase(OR)) {
                    and = false;
                } else {
                    System.err.println(invalid);
                    return null;
                }
            }
            String nextCondition = leftToParse;
            if (leftToParse.startsWith(OPEN_BRACKET)) {
                int closePos = leftToParse.indexOf(CLOSE_BRACKET);
                if (closePos == -1) {
                    System.err.println(invalid);
                    return null;
                }
                nextCondition = leftToParse.substring(1, closePos);
                leftToParse = leftToParse.substring(closePos + 1).trim();
            } else {
                leftToParse = "";
            }
            FeatureMatcher fm = FeatureMatcher.fromString(nextCondition);
            if (fm == null) {
                System.err.println(invalid);
                return null;
            }
            try {
                if (and) {
                    result.and(fm);
                } else {
                    result.or(fm);
                }
                firstCondition = false;
            }
            catch (IllegalStateException e) {
                System.err.println(invalid);
                return null;
            }
        }
        return result;
    }

    @Override
    public boolean matches(SequenceFeature feature) {
        if (this.matchConditions.isEmpty()) {
            return true;
        }
        if (this.andConditions) {
            for (FeatureMatcherI m : this.matchConditions) {
                if (m.matches(feature)) continue;
                return false;
            }
            return true;
        }
        for (FeatureMatcherI m : this.matchConditions) {
            if (!m.matches(feature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void and(FeatureMatcherI m) {
        if (!this.andConditions && this.matchConditions.size() > 1) {
            throw new IllegalStateException("Can't add an AND to OR conditions");
        }
        this.matchConditions.add(m);
        this.andConditions = true;
    }

    @Override
    public void or(FeatureMatcherI m) {
        if (this.andConditions && this.matchConditions.size() > 1) {
            throw new IllegalStateException("Can't add an OR to AND conditions");
        }
        this.matchConditions.add(m);
        this.andConditions = false;
    }

    @Override
    public boolean isAnded() {
        return this.andConditions;
    }

    @Override
    public Iterable<FeatureMatcherI> getMatchers() {
        return this.matchConditions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean multiple = this.matchConditions.size() > 1;
        for (FeatureMatcherI matcher : this.matchConditions) {
            if (!first) {
                String joiner = this.andConditions ? AND_18N : OR_I18N;
                sb.append(SPACE).append(joiner.toLowerCase()).append(SPACE);
            }
            first = false;
            if (multiple) {
                sb.append(OPEN_BRACKET).append(matcher.toString()).append(CLOSE_BRACKET);
                continue;
            }
            sb.append(matcher.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.matchConditions == null || this.matchConditions.isEmpty();
    }

    @Override
    public String toStableString() {
        StringBuilder sb = new StringBuilder();
        boolean moreThanOne = this.matchConditions.size() > 1;
        boolean first = true;
        for (FeatureMatcherI matcher : this.matchConditions) {
            if (!first) {
                String joiner = this.andConditions ? AND : OR;
                sb.append(SPACE).append(joiner).append(SPACE);
            }
            first = false;
            if (moreThanOne) {
                sb.append(OPEN_BRACKET).append(matcher.toStableString()).append(CLOSE_BRACKET);
                continue;
            }
            sb.append(matcher.toStableString());
        }
        return sb.toString();
    }
}

