/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.ProfileI;
import jalview.datamodel.ResidueCount;

public class Profile
implements ProfileI {
    private ResidueCount counts;
    private int height;
    private int gapped;
    private int maxCount;
    private String modalResidue;

    public Profile(int seqCount, int gaps, int max, String modalRes) {
        this.height = seqCount;
        this.gapped = gaps;
        this.maxCount = max;
        this.modalResidue = modalRes;
    }

    @Override
    public void setCounts(ResidueCount residueCounts) {
        this.counts = residueCounts;
    }

    @Override
    public float getPercentageIdentity(boolean ignoreGaps) {
        if (this.height == 0) {
            return 0.0f;
        }
        float pid = 0.0f;
        pid = ignoreGaps && this.gapped < this.height ? (float)this.maxCount * 100.0f / (float)(this.height - this.gapped) : (float)this.maxCount * 100.0f / (float)this.height;
        return pid;
    }

    @Override
    public ResidueCount getCounts() {
        return this.counts;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getGapped() {
        return this.gapped;
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public String getModalResidue() {
        return this.modalResidue;
    }

    @Override
    public int getNonGapped() {
        return this.height - this.gapped;
    }
}

