/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.DBRefEntry;
import jalview.util.CaseInsensitiveString;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class PDBEntry {
    private static final String CHAIN_ID = "chain_code";
    private Hashtable<String, Object> properties;
    private static final int PDB_ID_LENGTH = 4;
    private String file;
    private String type;
    private String id;

    public boolean equals(Object obj) {
        boolean typeMatches;
        if (obj == null || !(obj instanceof PDBEntry)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PDBEntry o = (PDBEntry)obj;
        boolean idMatches = this.id == o.id || this.id != null && this.id.equalsIgnoreCase(o.id);
        boolean fileMatches = this.file == o.file || this.file != null && this.file.equals(o.file);
        boolean bl = typeMatches = this.type == o.type || this.type != null && this.type.equals(o.type);
        if (idMatches && fileMatches && typeMatches) {
            return this.properties == o.properties || this.properties != null && this.properties.equals(o.properties);
        }
        return false;
    }

    public PDBEntry() {
    }

    public PDBEntry(String pdbId, String chain, Type type, String filePath) {
        this.init(pdbId, chain, type, filePath);
    }

    void init(String pdbId, String chain, Type entryType, String filePath) {
        this.id = pdbId;
        this.type = entryType == null ? null : entryType.toString();
        this.file = filePath;
        this.setChainCode(chain);
    }

    public PDBEntry(PDBEntry entry) {
        this.file = entry.file;
        this.type = entry.type;
        this.id = entry.id;
        if (entry.properties != null) {
            this.properties = (Hashtable)entry.properties.clone();
        }
    }

    public PDBEntry(DBRefEntry dbr) {
        char chain;
        if (!"PDB".equals(dbr.getSource())) {
            throw new IllegalArgumentException("Invalid source: " + dbr.getSource());
        }
        String pdbId = dbr.getAccessionId();
        String chainCode = null;
        if (pdbId.length() == 5 && ('a' <= (chain = pdbId.charAt(4)) && chain <= 'z' || 'A' <= chain && chain <= 'Z')) {
            pdbId = pdbId.substring(0, 4);
            chainCode = String.valueOf(chain);
        }
        this.init(pdbId, chainCode, null, null);
    }

    public void setFile(String f) {
        this.file = f;
    }

    public String getFile() {
        return this.file;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setType(Type type) {
        this.type = type == null ? null : type.toString();
    }

    public String getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public Enumeration<String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyEnumeration();
        }
        return this.properties.keys();
    }

    public String getChainCode() {
        return this.properties == null || this.properties.get(CHAIN_ID) == null ? null : this.properties.get(CHAIN_ID).toString();
    }

    public void setChainCode(String chainCode) {
        if (chainCode == null) {
            this.deleteProperty(CHAIN_ID);
        } else {
            this.setProperty(CHAIN_ID, new CaseInsensitiveString(chainCode));
        }
    }

    Object deleteProperty(String key) {
        Object result = null;
        if (this.properties != null) {
            result = this.properties.remove(key);
        }
        return result;
    }

    public String toString() {
        return this.id;
    }

    @Deprecated
    public Hashtable<String, Object> getProps() {
        return this.properties;
    }

    @Deprecated
    public void setProps(Hashtable<String, Object> props) {
        this.properties = props;
    }

    public boolean updateFrom(PDBEntry newEntry) {
        if (this.equals(newEntry)) {
            return true;
        }
        String newId = newEntry.getId();
        if (newId == null || this.getId() == null) {
            return false;
        }
        if (!this.getId().equalsIgnoreCase(newId)) {
            return false;
        }
        String newFile = newEntry.getFile();
        if (newFile != null && this.getFile() != null && !newFile.equals(this.getFile())) {
            return false;
        }
        String newChain = newEntry.getChainCode();
        if (newChain != null && newChain.length() > 0 && this.getChainCode() != null && this.getChainCode().length() > 0 && !this.getChainCode().equalsIgnoreCase(newChain)) {
            return false;
        }
        String newType = newEntry.getType();
        if (this.getFile() == null && newFile != null) {
            this.setFile(newFile);
            this.setType(newType);
        }
        if (this.getType() == null && newType != null) {
            this.setType(newType);
        }
        if (newChain != null && newChain.length() > 0 && !newChain.equalsIgnoreCase(this.getChainCode())) {
            this.setChainCode(newChain);
        }
        Enumeration<String> newProps = newEntry.getProperties();
        while (newProps.hasMoreElements()) {
            String key = newProps.nextElement();
            Object value = newEntry.getProperty(key);
            if (value.equals(this.getProperty(key))) continue;
            this.setProperty(key, value);
        }
        return true;
    }

    public static enum Type {
        PDB("pdb", "pdb"),
        MMCIF("mmcif", "cif"),
        FILE("?", "?");

        String ext;
        String format;

        private Type(String fmt, String ex) {
            this.format = fmt;
            this.ext = ex;
        }

        public String getFormat() {
            return this.format;
        }

        public String getExtension() {
            return this.ext;
        }

        public static Type getType(String value) {
            for (Type t : Type.values()) {
                if (!t.toString().equalsIgnoreCase(value)) continue;
                return t;
            }
            return null;
        }

        public boolean matches(String t) {
            return this.toString().equalsIgnoreCase(t);
        }
    }
}

